/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.nlp.stanfordnlp;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filters;
import io.redlink.nlp.api.ProcessingData;
import io.redlink.nlp.api.Processor;
import io.redlink.nlp.model.AnalyzedText;
import io.redlink.nlp.model.Chunk;
import io.redlink.nlp.model.NlpAnnotations;
import io.redlink.nlp.model.Sentence;
import io.redlink.nlp.model.Span;
import io.redlink.nlp.model.Token;
import io.redlink.nlp.model.dep.RelTag;
import io.redlink.nlp.model.dep.Relation;
import io.redlink.nlp.model.ner.NerTag;
import io.redlink.nlp.model.phrase.PhraseTag;
import io.redlink.nlp.model.pos.PosTag;
import io.redlink.nlp.model.util.NlpUtils;
import io.redlink.nlp.stanfordnlp.StanfordNlpPipeline;
import io.redlink.nlp.stanfordnlp.annotators.AnalyzedTextSectionAnnotator;
import io.redlink.nlp.stanfordnlp.sentiment.LinearSentimentClassMapping;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.ejml.simple.SimpleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={AnnotationPipeline.class})
public class StanfordNlpProcessor
extends Processor {
    private static final Logger LOG = LoggerFactory.getLogger(StanfordNlpProcessor.class);
    private static final int CONTENT_INTERRUPTION = 80;
    private final List<StanfordNlpPipeline> pipelines;
    private final Map<String, StanfordNlpPipeline> lang2Pipeline;
    private boolean writeDependent = true;

    @Autowired
    public StanfordNlpProcessor(List<StanfordNlpPipeline> pipelines) {
        super("stanfordnlp", "Stanford NLP", Processor.Phase.pos);
        LOG.debug("Create {} (with {} NER Models)", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)pipelines.size());
        this.pipelines = pipelines;
        this.lang2Pipeline = new HashMap<String, StanfordNlpPipeline>();
    }

    public Map<String, Object> getDefaultConfiguration() {
        return new HashMap<String, Object>();
    }

    protected void init() {
        for (StanfordNlpPipeline pipeline : this.pipelines) {
            String lang = pipeline.getLanguage();
            if (StringUtils.isNotBlank((CharSequence)lang)) {
                if (this.lang2Pipeline.containsKey(lang = lang.toLowerCase(Locale.ROOT))) {
                    LOG.warn("Multiple pipelines defined for Language {} (present: {} | ignored: {}", new Object[]{lang, this.lang2Pipeline.get(lang).getName(), pipeline.getName()});
                    continue;
                }
                try {
                    pipeline.activate();
                    this.lang2Pipeline.put(lang, pipeline);
                }
                catch (IOException e) {
                    LOG.warn("Unable to activate " + pipeline, (Throwable)e);
                }
                continue;
            }
            LOG.warn("Pipeline '{}' does not define a Language tag", (Object)pipeline.getName());
        }
    }

    @PreDestroy
    protected void destroyNerModels() {
        this.lang2Pipeline.clear();
        for (StanfordNlpPipeline pipeline : this.pipelines) {
            if (!pipeline.isActive()) continue;
            pipeline.deactivate();
        }
    }

    private StanfordNlpPipeline getPipeline(String language) {
        StanfordNlpPipeline model = this.lang2Pipeline.get(language == null ? null : language.toLowerCase(Locale.ROOT));
        return model != null && model.isActive() ? model : null;
    }

    protected void doProcessing(ProcessingData processingData) {
        LOG.debug("> process {} with {}", (Object)processingData, (Object)((Object)((Object)this)).getClass().getSimpleName());
        String language = processingData.getLanguage();
        AnalyzedText at = NlpUtils.getOrInitAnalyzedText((ProcessingData)processingData);
        LOG.debug(" - language: {}", (Object)language);
        if (language == null || language.length() < 2) {
            LOG.warn("Unable to preprocess conversation {} because missing/invalid language {}", (Object)processingData, (Object)language);
            return;
        }
        Locale locale = Locale.forLanguageTag(language);
        StanfordNlpPipeline pipeline = this.getPipeline(language);
        if (pipeline == null) {
            LOG.debug("Unable to preprocess conversation {} because language {} is not supported", (Object)processingData, (Object)language);
            return;
        }
        Annotation document = new Annotation(pipeline.isCaseSensitive() ? NlpUtils.toTrueCase((Span)at) : at.getSpan().toLowerCase(locale));
        document.set(AnalyzedTextSectionAnnotator.AnalyzedTextAnnotation.class, (Object)at);
        pipeline.getPipeline().annotate(document);
        LinearSentimentClassMapping sentClassMapping = null;
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            Tree tree;
            Token sentStart = null;
            Token sentEnd = null;
            Token nerStart = null;
            Token nerEnd = null;
            NerTag nerTag = null;
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            SemanticGraph dependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            int tokenIdxInSentence = 0;
            for (CoreLabel token : tokens) {
                String lemma;
                String ne;
                if (token.beginPosition() >= token.endPosition()) {
                    LOG.warn("Illegal Token start:{}/end:{} values -> ignored", (Object)token.beginPosition(), (Object)token.endPosition());
                    continue;
                }
                Token t = at.addToken(token.beginPosition(), token.endPosition());
                if (sentStart == null) {
                    sentStart = t;
                }
                sentEnd = t;
                String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                PosTag posTag = pipeline.getPosTag(pos);
                if (posTag != null) {
                    LOG.trace(" > '{}' pos: {}", (Object)t.getSpan(), (Object)posTag);
                    t.addAnnotation(NlpAnnotations.POS_ANNOTATION, (Object)posTag);
                }
                NerTag actNerTag = (ne = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class)) != null && !"O".equals(ne) ? pipeline.getNerTag(ne) : null;
                if (nerTag != null && !nerTag.equals(actNerTag)) {
                    Chunk nerChunk = at.addChunk(nerStart.getStart(), nerEnd.getEnd());
                    nerChunk.addAnnotation(NlpAnnotations.NER_ANNOTATION, (Object)nerTag);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" - add Named Entity {} |\u00a0tag: {}", (Object)nerChunk.getSpan(), (Object)nerTag);
                    }
                    nerTag = null;
                    nerStart = null;
                    nerEnd = null;
                }
                if (actNerTag != null) {
                    if (nerStart == null) {
                        nerStart = t;
                    }
                    nerTag = actNerTag;
                    nerEnd = t;
                }
                if ((lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class)) != null && !lemma.equals(t.getSpan())) {
                    t.addAnnotation(NlpAnnotations.LEMMA_ANNOTATION, (Object)lemma);
                }
                if (dependencies == null) continue;
                this.addDependencyRelations(tokens, t, at, pipeline, dependencies, ++tokenIdxInSentence);
            }
            Sentence sent = at.addSentence(sentStart.getStart(), sentEnd.getEnd());
            LOG.trace("-- {} {}", (Object)sent, (Object)sent.getSpan());
            if (dependencies != null) {
                Collection roots = dependencies.getRoots();
                RelTag rootRelTag = pipeline.getRelationTag("root");
                for (IndexedWord vertex : roots) {
                    Token root = at.addToken(vertex.beginPosition(), vertex.endPosition());
                    Relation rootRel = new Relation(rootRelTag, false, (Span)root);
                    sent.addAnnotation(NlpAnnotations.DEPENDENCY_ANNOTATION, (Object)rootRel);
                    LOG.debug(" - {}", (Object)rootRel);
                    if (!this.writeDependent) continue;
                    root.addAnnotation(NlpAnnotations.DEPENDENCY_ANNOTATION, (Object)new Relation(rootRelTag, true, (Span)sent));
                }
            }
            if ((tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class)) != null) {
                Predicate punctuationFilter = pipeline.getLanguagePack() != null ? pipeline.getLanguagePack().punctuationTagRejectFilter() : Filters.acceptFilter();
                LOG.debug(" - process ParseTree");
                if (LOG.isDebugEnabled()) {
                    TreePrint tp = new TreePrint("oneline", pipeline.getLanguagePack());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    tp.printTree(tree, pw);
                    pw.flush();
                    LOG.debug(" - tree: {}", (Object)sw);
                }
                LinkedList<Tree> toProcess = new LinkedList<Tree>();
                toProcess.add(tree);
                while (!toProcess.isEmpty()) {
                    tree = (Tree)toProcess.remove(0);
                    toProcess.addAll(0, tree.getChildrenAsList());
                    if (!tree.isPhrasal() || !(tree.label() instanceof CoreMap) || "ROOT".equals(tree.value()) || !punctuationFilter.test(tree.value())) continue;
                    CoreMap value = (CoreMap)tree.label();
                    value.get(CoreAnnotations.CategoryAnnotation.class);
                    String tag = tree.value();
                    PhraseTag phraseTag = pipeline.getPhraseTag(tag);
                    int beginTokenIdx = (Integer)value.get(CoreAnnotations.BeginIndexAnnotation.class);
                    int endTokenIdx = (Integer)value.get(CoreAnnotations.EndIndexAnnotation.class);
                    Chunk chunk = at.addChunk(((CoreLabel)tokens.get(beginTokenIdx)).beginPosition(), ((CoreLabel)tokens.get(endTokenIdx - 1)).endPosition());
                    chunk.addAnnotation(NlpAnnotations.PHRASE_ANNOTATION, (Object)phraseTag);
                    LOG.debug("    add {} ({}) - {}", new Object[]{chunk, phraseTag.getTag(), chunk.getSpan()});
                }
            }
            String sentimentClass = (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class);
            Tree sentimentTree = (Tree)sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
            if (sentimentTree != null) {
                SimpleMatrix predictions = RNNCoreAnnotations.getPredictions((Tree)sentimentTree);
                int size = predictions.getNumElements();
                if (sentClassMapping == null) {
                    LOG.debug(" - {} sentiment classes detected", (Object)size);
                    sentClassMapping = new LinearSentimentClassMapping(size);
                }
                if (LOG.isDebugEnabled()) {
                    double[] values = new double[size];
                    for (int i = 0; i < size; ++i) {
                        values[i] = predictions.get(i);
                    }
                    LOG.debug(" - sentiment: {}[classes: {}]", new Object[]{sentimentClass, Arrays.toString(values)});
                }
                double sentimentValue = 0.0;
                for (int idx = 0; idx < size; ++idx) {
                    double idxSent = sentClassMapping.getIndexWeight(idx);
                    if (!Double.isNaN(idxSent)) {
                        sentimentValue += predictions.get(idx) * idxSent;
                        continue;
                    }
                    sentimentValue = Double.NaN;
                    break;
                }
                if (!Double.isNaN(sentimentValue)) {
                    sent.addAnnotation(NlpAnnotations.SENTIMENT_ANNOTATION, (Object)sentimentValue);
                }
            }
            sentStart = null;
            sentEnd = null;
            if (nerTag == null) continue;
            Chunk nerChunk = at.addChunk(nerStart.getStart(), nerEnd.getEnd());
            nerChunk.addAnnotation(NlpAnnotations.NER_ANNOTATION, (Object)nerTag);
        }
    }

    private void addDependencyRelations(List<CoreLabel> tokens, Token currentToken, AnalyzedText at, StanfordNlpPipeline pipeline, SemanticGraph dependencies, int currentTokenIdx) {
        LOG.debug(" - dependency relations");
        IndexedWord vertex = dependencies.getNodeByIndexSafe(currentTokenIdx);
        if (vertex == null) {
            return;
        }
        ArrayList edges = new ArrayList();
        edges.addAll(dependencies.outgoingEdgeList(vertex));
        if (this.writeDependent) {
            edges.addAll(dependencies.incomingEdgeList(vertex));
        }
        for (SemanticGraphEdge edge : edges) {
            int govIndex = edge.getGovernor().index();
            int depIndex = edge.getDependent().index();
            GrammaticalRelation gramRel = edge.getRelation();
            RelTag relTag = pipeline.getRelationTag(gramRel.getShortName());
            if (relTag != null) {
                boolean isDependent = false;
                Token partner = null;
                if (govIndex == currentTokenIdx) {
                    CoreLabel dependentLabel = tokens.get(depIndex - 1);
                    partner = at.addToken(dependentLabel.beginPosition(), dependentLabel.endPosition());
                } else if (depIndex == currentTokenIdx) {
                    isDependent = true;
                    CoreLabel governorLabel = tokens.get(govIndex - 1);
                    partner = at.addToken(governorLabel.beginPosition(), governorLabel.endPosition());
                }
                if (!this.writeDependent && isDependent) continue;
                Relation relation = new Relation(relTag, isDependent, partner);
                LOG.debug(" - {}", (Object)relation);
                currentToken.addAnnotation(NlpAnnotations.DEPENDENCY_ANNOTATION, (Object)relation);
                continue;
            }
            LOG.warn("Missing GrammaticalRelationTag for {}!", (Object)gramRel.getShortName());
        }
    }
}

