/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.nlp.stanfordnlp;

import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Lazy;
import io.redlink.nlp.model.dep.RelTag;
import io.redlink.nlp.model.ner.NerTag;
import io.redlink.nlp.model.phrase.PhraseTag;
import io.redlink.nlp.model.pos.PosTag;
import io.redlink.nlp.model.tag.TagSet;
import io.redlink.nlp.stanfordnlp.annotators.AnalyzedTextSectionAnnotator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StanfordNlpPipeline {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private AnnotatorImplementations annotatorImplementation = new AnnotatorImplementations();
    private final String name;
    private final Locale locale;
    private boolean activated;
    private Properties properties;
    private AnnotationPipeline pipeline;
    private AnnotatorPool pool;
    private final Map<String, PosTag> adhocPosTags = new HashMap<String, PosTag>();
    private final Map<String, NerTag> adhocNerTags = new HashMap<String, NerTag>();
    private final Map<String, RelTag> adhocRelTags = new HashMap<String, RelTag>();
    private Map<String, PhraseTag> adhocPhraseTags = new HashMap<String, PhraseTag>();
    private List<String> annotators;
    private boolean caseSensitive = true;

    protected StanfordNlpPipeline(String name, Locale locale) {
        assert (StringUtils.isNotBlank((CharSequence)name));
        this.name = name;
        assert (locale != null);
        this.locale = locale;
    }

    protected abstract TagSet<PosTag> getPosTagset();

    protected abstract TagSet<NerTag> getNerTagset();

    protected abstract TagSet<PhraseTag> getPhraseTagset();

    protected abstract TagSet<RelTag> getRelTagset();

    public abstract TreebankLanguagePack getLanguagePack();

    protected final void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public List<String> getAnnotators() {
        return this.annotators;
    }

    public Annotator getAnnotator(String name) {
        return this.pool.get(name);
    }

    protected final void setAnnotatorImplementation(AnnotatorImplementations annotatorImplementation) {
        this.annotatorImplementation = annotatorImplementation;
    }

    public final void activate() throws IOException {
        this.log.info("> activating {} (locale: {})", (Object)this.getClass().getSimpleName(), (Object)this.locale);
        if (this.properties == null) {
            throw new IllegalStateException("The properties MUST BE set before activation!");
        }
        this.annotators = Collections.unmodifiableList(Arrays.asList(this.properties.getProperty("annotators", "").split("[, \t]+")));
        assert (!this.annotators.isEmpty());
        this.initAnnotatorPool(this.properties);
        this.pipeline = new AnnotationPipeline();
        for (String annotatorName : this.annotators) {
            Annotator annotator = this.pool.get(annotatorName);
            if (annotator == null) {
                throw new IllegalStateException("Unable to instantiate Annotator '" + annotatorName + "' used by Pipeline " + this.annotators + "!");
            }
            this.pipeline.addAnnotator(annotator);
        }
        this.doActivate();
        this.activated = true;
    }

    protected void doActivate() {
    }

    protected void initAnnotatorPool(Properties properties) {
        this.log.debug("init pipeline with {}", (Object)properties);
        HashSet<String> annotators = new HashSet<String>(this.annotators);
        this.pool = new AnnotatorPool();
        this.log.debug("Initializing Annotator Pool");
        if (annotators.remove("tokenize")) {
            this.pool.register("tokenize", properties, Lazy.cache(() -> this.annotatorImplementation.tokenizer(properties)));
        }
        if (annotators.remove("cleanxml")) {
            this.pool.register("cleanxml", properties, Lazy.cache(() -> this.annotatorImplementation.cleanXML(properties)));
        }
        if (annotators.remove("ssplit")) {
            this.pool.register("ssplit", properties, Lazy.cache(() -> this.annotatorImplementation.wordToSentences(properties)));
        }
        if (annotators.remove("pos")) {
            this.pool.register("pos", properties, Lazy.cache(() -> this.annotatorImplementation.posTagger(properties)));
        }
        if (annotators.remove("lemma")) {
            this.pool.register("lemma", properties, Lazy.cache(() -> this.annotatorImplementation.morpha(properties, false)));
        }
        if (annotators.remove("ner")) {
            this.pool.register("ner", properties, Lazy.cache(() -> this.annotatorImplementation.ner(properties)));
        }
        if (annotators.remove("tokensregex")) {
            this.pool.register("tokensregex", properties, Lazy.cache(() -> this.annotatorImplementation.tokensregex(properties, "tokensregex")));
        }
        if (annotators.remove("regexner")) {
            this.pool.register("regexner", properties, Lazy.cache(() -> this.annotatorImplementation.tokensRegexNER(properties, "regexner")));
        }
        if (annotators.remove("entitymentions")) {
            this.pool.register("entitymentions", properties, Lazy.cache(() -> this.annotatorImplementation.entityMentions(properties, "entitymentions")));
        }
        if (annotators.remove("gender")) {
            this.pool.register("gender", properties, Lazy.cache(() -> this.annotatorImplementation.gender(properties, false)));
        }
        if (annotators.remove("truecase")) {
            this.pool.register("truecase", properties, Lazy.cache(() -> this.annotatorImplementation.trueCase(properties)));
        }
        if (annotators.remove("parse")) {
            this.pool.register("parse", properties, Lazy.cache(() -> this.annotatorImplementation.parse(properties)));
        }
        if (annotators.remove("mention")) {
            this.pool.register("mention", properties, Lazy.cache(() -> this.annotatorImplementation.mention(properties)));
        }
        if (annotators.contains("dcoref")) {
            this.pool.register("dcoref", properties, Lazy.cache(() -> this.annotatorImplementation.dcoref(properties)));
        }
        if (annotators.remove("coref")) {
            this.pool.register("coref", properties, Lazy.cache(() -> this.annotatorImplementation.coref(properties)));
        }
        if (annotators.remove("relation")) {
            this.pool.register("relation", properties, Lazy.cache(() -> this.annotatorImplementation.relations(properties)));
        }
        if (annotators.remove("sentiment")) {
            this.pool.register("sentiment", properties, Lazy.cache(() -> this.annotatorImplementation.sentiment(properties, "sentiment")));
        }
        if (annotators.remove("cdc")) {
            this.pool.register("cdc", properties, Lazy.cache(() -> this.annotatorImplementation.columnData(properties)));
        }
        if (annotators.remove("depparse")) {
            this.pool.register("depparse", properties, Lazy.cache(() -> this.annotatorImplementation.dependencies(properties)));
        }
        if (annotators.remove("natlog")) {
            this.pool.register("natlog", properties, Lazy.cache(() -> this.annotatorImplementation.natlog(properties)));
        }
        if (annotators.remove("openie")) {
            this.pool.register("openie", properties, Lazy.cache(() -> this.annotatorImplementation.openie(properties)));
        }
        if (annotators.remove("quote")) {
            this.pool.register("quote", properties, Lazy.cache(() -> this.annotatorImplementation.quote(properties)));
        }
        if (annotators.remove("udfeats")) {
            this.pool.register("udfeats", properties, Lazy.cache(() -> this.annotatorImplementation.udfeats(properties)));
        }
        if (annotators.remove("atSection")) {
            this.pool.register("atSection", properties, Lazy.cache(() -> new AnalyzedTextSectionAnnotator()));
        }
        for (String property : properties.stringPropertyNames()) {
            if (!property.startsWith("customAnnotatorClass.")) continue;
            String customName = property.substring("customAnnotatorClass.".length());
            String customClassName = properties.getProperty(property);
            if (!annotators.remove(customName)) continue;
            this.log.debug("Registering annotator " + customName + " with class " + customClassName);
            this.pool.register(customName, properties, Lazy.cache(() -> this.annotatorImplementation.custom(properties, property)));
        }
        if (!annotators.isEmpty()) {
            this.log.error("Unable to initialize Stanford NLP Pipeline for {} becuse of {} missing Annotator(s) {}", new Object[]{this.locale, annotators.size(), annotators});
            throw new IllegalStateException("Missing Required Annotators " + annotators);
        }
    }

    public final boolean isActive() {
        return this.activated;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final String getLanguage() {
        Locale l = this.getLocale();
        return l == null ? null : l.getLanguage();
    }

    public final String getName() {
        return this.name;
    }

    public final AnnotationPipeline getPipeline() {
        return this.pipeline;
    }

    public final PosTag getPosTag(String tag) {
        PosTag posTag;
        TagSet<PosTag> posTagset = this.getPosTagset();
        PosTag posTag2 = posTag = posTagset == null ? null : (PosTag)posTagset.getTag(tag);
        if (posTag != null) {
            return posTag;
        }
        posTag = this.adhocPosTags.get(tag);
        if (posTag != null) {
            return posTag;
        }
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            posTag = new PosTag(tag);
            this.adhocPosTags.put(tag, posTag);
            this.log.info("Encountered umapped POS tag '{}' for langauge '{}'", (Object)tag, (Object)this.locale.getLanguage());
            return posTag;
        }
        return null;
    }

    public final NerTag getNerTag(String tag) {
        NerTag nerTag;
        TagSet<NerTag> nerTagset = this.getNerTagset();
        NerTag nerTag2 = nerTag = nerTagset == null ? null : (NerTag)nerTagset.getTag(tag);
        if (nerTag != null) {
            return nerTag;
        }
        nerTag = this.adhocNerTags.get(tag);
        if (nerTag != null) {
            return nerTag;
        }
        nerTag = StringUtils.isBlank((CharSequence)tag) ? new NerTag(tag, "unk") : new NerTag(tag, "misc");
        this.adhocNerTags.put(tag, nerTag);
        this.log.info("Encountered umapped Ner tag '{}' for langauge '{}'", (Object)tag, (Object)this.locale.getLanguage());
        return nerTag;
    }

    public final RelTag getRelationTag(String tag) {
        RelTag relTag;
        TagSet<RelTag> relTagset = this.getRelTagset();
        RelTag relTag2 = relTag = relTagset == null ? null : (RelTag)relTagset.getTag(tag);
        if (relTag != null) {
            return relTag;
        }
        relTag = this.adhocRelTags.get(tag);
        if (relTag != null) {
            return relTag;
        }
        relTag = new RelTag(tag);
        this.adhocRelTags.put(tag, relTag);
        this.log.info("Encountered umapped gramatical relation tag '{}' for langauge '{}'", (Object)tag, (Object)this.locale.getLanguage());
        return relTag;
    }

    public final PhraseTag getPhraseTag(String tag) {
        PhraseTag phraseTag;
        TagSet<PhraseTag> phraseTagset = this.getPhraseTagset();
        PhraseTag phraseTag2 = phraseTag = phraseTagset == null ? null : (PhraseTag)phraseTagset.getTag(tag);
        if (phraseTag != null) {
            return phraseTag;
        }
        phraseTag = this.adhocPhraseTags.get(tag);
        if (phraseTag != null) {
            return phraseTag;
        }
        phraseTag = new PhraseTag(tag);
        this.adhocPhraseTags.put(tag, phraseTag);
        this.log.info("Encountered umapped phrase tag '{}' for langauge '{}'", (Object)tag, (Object)this.locale.getLanguage());
        return phraseTag;
    }

    public final void deactivate() {
        this.activated = false;
        this.doDeactivate();
        this.pipeline = null;
        this.pool = null;
    }

    protected void doDeactivate() {
    }

    public String toString() {
        return "StanfordNlpPipeline [name=" + this.name + ", locale=" + this.locale + ", activated=" + this.activated + ", annotators=" + this.annotators + "]";
    }
}

