/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.nlp.opennlp.en;

import io.redlink.nlp.model.pos.LexicalCategory;
import io.redlink.nlp.model.pos.Pos;
import io.redlink.nlp.model.pos.PosTag;
import io.redlink.nlp.model.tag.Tag;
import io.redlink.nlp.model.tag.TagSet;
import io.redlink.nlp.opennlp.pos.OpenNlpLanguageModel;
import java.util.Locale;
import org.springframework.stereotype.Service;

@Service
public class LanguageEnglish
extends OpenNlpLanguageModel {
    public static final TagSet<PosTag> ENGLISH_PENN_TREEBANK = new TagSet("Penn Treebank", new String[]{"en"});

    public LanguageEnglish() {
        super(Locale.ENGLISH, ENGLISH_PENN_TREEBANK, "en-sent.bin", "en-token.bin", "en-pos-maxent.bin");
    }

    static {
        ENGLISH_PENN_TREEBANK.getProperties().put("olia.annotationModel", "http://purl.org/olia/penn.owl");
        ENGLISH_PENN_TREEBANK.getProperties().put("olia.linkingModel", "http://purl.org/olia/penn-link.rdf");
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("CC", Pos.CoordinatingConjunction, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("CD", Pos.CardinalNumber, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("DT", Pos.Determiner, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("EX", Pos.ExistentialParticle, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("FW", Pos.Foreign, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("IN", Pos.Preposition, new Pos[]{Pos.SubordinatingConjunction}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("JJ", LexicalCategory.Adjective, new LexicalCategory[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("JJR", LexicalCategory.Adjective, Pos.ComparativeParticle, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("JJS", LexicalCategory.Adjective, Pos.SuperlativeParticle, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("LS", Pos.ListMarker, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("MD", Pos.ModalVerb, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("NN", Pos.CommonNoun, new Pos[]{Pos.SingularQuantifier}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("NNP", Pos.ProperNoun, new Pos[]{Pos.SingularQuantifier}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("NNPS", Pos.ProperNoun, new Pos[]{Pos.PluralQuantifier}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("NNS", Pos.CommonNoun, new Pos[]{Pos.PluralQuantifier}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("PDT", Pos.Determiner, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("POS", Pos.PossessiveDeterminer, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("PP", Pos.PersonalPronoun, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("PP$", Pos.PossessivePronoun, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("PRP", Pos.PersonalPronoun, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("PRP$", Pos.PossessivePronoun, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("RB", LexicalCategory.Adverb, new LexicalCategory[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("RBR", LexicalCategory.Adverb, Pos.ComparativeParticle, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("RBS", LexicalCategory.Adverb, Pos.SuperlativeParticle, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("RP", Pos.Participle, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("SYM", Pos.Symbol, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("TO", LexicalCategory.Adposition, new LexicalCategory[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("UH", LexicalCategory.Interjection, new LexicalCategory[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("VB", Pos.Infinitive, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("VBD", Pos.PastParticiple, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("VBG", Pos.PresentParticiple, new Pos[]{Pos.Gerund}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("VBN", Pos.PastParticiple, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("VBP", Pos.PresentParticiple, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("VBZ", Pos.PresentParticiple, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("WDT", Pos.WHDeterminer, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("WP", Pos.WHPronoun, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("WP$", Pos.PossessivePronoun, new Pos[]{Pos.WHPronoun}));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("WRB", Pos.WHTypeAdverbs, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("\u00b4\u00b4", Pos.CloseQuote, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("''", Pos.Quote, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag(":", Pos.Colon, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag(",", Pos.Comma, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("$", LexicalCategory.Residual, new LexicalCategory[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("\"", Pos.Quote, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("``", Pos.OpenQuote, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag(".", Pos.Point, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("#", Pos.SecondaryPunctuation, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("{", Pos.OpenCurlyBracket, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("}", Pos.CloseCurlyBracket, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("[", Pos.OpenSquareBracket, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("]", Pos.CloseSquareBracket, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("(", Pos.OpenParenthesis, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag(")", Pos.CloseParenthesis, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("-LRB-", Pos.OpenParenthesis, new Pos[0]));
        ENGLISH_PENN_TREEBANK.addTag((Tag)new PosTag("-RRB-", Pos.CloseParenthesis, new Pos[0]));
    }
}

