/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.logback.ext.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import org.eluder.logback.ext.core.CharacterEncoder;
import org.eluder.logback.ext.core.PayloadConverter;

public abstract class EncodingStringAppender<E extends DeferredProcessingAware, P>
extends UnsynchronizedAppenderBase<E> {
    protected final ReentrantLock lock = new ReentrantLock(true);
    private Charset charset = Charset.forName("UTF-8");
    private boolean binary = false;
    private Encoder<E> encoder;
    private PayloadConverter<P> converter;

    public final void setCharset(Charset charset) {
        if (this.encoder instanceof LayoutWrappingEncoder) {
            ((LayoutWrappingEncoder)this.encoder).setCharset(charset);
        } else if (this.encoder instanceof CharacterEncoder) {
            ((CharacterEncoder)this.encoder).setCharset(charset);
        }
        this.charset = charset;
    }

    public final void setBinary(boolean binary) {
        if (binary) {
            this.addInfo(String.format("Appender '%s' is set to binary mode, events are converted to Base64 strings", this.getName()));
        }
        this.binary = binary;
    }

    public final void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
        this.setContext(this.context);
        this.setCharset(this.charset);
    }

    public final void setLayout(Layout<E> layout) {
        LayoutWrappingEncoder enc = new LayoutWrappingEncoder();
        enc.setLayout(layout);
        this.setEncoder((Encoder<E>)enc);
    }

    public final void setConverter(PayloadConverter<P> converter) {
        this.converter = converter;
    }

    public void setContext(Context context) {
        if (this.encoder != null) {
            this.encoder.setContext(context);
        }
        super.setContext(context);
    }

    protected final Charset getCharset() {
        return this.charset;
    }

    protected final boolean isBinary() {
        return this.binary;
    }

    protected final Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void start() {
        if (this.encoder == null) {
            this.addError(String.format("Encoder not set for appender '%s'", this.getName()));
            return;
        }
        if (this.converter == null) {
            this.addError(String.format("Converter not set for appender '%s'", this.getName()));
            return;
        }
        this.lock.lock();
        try {
            this.encoder.start();
            super.start();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            super.stop();
            if (this.encoder != null) {
                this.encoder.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void append(E event) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.encode(event, stream);
        this.doHandle(event, this.convert(stream.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encode(E event, ByteArrayOutputStream stream) {
        this.lock.lock();
        try {
            this.encoderInit(stream);
            try {
                this.doEncode(event);
            }
            finally {
                this.encoderClose();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void handle(E var1, P var2) throws Exception;

    protected P convert(byte[] payload) {
        return this.converter.convert(payload);
    }

    protected void doHandle(E event, P encoded) {
        try {
            if (encoded != null) {
                this.handle(event, encoded);
            }
        }
        catch (Exception ex) {
            this.started = false;
            this.addError(String.format("Failed to handle logging event for '%s'", this.getName()), ex);
        }
    }

    protected void doEncode(E event) {
        try {
            this.encoder.doEncode(event);
        }
        catch (IOException ex) {
            this.started = false;
            this.addError(String.format("Failed to encode logging event for appender '%s'", this.getName()), ex);
        }
    }

    protected void encoderInit(ByteArrayOutputStream stream) {
        try {
            this.encoder.init((OutputStream)stream);
        }
        catch (IOException ex) {
            this.started = false;
            this.addError(String.format("Failed to initialize encoder for appender '%s'", this.getName()), ex);
        }
    }

    protected void encoderClose() {
        try {
            this.encoder.close();
        }
        catch (Exception ex) {
            this.started = false;
            this.addError(String.format("Failed to close encoder for appender '%s'", this.getName()), ex);
        }
    }
}

