/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.LinkingObjects;
import io.realm.annotations.Required;
import io.realm.processor.ClassMetaData;
import io.realm.processor.QualifiedClassName;
import io.realm.processor.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0016\u0010\u0013\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lio/realm/processor/Backlink;", "", "clazz", "Lio/realm/processor/ClassMetaData;", "backlinkField", "Ljavax/lang/model/element/VariableElement;", "(Lio/realm/processor/ClassMetaData;Ljavax/lang/model/element/VariableElement;)V", "exposeAsRealmResults", "", "getExposeAsRealmResults", "()Z", "sourceClass", "Lio/realm/processor/QualifiedClassName;", "getSourceClass", "()Ljava/lang/String;", "Ljava/lang/String;", "sourceField", "", "getSourceField", "targetClass", "getTargetClass", "targetField", "getTargetField", "targetFieldType", "getTargetFieldType", "equals", "other", "hashCode", "", "toString", "validateBacklinkAsObjectReference", "field", "validateBacklinksAsRealmResults", "validateSource", "validateTarget", "realm-annotations-processor"})
public final class Backlink {
    @NotNull
    private final String targetClass;
    @NotNull
    private final String targetField;
    @Nullable
    private final String sourceClass;
    @Nullable
    private final String sourceField;
    private final boolean exposeAsRealmResults;
    @NotNull
    private final String targetFieldType;
    private final ClassMetaData clazz;
    private final VariableElement backlinkField;

    @NotNull
    public final String getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final String getTargetField() {
        return this.targetField;
    }

    @Nullable
    public final String getSourceClass() {
        return this.sourceClass;
    }

    @Nullable
    public final String getSourceField() {
        return this.sourceField;
    }

    public final boolean getExposeAsRealmResults() {
        return this.exposeAsRealmResults;
    }

    @NotNull
    public final String getTargetFieldType() {
        return this.targetFieldType;
    }

    public final boolean validateSource() {
        if (this.sourceField == null || Intrinsics.areEqual((Object)this.sourceField, (Object)"")) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string = "The @LinkingObjects annotation for the field \"%s.%s\" must have a parameter identifying the link target.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            utils.error(string3);
            return false;
        }
        if (StringsKt.contains$default((CharSequence)this.sourceField, (CharSequence)".", (boolean)false, (int)2, null)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale3 = locale;
            String string = "The parameter to the @LinkingObjects annotation for the field \"%s.%s\" contains a '.'.  The use of '.' to specify fields in referenced classes is not supported.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string4 = String.format(locale3, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
            String string5 = string4;
            utils.error(string5);
            return false;
        }
        if (Utils.INSTANCE.isRealmResults(this.backlinkField)) {
            return this.validateBacklinksAsRealmResults(this.backlinkField);
        }
        return this.validateBacklinkAsObjectReference(this.backlinkField);
    }

    private final boolean validateBacklinkAsObjectReference(VariableElement field) {
        Collection collection;
        if (!this.clazz.getEmbedded() && !Utils.INSTANCE.isRealmResults(this.backlinkField)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string = "The field \"%s.%s\" is a \"%s\". Fields annotated with @LinkingObjects must be RealmResults.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField, this.backlinkField.asType()};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            utils.error(string3);
            return false;
        }
        if (field.getAnnotation(Required.class) != null) {
            collection = this.clazz.getBacklinkFields();
            boolean bl = false;
            if (!collection.isEmpty()) {
                collection = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale3 = locale;
                String string = "@Required cannot be used on @LinkingObjects field if multiple @LinkingParents are defined: \"%s.%s\".";
                Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
                Utils utils = Utils.INSTANCE;
                boolean bl2 = false;
                String string4 = String.format(locale3, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
                String string5 = string4;
                utils.error(string5);
                return false;
            }
        }
        if (!field.getModifiers().contains((Object)Modifier.FINAL)) {
            collection = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale4 = locale;
            String string = "The @LinkingObjects field \"%s.%s\" must be final.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string6 = String.format(locale4, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            String string7 = string6;
            utils.error(string7);
            return false;
        }
        return true;
    }

    private final boolean validateBacklinksAsRealmResults(VariableElement field) {
        if (field.getAnnotation(Required.class) != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string = "The @LinkingObjects field \"%s.%s\" cannot be @Required.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            utils.error(string3);
            return false;
        }
        if (this.sourceClass == null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale3 = locale;
            String string = "\"The field \"%s.%s\", annotated with @LinkingObjects, must specify a generic type.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string4 = String.format(locale3, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
            String string5 = string4;
            utils.error(string5);
            return false;
        }
        if (!this.backlinkField.getModifiers().contains((Object)Modifier.FINAL)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale4 = locale;
            String string = "A @LinkingObjects field \"%s.%s\" must be final.";
            Object[] objectArray = new Object[]{QualifiedClassName.box-impl(this.targetClass), this.targetField};
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string6 = String.format(locale4, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            String string7 = string6;
            utils.error(string7);
            return false;
        }
        return true;
    }

    public final boolean validateTarget(@NotNull ClassMetaData clazz) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        VariableElement field = clazz.getDeclaredField(this.sourceField);
        if (field == null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string = "Field \"%s\", the target of the @LinkedObjects annotation on field \"%s.%s\", does not exist in class \"%s\".";
            Object[] objectArray = new Object[4];
            objectArray[0] = this.sourceField;
            objectArray[1] = QualifiedClassName.box-impl(this.targetClass);
            objectArray[2] = this.targetField;
            String string2 = this.sourceClass;
            objectArray[3] = string2 != null ? QualifiedClassName.box-impl(string2) : null;
            Object[] objectArray2 = objectArray;
            Utils utils = Utils.INSTANCE;
            boolean bl = false;
            String string3 = String.format(locale2, string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            String string4 = string3;
            utils.error(string4);
            return false;
        }
        String fieldType = QualifiedClassName.constructor-impl(((Object)field.asType()).toString());
        if (!QualifiedClassName.equals-impl0(this.targetClass, fieldType)) {
            String string = Utils.INSTANCE.getRealmListType(field);
            if (!(string == null ? false : QualifiedClassName.equals-impl0(this.targetClass, string))) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale3 = locale;
                String string5 = "Field \"%s.%s\", the target of the @LinkedObjects annotation on field \"%s.%s\", has type \"%s\" instead of \"%3$s\".";
                Object[] objectArray = new Object[5];
                String string6 = this.sourceClass;
                objectArray[0] = string6 != null ? QualifiedClassName.box-impl(string6) : null;
                objectArray[1] = this.sourceField;
                objectArray[2] = QualifiedClassName.box-impl(this.targetClass);
                objectArray[3] = this.targetField;
                objectArray[4] = QualifiedClassName.box-impl(fieldType);
                Object[] objectArray3 = objectArray;
                Utils utils = Utils.INSTANCE;
                boolean bl = false;
                String string7 = String.format(locale3, string5, Arrays.copyOf(objectArray3, objectArray3.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(locale, format, *args)");
                String string8 = string7;
                utils.error(string8);
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        String string = this.sourceClass;
        return "Backlink{" + (string != null ? QualifiedClassName.box-impl(string) : null) + '.' + this.sourceField + " ==> " + QualifiedClassName.toString-impl(this.targetClass) + '.' + this.targetField + '}';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.realm.processor.Backlink");
        }
        Backlink cfr_ignored_0 = (Backlink)object2;
        if (Intrinsics.areEqual((Object)this.backlinkField, (Object)((Backlink)other).backlinkField) ^ true) {
            return false;
        }
        if (QualifiedClassName.equals-impl0(this.targetClass, ((Backlink)other).targetClass) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.targetField, (Object)((Backlink)other).targetField) ^ true) {
            return false;
        }
        String string = this.sourceClass;
        String string2 = ((Backlink)other).sourceClass;
        boolean bl = string == null ? string2 != null : (string2 == null ? true : QualifiedClassName.equals-impl0(string, string2) ^ true);
        if (bl) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.sourceField, (Object)((Backlink)other).sourceField) ^ true);
    }

    public int hashCode() {
        int result = this.backlinkField.hashCode();
        result = 31 * result + QualifiedClassName.hashCode-impl(this.targetClass);
        result = 31 * result + this.targetField.hashCode();
        String string = this.sourceClass;
        result = 31 * result + (string != null ? QualifiedClassName.hashCode-impl(string) : 0);
        String string2 = this.sourceField;
        int n = 31 * result;
        boolean bl = false;
        String string3 = string2;
        int n2 = string3 != null ? string3.hashCode() : 0;
        result = n + n2;
        return result;
    }

    public Backlink(@NotNull ClassMetaData clazz, @NotNull VariableElement backlinkField) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)backlinkField, (String)"backlinkField");
        this.clazz = clazz;
        this.backlinkField = backlinkField;
        this.targetClass = this.clazz.getQualifiedClassName();
        this.targetField = this.backlinkField.getSimpleName().toString();
        this.sourceClass = Utils.INSTANCE.isRealmResults(this.backlinkField) ? Utils.INSTANCE.getRealmResultsType(this.backlinkField) : Utils.INSTANCE.getModelClassQualifiedName(this.backlinkField);
        LinkingObjects linkingObjects = this.backlinkField.getAnnotation(LinkingObjects.class);
        this.sourceField = linkingObjects != null ? linkingObjects.value() : null;
        this.exposeAsRealmResults = Utils.INSTANCE.isRealmResults(this.backlinkField);
        this.targetFieldType = ((Object)this.backlinkField.asType()).toString();
    }
}

