/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.compiler;

import io.realm.kotlin.compiler.AccessorModifierIrGeneration;
import io.realm.kotlin.compiler.ClassIds;
import io.realm.kotlin.compiler.IrUtilsKt;
import io.realm.kotlin.compiler.RealmModelDefaultMethodGeneration;
import io.realm.kotlin.compiler.RealmModelSyntheticPropertiesGeneration;
import io.realm.kotlin.compiler.SchemaCollector;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationException;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImplKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/realm/kotlin/compiler/RealmModelLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "modelObjectAnnotationClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getModelObjectAnnotationClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "modelObjectAnnotationClass$delegate", "Lkotlin/Lazy;", "lowerFromModuleFragment", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irClass", "plugin-compiler"})
@SourceDebugExtension(value={"SMAP\nRealmModelLoweringExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmModelLoweringExtension.kt\nio/realm/kotlin/compiler/RealmModelLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1863#2,2:158\n*S KotlinDebug\n*F\n+ 1 RealmModelLoweringExtension.kt\nio/realm/kotlin/compiler/RealmModelLowering\n*L\n69#1:158,2\n*E\n"})
final class RealmModelLowering
implements ClassLoweringPass {
    @NotNull
    private final IrPluginContext pluginContext;
    @NotNull
    private final Lazy modelObjectAnnotationClass$delegate;

    public RealmModelLowering(@NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        this.pluginContext = pluginContext;
        this.modelObjectAnnotationClass$delegate = LazyKt.lazy(() -> RealmModelLowering.modelObjectAnnotationClass_delegate$lambda$0(this));
    }

    @NotNull
    public final IrClass getModelObjectAnnotationClass() {
        Lazy lazy = this.modelObjectAnnotationClass$delegate;
        return (IrClass)lazy.getValue();
    }

    public final void lowerFromModuleFragment(@NotNull IrModuleFragment moduleFragment) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Iterable $this$forEach$iv = moduleFragment.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile it = (IrFile)element$iv;
            boolean bl = false;
            try {
                this.lower(it);
            }
            catch (CompilationException e) {
                throw CompilationExceptionKt.wrapWithCompilationException((Throwable)e, (String)"Internal error in realm lowering", (IrFile)it, null);
            }
            catch (KotlinExceptionWithAttachments e) {
                throw e;
            }
            catch (Throwable e) {
                throw CompilationExceptionKt.wrapWithCompilationException((Throwable)e, (String)"Internal error in file lowering", (IrFile)it, null);
            }
        }
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix((ClassLoweringPass)this, (IrFile)irFile);
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (IrUtilsKt.isBaseRealmObject(irClass)) {
            if (irClass.isData()) {
                throw new IllegalStateException(("Data class '" + AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)irClass)) + "' is not currently supported. Only normal classes can inherit from 'RealmObject' or 'EmbeddedRealmObject'.").toString());
            }
            if (org.jetbrains.kotlin.ir.util.IrUtilsKt.isEnumClass((IrClass)irClass)) {
                throw new IllegalStateException(("Enum class '" + AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)irClass)) + "' is not supported. Only normal classes can inherit from 'RealmObject' or 'EmbeddedRealmObject'.").toString());
            }
            if (org.jetbrains.kotlin.ir.util.IrUtilsKt.isObject((IrClass)irClass)) {
                throw new IllegalStateException("Object declarations are not supported. Only normal classes can inherit from 'RealmObject' or 'EmbeddedRealmObject'.".toString());
            }
            if (org.jetbrains.kotlin.ir.util.IrUtilsKt.isAnonymousObject((IrClass)irClass)) {
                throw new IllegalStateException("Anonymous objects are not supported. Only normal classes can inherit from 'RealmObject' or 'EmbeddedRealmObject'.".toString());
            }
            if (NativePlatformKt.isNative((TargetPlatform)this.pluginContext.getPlatform())) {
                IrConstructorCallImpl irConstructorCallImpl;
                IrType irType = (IrType)org.jetbrains.kotlin.ir.util.IrUtilsKt.getDefaultType((IrClass)this.getModelObjectAnnotationClass());
                IrConstructor irConstructor = org.jetbrains.kotlin.ir.util.IrUtilsKt.getPrimaryConstructor((IrClass)this.getModelObjectAnnotationClass());
                Intrinsics.checkNotNull((Object)irConstructor);
                IrConstructorCallImpl $this$lower_u24lambda_u242 = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)irType, (IrConstructorSymbol)irConstructor.getSymbol(), null, (int)16, null);
                boolean bl = false;
                int n = $this$lower_u24lambda_u242.getStartOffset();
                int n2 = $this$lower_u24lambda_u242.getEndOffset();
                IrType irType2 = (IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)this.pluginContext.getIrBuiltIns().getKClassClass());
                IrClass irClass2 = AdditionalIrUtilsKt.companionObject((IrClass)irClass);
                Intrinsics.checkNotNull((Object)irClass2);
                $this$lower_u24lambda_u242.putValueArgument(0, (IrExpression)IrClassReferenceImplKt.IrClassReferenceImpl((int)n, (int)n2, (IrType)irType2, (IrClassifierSymbol)((IrClassifierSymbol)irClass2.getSymbol()), (IrType)$this$lower_u24lambda_u242.getType()));
                IrConstructorCallImpl modelObjectAnnotation = irConstructorCallImpl;
                irClass.setAnnotations(CollectionsKt.plus((Collection)irClass.getAnnotations(), (Object)modelObjectAnnotation));
            }
            IrClassSymbol realmObjectInternalInterface = IrUtilsKt.lookupClassOrThrow(this.pluginContext, ClassIds.INSTANCE.getREALM_OBJECT_INTERNAL_INTERFACE()).getSymbol();
            irClass.setSuperTypes(CollectionsKt.plus((Collection)irClass.getSuperTypes(), (Object)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)realmObjectInternalInterface))));
            RealmModelSyntheticPropertiesGeneration generator = new RealmModelSyntheticPropertiesGeneration(this.pluginContext);
            generator.addRealmObjectInternalProperties(irClass);
            new AccessorModifierIrGeneration(this.pluginContext).modifyPropertiesAndCollectSchema(irClass);
            RealmModelDefaultMethodGeneration methodGenerator = new RealmModelDefaultMethodGeneration(this.pluginContext);
            methodGenerator.addDefaultMethods(irClass);
            IrClass irClass3 = AdditionalIrUtilsKt.companionObject((IrClass)irClass);
            if (irClass3 == null) {
                IrUtilsKt.fatalError("RealmObject without companion: " + AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)irClass)));
                throw new KotlinNothingValueException();
            }
            IrClass companion = irClass3;
            generator.addCompanionFields(irClass, companion, SchemaCollector.INSTANCE.getProperties().get(irClass));
            generator.addSchemaMethodBody(irClass);
            generator.addNewInstanceMethodBody(irClass);
        } else if (irClass.isCompanion() && IrUtilsKt.isBaseRealmObject(org.jetbrains.kotlin.ir.util.IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irClass)))) {
            IrClassSymbol realmModelCompanion = IrUtilsKt.lookupClassOrThrow(this.pluginContext, ClassIds.INSTANCE.getREALM_MODEL_COMPANION()).getSymbol();
            irClass.setSuperTypes(CollectionsKt.plus((Collection)irClass.getSuperTypes(), (Object)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)realmModelCompanion))));
        }
    }

    private static final IrClass modelObjectAnnotationClass_delegate$lambda$0(RealmModelLowering this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return IrUtilsKt.lookupClassOrThrow(this$0.pluginContext, ClassIds.INSTANCE.getMODEL_OBJECT_ANNOTATION());
    }
}

