/*
 * Decompiled with CFR 0.152.
 */
package io.realm.compiler;

import io.realm.compiler.AccessorModifierIrGeneration;
import io.realm.compiler.FqNames;
import io.realm.compiler.IrUtilsKt;
import io.realm.compiler.RealmModelLoweringExtensionKt;
import io.realm.compiler.RealmModelSyntheticPropertiesGeneration;
import io.realm.compiler.SchemaCollector;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/realm/compiler/RealmModelLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "plugin-compiler"})
final class RealmModelLowering
implements ClassLoweringPass {
    @NotNull
    private final IrPluginContext pluginContext;

    public RealmModelLowering(@NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        this.pluginContext = pluginContext;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (IrUtilsKt.getHasRealmModelInterface(irClass)) {
            IrClassSymbol realmObjectInternalInterface = IrUtilsKt.lookupClassOrThrow(this.pluginContext, FqNames.INSTANCE.getREALM_OBJECT_INTERNAL_INTERFACE()).getSymbol();
            IrClass irClass2 = irClass;
            irClass2.setSuperTypes(CollectionsKt.plus((Collection)irClass2.getSuperTypes(), (Object)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)realmObjectInternalInterface))));
            RealmModelSyntheticPropertiesGeneration generator = new RealmModelSyntheticPropertiesGeneration(this.pluginContext);
            generator.addProperties(irClass);
            new AccessorModifierIrGeneration(this.pluginContext).modifyPropertiesAndCollectSchema(irClass);
            IrUtilsKt.addFakeOverrides(irClass, realmObjectInternalInterface, RealmModelLoweringExtensionKt.access$getRealmObjectInternalOverrides$p());
            IrClass irClass3 = AdditionalIrUtilsKt.companionObject((IrClass)irClass);
            if (irClass3 == null) {
                String string = "RealmObject without companion";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            IrClass companion = irClass3;
            generator.addCompanionFields(companion, SchemaCollector.INSTANCE.getProperties().get(irClass));
            generator.addSchemaMethodBody(irClass);
            generator.addNewInstanceMethodBody(irClass);
        } else if (irClass.isCompanion() && IrUtilsKt.getHasRealmModelInterface(org.jetbrains.kotlin.ir.util.IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irClass)))) {
            IrClassSymbol realmModelCompanion = IrUtilsKt.lookupClassOrThrow(this.pluginContext, FqNames.INSTANCE.getREALM_MODEL_COMPANION()).getSymbol();
            IrClass irClass4 = irClass;
            irClass4.setSuperTypes(CollectionsKt.plus((Collection)irClass4.getSuperTypes(), (Object)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)realmModelCompanion))));
        }
    }

    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower((ClassLoweringPass)this, (IrFile)irFile);
    }
}

