/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.sync;

import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.mongodb.sync.SyncTimeoutOptions;
import kotlin.Metadata;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aR&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncTimeoutOptionsBuilder;", "", "<init>", "()V", "value", "Lkotlin/time/Duration;", "connectTimeout", "getConnectTimeout-UwyO8pc", "()J", "setConnectTimeout-LRDsOJo", "(J)V", "J", "connectionLingerTime", "getConnectionLingerTime-UwyO8pc", "setConnectionLingerTime-LRDsOJo", "pingKeepAlivePeriod", "getPingKeepAlivePeriod-UwyO8pc", "setPingKeepAlivePeriod-LRDsOJo", "pongKeepAlivePeriod", "getPongKeepAlivePeriod-UwyO8pc", "setPongKeepAlivePeriod-LRDsOJo", "fastReconnectLimit", "getFastReconnectLimit-UwyO8pc", "setFastReconnectLimit-LRDsOJo", "build", "Lio/realm/kotlin/mongodb/sync/SyncTimeoutOptions;", "build$io_realm_kotlin_library", "io.realm.kotlin.library"})
public final class SyncTimeoutOptionsBuilder {
    private long connectTimeout = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES);
    private long connectionLingerTime = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    private long pingKeepAlivePeriod = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
    private long pongKeepAlivePeriod = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES);
    private long fastReconnectLimit = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);

    public final long getConnectTimeout-UwyO8pc() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout-LRDsOJo(long value) {
        Validation.INSTANCE.require(Duration.compareTo-LRDsOJo((long)value, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)) >= 0, () -> SyncTimeoutOptionsBuilder.setConnectTimeout_LRDsOJo$lambda$0(value));
        this.connectTimeout = value;
    }

    public final long getConnectionLingerTime-UwyO8pc() {
        return this.connectionLingerTime;
    }

    public final void setConnectionLingerTime-LRDsOJo(long value) {
        Validation.INSTANCE.require(Duration.compareTo-LRDsOJo((long)value, (long)DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.MILLISECONDS)) > 0, () -> SyncTimeoutOptionsBuilder.setConnectionLingerTime_LRDsOJo$lambda$1(value));
        this.connectionLingerTime = value;
    }

    public final long getPingKeepAlivePeriod-UwyO8pc() {
        return this.pingKeepAlivePeriod;
    }

    public final void setPingKeepAlivePeriod-LRDsOJo(long value) {
        Validation.INSTANCE.require(Duration.compareTo-LRDsOJo((long)value, (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) > 0, () -> SyncTimeoutOptionsBuilder.setPingKeepAlivePeriod_LRDsOJo$lambda$2(value));
        this.pingKeepAlivePeriod = value;
    }

    public final long getPongKeepAlivePeriod-UwyO8pc() {
        return this.pongKeepAlivePeriod;
    }

    public final void setPongKeepAlivePeriod-LRDsOJo(long value) {
        Validation.INSTANCE.require(Duration.compareTo-LRDsOJo((long)value, (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) > 0, () -> SyncTimeoutOptionsBuilder.setPongKeepAlivePeriod_LRDsOJo$lambda$3(value));
        this.pongKeepAlivePeriod = value;
    }

    public final long getFastReconnectLimit-UwyO8pc() {
        return this.fastReconnectLimit;
    }

    public final void setFastReconnectLimit-LRDsOJo(long value) {
        Validation.INSTANCE.require(Duration.compareTo-LRDsOJo((long)value, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)) > 0, () -> SyncTimeoutOptionsBuilder.setFastReconnectLimit_LRDsOJo$lambda$4(value));
        this.fastReconnectLimit = value;
    }

    @NotNull
    public final SyncTimeoutOptions build$io_realm_kotlin_library() {
        return new SyncTimeoutOptions(this.connectTimeout, this.connectionLingerTime, this.pingKeepAlivePeriod, this.pongKeepAlivePeriod, this.fastReconnectLimit, null);
    }

    private static final String setConnectTimeout_LRDsOJo$lambda$0(long $value) {
        return "connectTimeout only support durations >= 1 second. This was: " + Duration.toString-impl((long)$value);
    }

    private static final String setConnectionLingerTime_LRDsOJo$lambda$1(long $value) {
        return "connectionLingerTime must be a positive duration > 0. This was: " + Duration.toString-impl((long)$value);
    }

    private static final String setPingKeepAlivePeriod_LRDsOJo$lambda$2(long $value) {
        return "pingKeepAlivePeriod must be a positive duration > 5 seconds. This was: " + Duration.toString-impl((long)$value);
    }

    private static final String setPongKeepAlivePeriod_LRDsOJo$lambda$3(long $value) {
        return "pongKeepAlivePeriod must be a positive duration > 5 seconds. This was: " + Duration.toString-impl((long)$value);
    }

    private static final String setFastReconnectLimit_LRDsOJo$lambda$4(long $value) {
        return "fastReconnectLimit must be a positive duration > 1 second. This was: " + Duration.toString-impl((long)$value);
    }
}

