/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.sync;

import io.realm.kotlin.Configuration;
import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.internal.ConfigurationImpl;
import io.realm.kotlin.internal.ContextLogger;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmUserT;
import io.realm.kotlin.internal.interop.SchemaMode;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.internal.util.CoroutineDispatcherFactory;
import io.realm.kotlin.mongodb.User;
import io.realm.kotlin.mongodb.exceptions.ClientResetRequiredException;
import io.realm.kotlin.mongodb.exceptions.SyncException;
import io.realm.kotlin.mongodb.internal.SyncConfigurationImpl;
import io.realm.kotlin.mongodb.internal.UserImpl;
import io.realm.kotlin.mongodb.sync.InitialRemoteDataConfiguration;
import io.realm.kotlin.mongodb.sync.InitialSubscriptionsCallback;
import io.realm.kotlin.mongodb.sync.InitialSubscriptionsConfiguration;
import io.realm.kotlin.mongodb.sync.RecoverOrDiscardUnsyncedChangesStrategy;
import io.realm.kotlin.mongodb.sync.SyncClientResetStrategy;
import io.realm.kotlin.mongodb.sync.SyncMode;
import io.realm.kotlin.mongodb.sync.SyncSession;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.RealmUUID;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBinarySubType;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "Lio/realm/kotlin/Configuration;", "user", "Lio/realm/kotlin/mongodb/User;", "getUser", "()Lio/realm/kotlin/mongodb/User;", "errorHandler", "Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "getErrorHandler", "()Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "syncClientResetStrategy", "Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "getSyncClientResetStrategy", "()Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "syncMode", "Lio/realm/kotlin/mongodb/sync/SyncMode;", "getSyncMode", "()Lio/realm/kotlin/mongodb/sync/SyncMode;", "initialSubscriptions", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "getInitialSubscriptions", "()Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "initialRemoteData", "Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "getInitialRemoteData", "()Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "Builder", "Companion", "io.realm.kotlin.library"})
public interface SyncConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.sync.SyncConfiguration$Companion.$$INSTANCE;

    @NotNull
    public User getUser();

    @NotNull
    public SyncSession.ErrorHandler getErrorHandler();

    @NotNull
    public SyncClientResetStrategy getSyncClientResetStrategy();

    @NotNull
    public SyncMode getSyncMode();

    @Nullable
    public InitialSubscriptionsConfiguration getInitialSubscriptions();

    @Nullable
    public InitialRemoteDataConfiguration getInitialRemoteData();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\rB1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u000e\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\u000fB1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0010\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\u0011B1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0012\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\u0013B1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0014\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\u0015B1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0016\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\u0017J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010%\u001a\u00020 J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0017\u0010&\u001a\u00020\u00002\b\b\u0002\u0010'\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\u0018\u0010!\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020\u0002H\u0016J\u0012\u00100\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0016X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder;", "Lio/realm/kotlin/Configuration$SharedBuilder;", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "user", "Lio/realm/kotlin/mongodb/User;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "partitionValue", "Lorg/mongodb/kbson/BsonValue;", "<init>", "(Lio/realm/kotlin/mongodb/User;Ljava/util/Set;Lorg/mongodb/kbson/BsonValue;)V", "(Lio/realm/kotlin/mongodb/User;Ljava/util/Set;)V", "Lorg/mongodb/kbson/BsonObjectId;", "(Lio/realm/kotlin/mongodb/User;Lorg/mongodb/kbson/BsonObjectId;Ljava/util/Set;)V", "Lio/realm/kotlin/types/RealmUUID;", "(Lio/realm/kotlin/mongodb/User;Lio/realm/kotlin/types/RealmUUID;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Integer;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Long;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/String;Ljava/util/Set;)V", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "errorHandler", "Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "syncClientResetStrategy", "Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "initialSubscriptions", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "waitForServerChanges", "Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "resetStrategy", "waitForInitialRemoteData", "timeout", "Lkotlin/time/Duration;", "waitForInitialRemoteData-LRDsOJo", "(J)Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder;", "rerunOnOpen", "", "initialSubscriptionBlock", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsCallback;", "build", "getAbsolutePath", "io.realm.kotlin.library"})
    @SourceDebugExtension(value={"SMAP\nSyncConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncConfiguration.kt\nio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,668:1\n1#2:669\n*E\n"})
    public static final class Builder
    extends Configuration.SharedBuilder<SyncConfiguration, Builder> {
        @NotNull
        private User user;
        @Nullable
        private BsonValue partitionValue;
        @Nullable
        private String name;
        @Nullable
        private SyncSession.ErrorHandler errorHandler;
        @Nullable
        private SyncClientResetStrategy syncClientResetStrategy;
        @Nullable
        private InitialSubscriptionsConfiguration initialSubscriptions;
        @Nullable
        private InitialRemoteDataConfiguration waitForServerChanges;

        private Builder(User user, Set<? extends KClass<? extends BaseRealmObject>> schema, BsonValue partitionValue) {
            super(schema);
            this.user = user;
            this.partitionValue = partitionValue;
            if (!this.user.getLoggedIn()) {
                throw new IllegalArgumentException("A valid, logged in user is required.");
            }
        }

        @Nullable
        protected String getName() {
            return this.name;
        }

        protected void setName(@Nullable String string) {
            this.name = string;
        }

        public Builder(@NotNull User user, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, schema, null);
        }

        public Builder(@NotNull User user, @Nullable BsonObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            BsonObjectId bsonObjectId = partitionValue;
            this(user, schema, bsonObjectId != null ? (BsonValue)bsonObjectId : (BsonValue)BsonNull.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable RealmUUID partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            RealmUUID realmUUID = partitionValue;
            if (realmUUID != null) {
                void it;
                RealmUUID realmUUID2 = realmUUID;
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonBinary bsonBinary = new BsonBinary(BsonBinarySubType.UUID_STANDARD, it.getBytes());
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonBinary;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable Integer partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            Integer n = partitionValue;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonInt32 bsonInt32 = new BsonInt32((int)it);
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonInt32;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable Long partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            Long l = partitionValue;
            if (l != null) {
                void it;
                long l2 = ((Number)l).longValue();
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonInt64 bsonInt64 = new BsonInt64((long)it);
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonInt64;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable String partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            String string = partitionValue;
            if (string != null) {
                void it;
                String string2 = string;
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonString bsonString = new BsonString((String)it);
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonString;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        @NotNull
        public final Builder errorHandler(@NotNull SyncSession.ErrorHandler errorHandler) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
            Builder $this$errorHandler_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$errorHandler_u24lambda_u244.errorHandler = errorHandler;
            return builder;
        }

        @NotNull
        public final Builder syncClientResetStrategy(@NotNull SyncClientResetStrategy resetStrategy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resetStrategy, (String)"resetStrategy");
            Builder $this$syncClientResetStrategy_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$syncClientResetStrategy_u24lambda_u245.syncClientResetStrategy = resetStrategy;
            return builder;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$name_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$name_u24lambda_u246.checkName(name);
            $this$name_u24lambda_u246.setName(name);
            return builder;
        }

        @NotNull
        public final Builder waitForInitialRemoteData-LRDsOJo(long timeout) {
            Builder builder;
            Builder $this$waitForInitialRemoteData_LRDsOJo_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$waitForInitialRemoteData_LRDsOJo_u24lambda_u247.waitForServerChanges = new InitialRemoteDataConfiguration(timeout, null);
            return builder;
        }

        public static /* synthetic */ Builder waitForInitialRemoteData-LRDsOJo$default(Builder builder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = Duration.Companion.getINFINITE-UwyO8pc();
            }
            return builder.waitForInitialRemoteData-LRDsOJo(l);
        }

        @NotNull
        public final Builder initialSubscriptions(boolean rerunOnOpen, @NotNull InitialSubscriptionsCallback initialSubscriptionBlock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)initialSubscriptionBlock, (String)"initialSubscriptionBlock");
            Builder $this$initialSubscriptions_u24lambda_u248 = builder = this;
            boolean bl = false;
            if ($this$initialSubscriptions_u24lambda_u248.partitionValue != null) {
                throw new IllegalStateException("Defining initial subscriptions is only available if the configuration is for Flexible Sync.");
            }
            $this$initialSubscriptions_u24lambda_u248.initialSubscriptions = new InitialSubscriptionsConfiguration(initialSubscriptionBlock, rerunOnOpen);
            return builder;
        }

        public static /* synthetic */ Builder initialSubscriptions$default(Builder builder, boolean bl, InitialSubscriptionsCallback initialSubscriptionsCallback, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return builder.initialSubscriptions(bl, initialSubscriptionsCallback);
        }

        @NotNull
        public SyncConfiguration build() {
            CoroutineDispatcherFactory coroutineDispatcherFactory;
            CoroutineDispatcherFactory coroutineDispatcherFactory2;
            ContextLogger realmLogger = new ContextLogger(null, 1, null);
            if (this.errorHandler == null) {
                this.errorHandler = new SyncSession.ErrorHandler(realmLogger){
                    final /* synthetic */ ContextLogger $realmLogger;
                    {
                        this.$realmLogger = $realmLogger;
                    }

                    public void onError(SyncSession session, SyncException error) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                            String string = error.getMessage();
                            if (string == null) break block0;
                            String string2 = string;
                            ContextLogger contextLogger = this.$realmLogger;
                            String it = string2;
                            boolean bl = false;
                            contextLogger.warn(it, new Object[0]);
                        }
                    }
                };
            }
            if (this.syncClientResetStrategy == null) {
                this.syncClientResetStrategy = new RecoverOrDiscardUnsyncedChangesStrategy(realmLogger){
                    final /* synthetic */ ContextLogger $realmLogger;
                    {
                        this.$realmLogger = $realmLogger;
                    }

                    public void onBeforeReset(TypedRealm realm) {
                        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
                        this.$realmLogger.info("Client reset: attempting to automatically recover unsynced changes in Realm: " + realm.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onAfterRecovery(TypedRealm before, MutableRealm after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        this.$realmLogger.info("Client reset: successfully recovered all unsynced changes in Realm: " + after.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onAfterDiscard(TypedRealm before, MutableRealm after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        this.$realmLogger.info("Client reset: couldn't recover successfully, all unsynced changes were discarded in Realm: " + after.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onManualResetFallback(SyncSession session, ClientResetRequiredException exception) {
                        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        this.$realmLogger.error("Client reset: manual reset required for Realm in '" + exception.getOriginalFilePath() + '\'', new Object[0]);
                    }
                };
            }
            if (this.partitionValue == null && this.getName() == null) {
                this.setName("default.realm");
            }
            String fullPathToFile = this.getAbsolutePath(this.getName());
            String fileName = StringsKt.substringAfterLast$default((String)fullPathToFile, (String)SystemUtilsKt.getPATH_SEPARATOR(), null, (int)2, null);
            String directory = StringsKt.removeSuffix((String)fullPathToFile, (CharSequence)(SystemUtilsKt.getPATH_SEPARATOR() + fileName));
            Set set = this.getSchema();
            long l = this.getMaxNumberOfActiveVersions();
            if (this.getNotificationDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getNotificationDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory2 = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory2 = CoroutineDispatcherFactory.Companion.managed$default((CoroutineDispatcherFactory.Companion)CoroutineDispatcherFactory.Companion, (String)("notifier-" + fileName), (int)0, (int)2, null);
            }
            if (this.getWriteDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getWriteDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default((CoroutineDispatcherFactory.Companion)CoroutineDispatcherFactory.Companion, (String)("writer-" + fileName), (int)0, (int)2, null);
            }
            ConfigurationImpl baseConfiguration = new ConfigurationImpl(directory, fileName, set, l, coroutineDispatcherFactory2, coroutineDispatcherFactory, this.getSchemaVersion(), SchemaMode.RLM_SCHEMA_MODE_ADDITIVE_DISCOVERED, this.getEncryptionKey(), this.getCompactOnLaunchCallback(), null, false, this.getInitialDataCallback(), this.partitionValue == null, this.getInMemory(), this.getInitialRealmFileConfiguration(), realmLogger);
            InternalConfiguration internalConfiguration = (InternalConfiguration)baseConfiguration;
            User user = this.user;
            Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
            UserImpl userImpl = (UserImpl)user;
            SyncSession.ErrorHandler errorHandler = this.errorHandler;
            Intrinsics.checkNotNull((Object)errorHandler);
            SyncClientResetStrategy syncClientResetStrategy = this.syncClientResetStrategy;
            Intrinsics.checkNotNull((Object)syncClientResetStrategy);
            return new SyncConfigurationImpl(internalConfiguration, this.partitionValue, userImpl, errorHandler, syncClientResetStrategy, this.initialSubscriptions, this.waitForServerChanges);
        }

        private final String getAbsolutePath(String name) {
            NativePointer nativePointer;
            boolean bl;
            boolean bl2 = bl = this.partitionValue == null;
            if (bl) {
                User user = this.user;
                Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                nativePointer = RealmInterop.INSTANCE.realm_flx_sync_config_new(((UserImpl)user).getNativePointer());
            } else if (!bl) {
                User user = this.user;
                Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                NativePointer<RealmUserT> nativePointer2 = ((UserImpl)user).getNativePointer();
                BsonValue bsonValue = this.partitionValue;
                Intrinsics.checkNotNull((Object)bsonValue);
                nativePointer = RealmInterop.INSTANCE.realm_sync_config_new(nativePointer2, bsonValue.toJson());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            NativePointer auxSyncConfig = nativePointer;
            boolean bl3 = false;
            String absolutePath = RealmInterop.INSTANCE.realm_app_sync_client_get_default_file_path_for_realm(auxSyncConfig, name);
            return absolutePath;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tJ.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tJ3\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00102\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\u0011J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00122\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tJ.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00132\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a8\u0006\u0014"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Companion;", "", "<init>", "()V", "create", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "user", "Lio/realm/kotlin/mongodb/User;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "partitionValue", "", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Integer;Ljava/util/Set;)Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Long;Ljava/util/Set;)Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "Lorg/mongodb/kbson/BsonObjectId;", "Lio/realm/kotlin/types/RealmUUID;", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable String partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable Integer partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable Long partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable BsonObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable RealmUUID partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

