/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.BaseRealm;
import io.realm.kotlin.Configuration;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.RealmImpl;
import io.realm.kotlin.mongodb.internal.SyncedRealmContext;
import io.realm.kotlin.mongodb.sync.SyncConfiguration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aN\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\b\b\u0001\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u00022'\u0010\u0005\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u0002H\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a%\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\"\b\b\u0000\u0010\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"executeInSyncContext", "T", "R", "Lio/realm/kotlin/BaseRealm;", "realm", "block", "Lkotlin/Function1;", "Lio/realm/kotlin/mongodb/internal/SyncedRealmContext;", "Lkotlin/ParameterName;", "name", "context", "(Lio/realm/kotlin/BaseRealm;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "initSyncContextIfNeeded", "(Lio/realm/kotlin/BaseRealm;)Lio/realm/kotlin/mongodb/internal/SyncedRealmContext;", "io.realm.kotlin.library"})
public final class SyncedRealmContextKt {
    public static final <T, R extends BaseRealm> T executeInSyncContext(@NotNull R realm, @NotNull Function1<? super SyncedRealmContext<R>, ? extends T> block) {
        Intrinsics.checkNotNullParameter(realm, (String)"realm");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (realm.isClosed()) {
            throw new IllegalStateException("This method is not available when the Realm has been closed.");
        }
        Configuration config = realm.getConfiguration();
        if (config instanceof SyncConfiguration) {
            if (realm instanceof BaseRealmImpl) {
                SyncedRealmContext<R> context = SyncedRealmContextKt.initSyncContextIfNeeded(realm);
                return (T)block.invoke(context);
            }
            throw new IllegalStateException("This method is not available on objects of type: " + realm);
        }
        throw new IllegalStateException("This method is only available on synchronized realms.");
    }

    private static final <T extends BaseRealm> SyncedRealmContext<T> initSyncContextIfNeeded(T realm) {
        SyncedRealmContext syncedRealmContext;
        Intrinsics.checkNotNull(realm, (String)"null cannot be cast to non-null type io.realm.kotlin.internal.RealmImpl");
        AtomicRef syncContext = ((RealmImpl)realm).getSyncContext();
        if (syncContext.getValue() != null) {
            Object object = syncContext.getValue();
            Intrinsics.checkNotNull((Object)object);
            syncedRealmContext = (SyncedRealmContext)object;
        } else {
            syncContext.compareAndSet(null, new SyncedRealmContext<T>(realm));
            Object object = syncContext.getValue();
            Intrinsics.checkNotNull((Object)object);
            syncedRealmContext = (SyncedRealmContext)object;
        }
        return syncedRealmContext;
    }
}

