/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.BaseRealm;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.RealmImpl;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSubscriptionSetT;
import io.realm.kotlin.internal.interop.RealmSyncSessionT;
import io.realm.kotlin.mongodb.internal.SubscriptionSetImpl;
import io.realm.kotlin.mongodb.internal.SyncSessionImpl;
import io.realm.kotlin.mongodb.sync.SubscriptionSet;
import io.realm.kotlin.mongodb.sync.SyncConfiguration;
import io.realm.kotlin.mongodb.sync.SyncSession;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00060\u0004j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016*\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d*\u0004\b\u001b\u0010\u0014\u00a8\u0006 "}, d2={"Lio/realm/kotlin/mongodb/internal/SyncedRealmContext;", "T", "Lio/realm/kotlin/BaseRealm;", "Lkotlin/AutoCloseable;", "Ljava/lang/AutoCloseable;", "realm", "<init>", "(Lio/realm/kotlin/BaseRealm;)V", "baseRealm", "Lio/realm/kotlin/internal/RealmImpl;", "config", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "getConfig$io_realm_kotlin_library", "()Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "sessionDelegate", "Lkotlin/Lazy;", "Lio/realm/kotlin/mongodb/internal/SyncSessionImpl;", "session", "Lio/realm/kotlin/mongodb/sync/SyncSession;", "getSession$io_realm_kotlin_library$delegate", "(Lio/realm/kotlin/mongodb/internal/SyncedRealmContext;)Ljava/lang/Object;", "getSession$io_realm_kotlin_library", "()Lio/realm/kotlin/mongodb/sync/SyncSession;", "subscriptionsDelegate", "Lio/realm/kotlin/mongodb/internal/SubscriptionSetImpl;", "subscriptions", "Lio/realm/kotlin/mongodb/sync/SubscriptionSet;", "getSubscriptions$io_realm_kotlin_library$delegate", "getSubscriptions$io_realm_kotlin_library", "()Lio/realm/kotlin/mongodb/sync/SubscriptionSet;", "close", "", "io.realm.kotlin.library"})
public final class SyncedRealmContext<T extends BaseRealm>
implements AutoCloseable {
    @NotNull
    private final RealmImpl baseRealm;
    @NotNull
    private final SyncConfiguration config;
    @NotNull
    private final Lazy<SyncSessionImpl> sessionDelegate;
    @NotNull
    private final Lazy<SubscriptionSetImpl<T>> subscriptionsDelegate;

    public SyncedRealmContext(@NotNull T realm) {
        Intrinsics.checkNotNullParameter(realm, (String)"realm");
        this.baseRealm = (RealmImpl)realm;
        InternalConfiguration internalConfiguration = this.baseRealm.getConfiguration();
        Intrinsics.checkNotNull((Object)internalConfiguration, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.sync.SyncConfiguration");
        this.config = (SyncConfiguration)internalConfiguration;
        this.sessionDelegate = LazyKt.lazy(() -> SyncedRealmContext.sessionDelegate$lambda$0(this));
        this.subscriptionsDelegate = LazyKt.lazy(() -> SyncedRealmContext.subscriptionsDelegate$lambda$1(realm, this));
    }

    @NotNull
    public final SyncConfiguration getConfig$io_realm_kotlin_library() {
        return this.config;
    }

    @NotNull
    public final SyncSession getSession$io_realm_kotlin_library() {
        Lazy<SyncSessionImpl> lazy = this.sessionDelegate;
        return (SyncSession)lazy.getValue();
    }

    private static Object getSession$io_realm_kotlin_library$delegate(SyncedRealmContext<BaseRealm> syncedRealmContext) {
        return syncedRealmContext.sessionDelegate;
    }

    @NotNull
    public final SubscriptionSet<T> getSubscriptions$io_realm_kotlin_library() {
        Lazy<SubscriptionSetImpl<T>> lazy = this.subscriptionsDelegate;
        return (SubscriptionSet)lazy.getValue();
    }

    private static Object getSubscriptions$io_realm_kotlin_library$delegate(SyncedRealmContext<BaseRealm> syncedRealmContext) {
        return syncedRealmContext.subscriptionsDelegate;
    }

    @Override
    public void close() {
        if (this.sessionDelegate.isInitialized()) {
            SyncSession syncSession = this.getSession$io_realm_kotlin_library();
            Intrinsics.checkNotNull((Object)syncSession, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.SyncSessionImpl");
            ((SyncSessionImpl)syncSession).close();
        }
    }

    private static final SyncSessionImpl sessionDelegate$lambda$0(SyncedRealmContext this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new SyncSessionImpl(this$0.baseRealm, (NativePointer<RealmSyncSessionT>)RealmInterop.INSTANCE.realm_sync_session_get(this$0.baseRealm.getRealmReference().getDbPointer()));
    }

    private static final SubscriptionSetImpl subscriptionsDelegate$lambda$1(BaseRealm $realm, SyncedRealmContext this$0) {
        Intrinsics.checkNotNullParameter((Object)$realm, (String)"$realm");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new SubscriptionSetImpl<BaseRealm>($realm, (NativePointer<RealmSubscriptionSetT>)RealmInterop.INSTANCE.realm_sync_get_latest_subscriptionset(this$0.baseRealm.getRealmReference().getDbPointer()));
    }
}

