/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.MutableLiveRealmImpl;
import io.realm.kotlin.internal.TypedFrozenRealmImpl;
import io.realm.kotlin.internal.interop.FrozenRealmT;
import io.realm.kotlin.internal.interop.LiveRealmT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmAppT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.SyncAfterClientResetHandler;
import io.realm.kotlin.internal.interop.SyncBeforeClientResetHandler;
import io.realm.kotlin.internal.interop.sync.SyncError;
import io.realm.kotlin.internal.interop.sync.SyncSessionResyncMode;
import io.realm.kotlin.mongodb.exceptions.ClientResetRequiredException;
import io.realm.kotlin.mongodb.internal.OnBeforeOnAfterHelper;
import io.realm.kotlin.mongodb.sync.RecoverUnsyncedChangesStrategy;
import io.realm.kotlin.mongodb.sync.SyncClientResetStrategy;
import io.realm.kotlin.mongodb.sync.SyncSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J/\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/realm/kotlin/mongodb/internal/RecoverUnsyncedChangesHelper;", "Lio/realm/kotlin/mongodb/internal/OnBeforeOnAfterHelper;", "Lio/realm/kotlin/mongodb/sync/RecoverUnsyncedChangesStrategy;", "strategy", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "<init>", "(Lio/realm/kotlin/mongodb/sync/RecoverUnsyncedChangesStrategy;Lio/realm/kotlin/internal/InternalConfiguration;)V", "getResyncMode", "Lio/realm/kotlin/internal/interop/sync/SyncSessionResyncMode;", "getBefore", "Lio/realm/kotlin/internal/interop/SyncBeforeClientResetHandler;", "getAfter", "Lio/realm/kotlin/internal/interop/SyncAfterClientResetHandler;", "onSyncError", "", "session", "Lio/realm/kotlin/mongodb/sync/SyncSession;", "appPointer", "Lio/realm/kotlin/internal/interop/RealmAppPointer;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmAppT;", "error", "Lio/realm/kotlin/internal/interop/sync/SyncError;", "(Lio/realm/kotlin/mongodb/sync/SyncSession;Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/interop/sync/SyncError;)V", "io.realm.kotlin.library"})
final class RecoverUnsyncedChangesHelper
extends OnBeforeOnAfterHelper<RecoverUnsyncedChangesStrategy> {
    public RecoverUnsyncedChangesHelper(@NotNull RecoverUnsyncedChangesStrategy strategy, @NotNull InternalConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super((SyncClientResetStrategy)strategy, configuration);
    }

    @Override
    @NotNull
    public SyncSessionResyncMode getResyncMode() {
        return SyncSessionResyncMode.RLM_SYNC_SESSION_RESYNC_MODE_RECOVER;
    }

    @Override
    @NotNull
    public SyncBeforeClientResetHandler getBefore() {
        return new SyncBeforeClientResetHandler(this){
            final /* synthetic */ RecoverUnsyncedChangesHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBeforeReset(NativePointer<FrozenRealmT> realmBefore) {
                Intrinsics.checkNotNullParameter(realmBefore, (String)"realmBefore");
                ((RecoverUnsyncedChangesStrategy)this.this$0.getStrategy()).onBeforeReset((TypedRealm)new TypedFrozenRealmImpl(realmBefore, this.this$0.getConfiguration()));
            }
        };
    }

    @Override
    @NotNull
    public SyncAfterClientResetHandler getAfter() {
        return new SyncAfterClientResetHandler(this){
            final /* synthetic */ RecoverUnsyncedChangesHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAfterReset(NativePointer<FrozenRealmT> realmBefore, NativePointer<LiveRealmT> realmAfter, boolean didRecover) {
                Intrinsics.checkNotNullParameter(realmBefore, (String)"realmBefore");
                Intrinsics.checkNotNullParameter(realmAfter, (String)"realmAfter");
                RealmInterop.INSTANCE.realm_begin_write(realmAfter);
                try {
                    ((RecoverUnsyncedChangesStrategy)this.this$0.getStrategy()).onAfterReset((TypedRealm)new TypedFrozenRealmImpl(realmBefore, this.this$0.getConfiguration()), (MutableRealm)new MutableLiveRealmImpl(realmAfter, this.this$0.getConfiguration()));
                    if (RealmInterop.INSTANCE.realm_is_in_transaction(realmAfter)) {
                        RealmInterop.INSTANCE.realm_commit(realmAfter);
                    }
                }
                catch (Throwable exception) {
                    if (RealmInterop.INSTANCE.realm_is_in_transaction(realmAfter)) {
                        RealmInterop.INSTANCE.realm_rollback(realmAfter);
                    }
                    throw exception;
                }
            }
        };
    }

    @Override
    public void onSyncError(@NotNull SyncSession session, @NotNull NativePointer<RealmAppT> appPointer, @NotNull SyncError error) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(appPointer, (String)"appPointer");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        ((RecoverUnsyncedChangesStrategy)this.getStrategy()).onManualResetFallback(session, new ClientResetRequiredException(appPointer, error));
    }
}

