/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.interop.AppCallback;
import io.realm.kotlin.internal.interop.CoreError;
import io.realm.kotlin.internal.interop.ErrorCategory;
import io.realm.kotlin.internal.interop.ErrorCode;
import io.realm.kotlin.internal.interop.sync.AppError;
import io.realm.kotlin.internal.interop.sync.SyncError;
import io.realm.kotlin.mongodb.exceptions.AppException;
import io.realm.kotlin.mongodb.exceptions.AuthException;
import io.realm.kotlin.mongodb.exceptions.BadFlexibleSyncQueryException;
import io.realm.kotlin.mongodb.exceptions.BadRequestException;
import io.realm.kotlin.mongodb.exceptions.CompensatingWriteException;
import io.realm.kotlin.mongodb.exceptions.ConnectionException;
import io.realm.kotlin.mongodb.exceptions.CredentialsCannotBeLinkedException;
import io.realm.kotlin.mongodb.exceptions.FunctionExecutionException;
import io.realm.kotlin.mongodb.exceptions.InvalidCredentialsException;
import io.realm.kotlin.mongodb.exceptions.ServiceException;
import io.realm.kotlin.mongodb.exceptions.SyncException;
import io.realm.kotlin.mongodb.exceptions.UnrecoverableSyncException;
import io.realm.kotlin.mongodb.exceptions.UserAlreadyConfirmedException;
import io.realm.kotlin.mongodb.exceptions.UserAlreadyExistsException;
import io.realm.kotlin.mongodb.exceptions.UserNotFoundException;
import io.realm.kotlin.mongodb.exceptions.WrongSyncTypeException;
import io.realm.kotlin.serializers.MutableRealmIntKSerializer;
import io.realm.kotlin.serializers.RealmAnyKSerializer;
import io.realm.kotlin.serializers.RealmInstantKSerializer;
import io.realm.kotlin.serializers.RealmUUIDKSerializer;
import io.realm.kotlin.types.MutableRealmInt;
import io.realm.kotlin.types.RealmAny;
import io.realm.kotlin.types.RealmInstant;
import io.realm.kotlin.types.RealmUUID;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\bH\u0001\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u001a\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0017\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0018H\u0081\b\u00a8\u0006\u0019"}, d2={"channelResultCallback", "Lio/realm/kotlin/internal/interop/AppCallback;", "T", "R", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lkotlin/Result;", "success", "Lkotlin/Function1;", "convertSyncError", "Lio/realm/kotlin/mongodb/exceptions/SyncException;", "syncError", "Lio/realm/kotlin/internal/interop/sync/SyncError;", "convertAppError", "", "appError", "Lio/realm/kotlin/internal/interop/sync/AppError;", "createMessageFromSyncError", "", "error", "Lio/realm/kotlin/internal/interop/CoreError;", "createMessageFromAppError", "serializerOrRealmBuiltInSerializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/modules/SerializersModule;", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmSyncUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmSyncUtils.kt\nio/realm/kotlin/mongodb/internal/RealmSyncUtilsKt\n+ 2 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 3 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,353:1\n54#2:354\n79#3:355\n*S KotlinDebug\n*F\n+ 1 RealmSyncUtils.kt\nio/realm/kotlin/mongodb/internal/RealmSyncUtilsKt\n*L\n351#1:354\n351#1:355\n*E\n"})
public final class RealmSyncUtilsKt {
    @PublishedApi
    @NotNull
    public static final <T, R> AppCallback<T> channelResultCallback(@NotNull Channel<Result<R>> channel, @NotNull Function1<? super T, ? extends R> success) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter(success, (String)"success");
        return new AppCallback<T>(channel, success){
            final /* synthetic */ Channel<Result<R>> $channel;
            final /* synthetic */ Function1<T, R> $success;
            {
                this.$channel = $channel;
                this.$success = $success;
            }

            public void onSuccess(T result2) {
                block3: {
                    try {
                        Object sendResult = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)this.$success.invoke(result2))));
                        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
                            Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)sendResult);
                            Intrinsics.checkNotNull((Object)throwable);
                            throw throwable;
                        }
                    }
                    catch (Throwable ex) {
                        Object it = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex))));
                        boolean bl = false;
                        if (ChannelResult.isSuccess-impl((Object)it)) break block3;
                        Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)it);
                        Intrinsics.checkNotNull((Object)throwable);
                        throw throwable;
                    }
                }
            }

            public void onError(AppError error) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    try {
                        Object sendResult = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)RealmSyncUtilsKt.convertAppError(error)))));
                        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
                            Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)sendResult);
                            Intrinsics.checkNotNull((Object)throwable);
                            throw throwable;
                        }
                    }
                    catch (Throwable ex) {
                        Object it = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex))));
                        boolean bl = false;
                        if (ChannelResult.isSuccess-impl((Object)it)) break block3;
                        Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)it);
                        Intrinsics.checkNotNull((Object)throwable);
                        throw throwable;
                    }
                }
            }
        };
    }

    @NotNull
    public static final SyncException convertSyncError(@NotNull SyncError syncError) {
        SyncException syncException;
        Intrinsics.checkNotNullParameter((Object)syncError, (String)"syncError");
        CoreError errorCode = syncError.getErrorCode();
        String message = RealmSyncUtilsKt.createMessageFromSyncError(errorCode);
        ErrorCode errorCode2 = errorCode.getErrorCode();
        switch (errorCode2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[errorCode2.ordinal()]) {
            case 1: {
                syncException = new WrongSyncTypeException(message);
                break;
            }
            case 2: {
                syncException = new BadFlexibleSyncQueryException(message);
                break;
            }
            case 3: {
                syncException = new CompensatingWriteException(message, syncError.getCompensatingWrites());
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                syncException = new UnrecoverableSyncException(message);
                break;
            }
            default: {
                syncException = new SyncException(message);
            }
        }
        return syncException;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final Throwable convertAppError(@NotNull AppError appError) {
        block3: {
            block4: {
                block6: {
                    block7: {
                        block5: {
                            block2: {
                                Intrinsics.checkNotNullParameter((Object)appError, (String)"appError");
                                msg = RealmSyncUtilsKt.createMessageFromAppError(appError);
                                if (!appError.contains(ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR)) break block2;
                                v0 = (Throwable)new ConnectionException(msg);
                                break block3;
                            }
                            if (!appError.contains(ErrorCategory.RLM_ERR_CAT_HTTP_ERROR)) break block4;
                            statusCode = appError.getCode().getNativeValue();
                            var3_5 = statusCode;
                            v1 = 300 <= var3_5 ? var3_5 < 400 : false;
                            if (!v1) break block5;
                            v2 = new ConnectionException(msg);
                            break block6;
                        }
                        if (var3_5 != 401) break block7;
                        v2 = new InvalidCredentialsException(msg);
                        break block6;
                    }
                    if (var3_5 == 408 || var3_5 == 429) ** GOTO lbl-1000
                    v3 = 500 <= var3_5 ? var3_5 < 600 : false;
                    if (v3) lbl-1000:
                    // 2 sources

                    {
                        v2 = new ConnectionException(msg);
                    } else {
                        v2 = new ServiceException(msg, null, 2, null);
                    }
                }
                v0 = (Throwable)v2;
                break block3;
            }
            v0 = appError.contains(ErrorCategory.RLM_ERR_CAT_JSON_ERROR) != false ? (Throwable)new ConnectionException(msg) : (appError.contains(ErrorCategory.RLM_ERR_CAT_CLIENT_ERROR) != false ? (Throwable)((var2_3 = appError.getCode()) == ErrorCode.RLM_ERR_CLIENT_USER_NOT_FOUND ? (RuntimeException)new IllegalStateException(msg) : (var2_3 == ErrorCode.RLM_ERR_CLIENT_USER_ALREADY_NAMED ? (RuntimeException)new CredentialsCannotBeLinkedException(msg) : (RuntimeException)new AppException(msg))) : (appError.contains(ErrorCategory.RLM_ERR_CAT_SERVICE_ERROR) != false ? (Throwable)((var2_4 = appError.getCode()) == ErrorCode.RLM_ERR_INTERNAL_SERVER_ERROR ? new ServiceException(msg, null, 2, null) : (var2_4 == ErrorCode.RLM_ERR_INVALID_SESSION ? new ServiceException(msg, null, 2, null) : (var2_4 == ErrorCode.RLM_ERR_USER_DISABLED || var2_4 == ErrorCode.RLM_ERR_AUTH_ERROR ? (ServiceException)new AuthException(msg) : (var2_4 == ErrorCode.RLM_ERR_USER_NOT_FOUND ? (ServiceException)new UserNotFoundException(msg) : (var2_4 == ErrorCode.RLM_ERR_ACCOUNT_NAME_IN_USE ? (ServiceException)new UserAlreadyExistsException(msg) : (var2_4 == ErrorCode.RLM_ERR_USER_ALREADY_CONFIRMED ? (ServiceException)new UserAlreadyConfirmedException(msg) : (var2_4 == ErrorCode.RLM_ERR_INVALID_PASSWORD ? (ServiceException)new InvalidCredentialsException(msg) : (var2_4 == ErrorCode.RLM_ERR_BAD_REQUEST ? (ServiceException)new BadRequestException(msg) : (var2_4 == ErrorCode.RLM_ERR_FUNCTION_NOT_FOUND || var2_4 == ErrorCode.RLM_ERR_EXECUTION_TIME_LIMIT_EXCEEDED || var2_4 == ErrorCode.RLM_ERR_FUNCTION_EXECUTION_ERROR ? (ServiceException)new FunctionExecutionException(msg) : new ServiceException(msg, appError.getCode())))))))))) : (Throwable)new AppException(msg)));
        }
        return v0;
    }

    @NotNull
    public static final String createMessageFromSyncError(@NotNull CoreError error) {
        String string;
        String errorDesc;
        String categoryDesc;
        block5: {
            block4: {
                Object errorCodeDesc;
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                categoryDesc = error.getCategories().getDescription();
                Object object = error.getErrorCode();
                if (object == null || (object = object.getDescription()) == null) {
                    object = error.getCategories().contains(ErrorCategory.RLM_ERR_CAT_SYSTEM_ERROR) ? null : "Unknown";
                }
                errorDesc = (errorCodeDesc = object) == null ? String.valueOf(error.getErrorCodeNativeValue()) : (String)errorCodeDesc + '(' + error.getErrorCodeNativeValue() + ')';
                string = error.getMessage();
                if (string == null) break block4;
                String message = string;
                boolean bl = false;
                String string2 = ' ' + message + (!StringsKt.endsWith$default((String)message, (String)".", (boolean)false, (int)2, null) ? "." : "");
                string = string2;
                if (string2 != null) break block5;
            }
            string = "";
        }
        String msg = string;
        return '[' + categoryDesc + "][" + errorDesc + ']' + msg;
    }

    private static final String createMessageFromAppError(AppError error) {
        String string;
        String msg;
        String errorCodeDesc;
        String categoryDesc;
        block67: {
            block66: {
                block65: {
                    String string2;
                    block64: {
                        String string3;
                        ErrorCategory errorCategory = error.contains(ErrorCategory.RLM_ERR_CAT_CLIENT_ERROR) ? ErrorCategory.RLM_ERR_CAT_CLIENT_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_JSON_ERROR) ? ErrorCategory.RLM_ERR_CAT_JSON_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_SERVICE_ERROR) ? ErrorCategory.RLM_ERR_CAT_SERVICE_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_HTTP_ERROR) ? ErrorCategory.RLM_ERR_CAT_HTTP_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR) ? ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR : null))));
                        categoryDesc = errorCategory != null && (string3 = errorCategory.getDescription()) != null ? string3 : String.valueOf(error.getCategoryFlags());
                        String string4 = error.getCode().getDescription();
                        if (string4 == null) {
                            if (error.contains(ErrorCategory.RLM_ERR_CAT_HTTP_ERROR)) {
                                switch (error.getCode().getNativeValue()) {
                                    case 300: {
                                        string4 = "MultipleChoices";
                                        break;
                                    }
                                    case 301: {
                                        string4 = "MovedPermanently";
                                        break;
                                    }
                                    case 302: {
                                        string4 = "Found";
                                        break;
                                    }
                                    case 303: {
                                        string4 = "SeeOther";
                                        break;
                                    }
                                    case 304: {
                                        string4 = "NotModified";
                                        break;
                                    }
                                    case 305: {
                                        string4 = "UseProxy";
                                        break;
                                    }
                                    case 307: {
                                        string4 = "TemporaryRedirect";
                                        break;
                                    }
                                    case 308: {
                                        string4 = "PermanentRedirect";
                                        break;
                                    }
                                    case 400: {
                                        string4 = "BadRequest";
                                        break;
                                    }
                                    case 401: {
                                        string4 = "Unauthorized";
                                        break;
                                    }
                                    case 402: {
                                        string4 = "PaymentRequired";
                                        break;
                                    }
                                    case 403: {
                                        string4 = "Forbidden";
                                        break;
                                    }
                                    case 404: {
                                        string4 = "NotFound";
                                        break;
                                    }
                                    case 405: {
                                        string4 = "MethodNotAllowed";
                                        break;
                                    }
                                    case 406: {
                                        string4 = "NotAcceptable";
                                        break;
                                    }
                                    case 407: {
                                        string4 = "ProxyAuthenticationRequired";
                                        break;
                                    }
                                    case 408: {
                                        string4 = "RequestTimeout";
                                        break;
                                    }
                                    case 409: {
                                        string4 = "Conflict";
                                        break;
                                    }
                                    case 410: {
                                        string4 = "Gone";
                                        break;
                                    }
                                    case 411: {
                                        string4 = "LengthRequired";
                                        break;
                                    }
                                    case 412: {
                                        string4 = "PreconditionFailed";
                                        break;
                                    }
                                    case 413: {
                                        string4 = "ContentTooLarge";
                                        break;
                                    }
                                    case 414: {
                                        string4 = "UriTooLong";
                                        break;
                                    }
                                    case 415: {
                                        string4 = "UnsupportedMediaType";
                                        break;
                                    }
                                    case 416: {
                                        string4 = "RangeNotSatisfiable";
                                        break;
                                    }
                                    case 417: {
                                        string4 = "ExpectationFailed";
                                        break;
                                    }
                                    case 421: {
                                        string4 = "MisdirectedRequest";
                                        break;
                                    }
                                    case 422: {
                                        string4 = "UnprocessableContent";
                                        break;
                                    }
                                    case 423: {
                                        string4 = "Locked";
                                        break;
                                    }
                                    case 424: {
                                        string4 = "FailedDependency";
                                        break;
                                    }
                                    case 425: {
                                        string4 = "TooEarly";
                                        break;
                                    }
                                    case 426: {
                                        string4 = "UpgradeRequired";
                                        break;
                                    }
                                    case 428: {
                                        string4 = "PreconditionRequired";
                                        break;
                                    }
                                    case 429: {
                                        string4 = "TooManyRequests";
                                        break;
                                    }
                                    case 431: {
                                        string4 = "RequestHeaderFieldsTooLarge";
                                        break;
                                    }
                                    case 451: {
                                        string4 = "UnavailableForLegalReasons";
                                        break;
                                    }
                                    case 500: {
                                        string4 = "InternalServerError";
                                        break;
                                    }
                                    case 501: {
                                        string4 = "NotImplemented";
                                        break;
                                    }
                                    case 502: {
                                        string4 = "BadGateway";
                                        break;
                                    }
                                    case 503: {
                                        string4 = "ServiceUnavailable";
                                        break;
                                    }
                                    case 504: {
                                        string4 = "GatewayTimeout";
                                        break;
                                    }
                                    case 505: {
                                        string4 = "HttpVersionNotSupported";
                                        break;
                                    }
                                    case 506: {
                                        string4 = "VariantAlsoNegotiates";
                                        break;
                                    }
                                    case 507: {
                                        string4 = "InsufficientStorage";
                                        break;
                                    }
                                    case 508: {
                                        string4 = "LoopDetected";
                                        break;
                                    }
                                    case 510: {
                                        string4 = "NotExtended";
                                        break;
                                    }
                                    case 511: {
                                        string4 = "NetworkAuthenticationRequired";
                                        break;
                                    }
                                    default: {
                                        string4 = "Unknown";
                                        break;
                                    }
                                }
                            } else if (error.contains(ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR)) {
                                switch (error.getCode().getNativeValue()) {
                                    case 1000: {
                                        string4 = "IO";
                                        break;
                                    }
                                    case 1001: {
                                        string4 = "Interrupted";
                                        break;
                                    }
                                    default: {
                                        string4 = "Unknown";
                                        break;
                                    }
                                }
                            } else {
                                string4 = errorCodeDesc = "Unknown";
                            }
                        }
                        if ((string2 = error.getMessage()) == null) break block64;
                        String message = string2;
                        boolean bl = false;
                        String string5 = StringsKt.endsWith$default((String)message, (String)".", (boolean)false, (int)2, null) ? message : ' ' + message + '.';
                        string2 = string5;
                        if (string5 != null) break block65;
                    }
                    string2 = msg = "";
                }
                if ((string = error.getLinkToServerLog()) == null) break block66;
                String link = string;
                boolean bl = false;
                String string6 = " Server log entry: " + link;
                string = string6;
                if (string6 != null) break block67;
            }
            string = "";
        }
        String serverLogsLink = string;
        String errorDesc = errorCodeDesc + '(' + error.getCode().getNativeValue() + ')';
        return '[' + categoryDesc + "][" + errorDesc + ']' + msg + serverLogsLink;
    }

    @PublishedApi
    public static final /* synthetic */ <T> KSerializer<T> serializerOrRealmBuiltInSerializer(SerializersModule $this$serializerOrRealmBuiltInSerializer) {
        KSerializer kSerializer;
        Intrinsics.checkNotNullParameter((Object)$this$serializerOrRealmBuiltInSerializer, (String)"<this>");
        boolean $i$f$serializerOrRealmBuiltInSerializer = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MutableRealmInt.class))) {
            kSerializer = (KSerializer)MutableRealmIntKSerializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmUUID.class))) {
            kSerializer = (KSerializer)RealmUUIDKSerializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmInstant.class))) {
            kSerializer = (KSerializer)RealmInstantKSerializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmAny.class))) {
            kSerializer = (KSerializer)RealmAnyKSerializer.INSTANCE;
        } else {
            SerializersModule $this$serializer$iv = $this$serializerOrRealmBuiltInSerializer;
            boolean $i$f$serializer = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            KSerializer $this$cast$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv, null);
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            kSerializer = $this$cast$iv$iv;
        }
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of io.realm.kotlin.mongodb.internal.RealmSyncUtilsKt.serializerOrRealmBuiltInSerializer>");
        return kSerializer;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorCode.values().length];
            try {
                nArray[ErrorCode.RLM_ERR_WRONG_SYNC_TYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorCode.RLM_ERR_INVALID_SUBSCRIPTION_QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorCode.RLM_ERR_SYNC_COMPENSATING_WRITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorCode.RLM_ERR_SYNC_PROTOCOL_INVARIANT_FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorCode.RLM_ERR_SYNC_PROTOCOL_NEGOTIATION_FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorCode.RLM_ERR_SYNC_PERMISSION_DENIED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

