/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.ContextLogger;
import io.realm.kotlin.internal.interop.CapiT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.sync.WebSocketClient;
import io.realm.kotlin.internal.interop.sync.WebSocketObserver;
import io.realm.kotlin.internal.interop.sync.WebsocketCallbackResult;
import io.realm.kotlin.internal.interop.sync.WebsocketEngine;
import io.realm.kotlin.internal.interop.sync.WebsocketErrorCode;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u00c2\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012y\u0010\u0011\u001au\u0012,\u0012*\u0012\u0004\u0012\u00020\u00180\u0017j\u0011`\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0012\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J \u00103\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\"\u00104\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u00105\u001a\u0002062\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J'\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u0002092\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00180\u0017j\u0002`\u0013H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\u001dH\u0016J\u0016\u0010<\u001a\u00020\u001d2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001d0>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0081\u0001\u0010\u0011\u001au\u0012,\u0012*\u0012\u0004\u0012\u00020\u00180\u0017j\u0011`\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/realm/kotlin/mongodb/internal/OkHttpWebsocketClient;", "Lio/realm/kotlin/internal/interop/sync/WebSocketClient;", "Lokhttp3/WebSocketListener;", "observer", "Lio/realm/kotlin/internal/interop/sync/WebSocketObserver;", "path", "", "address", "port", "", "isSsl", "", "supportedSyncProtocols", "websocketEngine", "Lio/realm/kotlin/internal/interop/sync/WebsocketEngine;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "runCallback", "Lkotlin/Function4;", "Lio/realm/kotlin/internal/interop/RealmWebsocketHandlerCallbackPointer;", "Lkotlin/ParameterName;", "name", "handlerCallback", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/CapiT;", "cancelled", "Lio/realm/kotlin/internal/interop/sync/WebsocketCallbackResult;", "status", "reason", "", "<init>", "(Lio/realm/kotlin/internal/interop/sync/WebSocketObserver;Ljava/lang/String;Ljava/lang/String;JZLjava/lang/String;Lio/realm/kotlin/internal/interop/sync/WebsocketEngine;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function4;)V", "logger", "Lio/realm/kotlin/internal/ContextLogger;", "okHttpClient", "Lokhttp3/OkHttpClient;", "webSocket", "Lokhttp3/WebSocket;", "observerIsClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isClosed", "protocolSelectionHeader", "onOpen", "response", "Lokhttp3/Response;", "onMessage", "bytes", "Lokio/ByteString;", "onClosing", "code", "", "onClosed", "onFailure", "t", "", "send", "message", "", "([BLio/realm/kotlin/internal/interop/NativePointer;)V", "close", "runIfObserverNotClosed", "block", "Lkotlin/Function0;", "io.realm.kotlin.library"})
public final class OkHttpWebsocketClient
extends WebSocketListener
implements WebSocketClient {
    @NotNull
    private final WebSocketObserver observer;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Function4<NativePointer<CapiT>, Boolean, WebsocketCallbackResult, String, Unit> runCallback;
    @NotNull
    private final ContextLogger logger;
    @NotNull
    private final OkHttpClient okHttpClient;
    private WebSocket webSocket;
    @NotNull
    private final AtomicBoolean observerIsClosed;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final String protocolSelectionHeader;

    public OkHttpWebsocketClient(@NotNull WebSocketObserver observer, @NotNull String path, @NotNull String address, long port, boolean isSsl, @NotNull String supportedSyncProtocols, @NotNull WebsocketEngine websocketEngine, @NotNull CoroutineScope scope, @NotNull Function4<? super NativePointer<CapiT>, ? super Boolean, ? super WebsocketCallbackResult, ? super String, Unit> runCallback) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)supportedSyncProtocols, (String)"supportedSyncProtocols");
        Intrinsics.checkNotNullParameter((Object)websocketEngine, (String)"websocketEngine");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(runCallback, (String)"runCallback");
        this.observer = observer;
        this.scope = scope;
        this.runCallback = runCallback;
        this.logger = new ContextLogger("Websocket-" + Random.Default.nextInt());
        this.okHttpClient = (OkHttpClient)websocketEngine.getInstance();
        this.observerIsClosed = new AtomicBoolean(false);
        this.isClosed = new AtomicBoolean(false);
        this.protocolSelectionHeader = "Sec-WebSocket-Protocol";
        String websocketURL = (isSsl ? "wss" : "ws") + "://" + address + ':' + port + path;
        Request request = new Request.Builder().url(websocketURL).addHeader(this.protocolSelectionHeader, supportedSyncProtocols).build();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            final /* synthetic */ OkHttpWebsocketClient this$0;
            final /* synthetic */ Request $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.okHttpClient.newWebSocket(this.$request, (WebSocketListener)this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            super.onOpen(webSocket, response);
            this.logger.debug("onOpen websocket " + webSocket.request().url(), new Object[0]);
            this.webSocket = webSocket;
            String string = Response.header$default((Response)response, (String)this.protocolSelectionHeader, null, (int)2, null);
            if (string == null) break block0;
            String selectedProtocol = string;
            boolean bl = false;
            this.runIfObserverNotClosed((Function0<Unit>)((Function0)() -> OkHttpWebsocketClient.onOpen$lambda$1$lambda$0(this, selectedProtocol)));
        }
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super.onMessage(webSocket, bytes);
        this.logger.trace("onMessage: " + StringsKt.decodeToString((byte[])bytes.toByteArray()) + " isClosed = " + this.isClosed.get() + " observerIsClosed = " + this.observerIsClosed.get(), new Object[0]);
        this.runIfObserverNotClosed((Function0<Unit>)((Function0)() -> OkHttpWebsocketClient.onMessage$lambda$2(this, bytes, webSocket)));
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super.onClosing(webSocket, code, reason);
        this.logger.debug("onClosing code = " + code + " reason = " + reason + " isClosed = " + this.isClosed.get() + " observerIsClosed = " + this.observerIsClosed.get(), new Object[0]);
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super.onClosed(webSocket, code, reason);
        this.logger.debug("onClosed code = " + code + " reason = " + reason + " isClosed = " + this.isClosed.get() + " observerIsClosed = " + this.observerIsClosed.get(), new Object[0]);
        this.isClosed.set(true);
        this.runIfObserverNotClosed((Function0<Unit>)((Function0)() -> OkHttpWebsocketClient.onClosed$lambda$5(code, this, reason)));
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        super.onFailure(webSocket, t, response);
        this.logger.debug("onFailure throwable '" + t.getMessage() + "' isClosed = " + this.isClosed.get() + " observerIsClosed = " + this.observerIsClosed.get(), new Object[0]);
        this.runIfObserverNotClosed((Function0<Unit>)((Function0)() -> OkHttpWebsocketClient.onFailure$lambda$6(this)));
    }

    public void send(@NotNull byte[] message, @NotNull NativePointer<CapiT> handlerCallback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(handlerCallback, (String)"handlerCallback");
        this.logger.trace("send: " + StringsKt.decodeToString((byte[])message) + " isClosed = " + this.isClosed.get() + " observerIsClosed = " + this.observerIsClosed.get(), new Object[0]);
        Job job = !this.isClosed.get() ? BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, handlerCallback, null){
            int label;
            final /* synthetic */ OkHttpWebsocketClient this$0;
            final /* synthetic */ byte[] $message;
            final /* synthetic */ NativePointer<CapiT> $handlerCallback;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$handlerCallback = $handlerCallback;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            if (!OkHttpWebsocketClient.access$isClosed$p(this.this$0).get()) {
                                WebSocket webSocket = OkHttpWebsocketClient.access$getWebSocket$p(this.this$0);
                                if (webSocket == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
                                    webSocket = null;
                                }
                                webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])this.$message, (int)0, (int)0, (int)3, null));
                                OkHttpWebsocketClient.access$getRunCallback$p(this.this$0).invoke(this.$handlerCallback, (Object)Boxing.boxBoolean((boolean)OkHttpWebsocketClient.access$getObserverIsClosed$p(this.this$0).get()), (Object)WebsocketCallbackResult.RLM_ERR_SYNC_SOCKET_SUCCESS, (Object)"");
                            } else {
                                OkHttpWebsocketClient.access$getRunCallback$p(this.this$0).invoke(this.$handlerCallback, (Object)Boxing.boxBoolean((boolean)OkHttpWebsocketClient.access$getObserverIsClosed$p(this.this$0).get()), (Object)WebsocketCallbackResult.RLM_ERR_SYNC_SOCKET_CONNECTION_CLOSED, (Object)"Connection already closed");
                            }
                        }
                        catch (Exception e) {
                            OkHttpWebsocketClient.access$getRunCallback$p(this.this$0).invoke(this.$handlerCallback, (Object)Boxing.boxBoolean((boolean)OkHttpWebsocketClient.access$getObserverIsClosed$p(this.this$0).get()), (Object)WebsocketCallbackResult.RLM_ERR_SYNC_SOCKET_RUNTIME, (Object)("Sending Frame exception: " + e.getMessage()));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null) : BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, handlerCallback, null){
            int label;
            final /* synthetic */ OkHttpWebsocketClient this$0;
            final /* synthetic */ NativePointer<CapiT> $handlerCallback;
            {
                this.this$0 = $receiver;
                this.$handlerCallback = $handlerCallback;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OkHttpWebsocketClient.access$getRunCallback$p(this.this$0).invoke(this.$handlerCallback, (Object)Boxing.boxBoolean((boolean)OkHttpWebsocketClient.access$getObserverIsClosed$p(this.this$0).get()), (Object)WebsocketCallbackResult.RLM_ERR_SYNC_SOCKET_CONNECTION_CLOSED, (Object)"Connection already closed");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void close() {
        this.logger.debug("close", new Object[0]);
        this.observerIsClosed.set(true);
        if (this.webSocket != null) {
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ OkHttpWebsocketClient this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (!OkHttpWebsocketClient.access$isClosed$p(this.this$0).get()) {
                                WebSocket webSocket = OkHttpWebsocketClient.access$getWebSocket$p(this.this$0);
                                if (webSocket == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
                                    webSocket = null;
                                }
                                webSocket.close(WebsocketErrorCode.RLM_ERR_WEBSOCKET_OK.getNativeValue(), "client closed websocket");
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void runIfObserverNotClosed(Function0<Unit> block) {
        if (!this.observerIsClosed.get()) {
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, block, null){
                int label;
                final /* synthetic */ OkHttpWebsocketClient this$0;
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.this$0 = $receiver;
                    this.$block = $block;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (!OkHttpWebsocketClient.access$getObserverIsClosed$p(this.this$0).get()) {
                                this.$block.invoke();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private static final Unit onOpen$lambda$1$lambda$0(OkHttpWebsocketClient this$0, String $selectedProtocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$selectedProtocol, (String)"$selectedProtocol");
        this$0.observer.onConnected($selectedProtocol);
        return Unit.INSTANCE;
    }

    private static final Unit onMessage$lambda$2(OkHttpWebsocketClient this$0, ByteString $bytes, WebSocket $webSocket) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        Intrinsics.checkNotNullParameter((Object)$webSocket, (String)"$webSocket");
        boolean shouldClose = this$0.observer.onNewMessage($bytes.toByteArray());
        if (shouldClose) {
            $webSocket.close(WebsocketErrorCode.RLM_ERR_WEBSOCKET_OK.getNativeValue(), "websocket should be closed after last message received");
        }
        return Unit.INSTANCE;
    }

    private static final Unit onClosed$lambda$5(int $code, OkHttpWebsocketClient this$0, String $reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        WebsocketErrorCode websocketErrorCode = WebsocketErrorCode.Companion.of($code);
        if (websocketErrorCode != null) {
            WebsocketErrorCode errorCode = websocketErrorCode;
            boolean bl = false;
            this$0.observer.onClose(true, errorCode, $reason);
        } else {
            OkHttpWebsocketClient $this$onClosed_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            $this$onClosed_u24lambda_u245_u24lambda_u244.observer.onClose(true, WebsocketErrorCode.RLM_ERR_WEBSOCKET_FATAL_ERROR, "Unknown error code " + $code + ". original reason " + $reason);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onFailure$lambda$6(OkHttpWebsocketClient this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.observer.onError();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AtomicBoolean access$isClosed$p(OkHttpWebsocketClient $this) {
        return $this.isClosed;
    }

    public static final /* synthetic */ WebSocket access$getWebSocket$p(OkHttpWebsocketClient $this) {
        return $this.webSocket;
    }

    public static final /* synthetic */ Function4 access$getRunCallback$p(OkHttpWebsocketClient $this) {
        return $this.runCallback;
    }

    public static final /* synthetic */ AtomicBoolean access$getObserverIsClosed$p(OkHttpWebsocketClient $this) {
        return $this.observerIsClosed;
    }
}

