/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.mongodb.internal.MongoCollectionImpl;
import io.realm.kotlin.mongodb.internal.MongoDatabaseImpl;
import io.realm.kotlin.mongodb.mongo.MongoCollection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.EJson;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0017\"\u0004\b\u0001\u0010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lio/realm/kotlin/mongodb/internal/MongoDatabaseCollection;", "T", "Lio/realm/kotlin/mongodb/internal/MongoCollectionImpl;", "database", "Lio/realm/kotlin/mongodb/internal/MongoDatabaseImpl;", "name", "", "eJson", "Lorg/mongodb/kbson/serialization/EJson;", "<init>", "(Lio/realm/kotlin/mongodb/internal/MongoDatabaseImpl;Ljava/lang/String;Lorg/mongodb/kbson/serialization/EJson;)V", "getDatabase$annotations", "()V", "getDatabase", "()Lio/realm/kotlin/mongodb/internal/MongoDatabaseImpl;", "getName", "()Ljava/lang/String;", "defaults", "", "Lorg/mongodb/kbson/BsonValue;", "getDefaults", "()Ljava/util/Map;", "withDocumentClass", "Lio/realm/kotlin/mongodb/mongo/MongoCollection;", "io.realm.kotlin.library"})
@PublishedApi
public final class MongoDatabaseCollection<T>
extends MongoCollectionImpl<T> {
    @NotNull
    private final MongoDatabaseImpl database;
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, BsonValue> defaults;

    public MongoDatabaseCollection(@NotNull MongoDatabaseImpl database, @NotNull String name, @NotNull EJson eJson) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)eJson, (String)"eJson");
        super(database.getClient().getFunctions(), eJson);
        this.database = database;
        this.name = name;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"database", (Object)new BsonString(this.database.getName())), TuplesKt.to((Object)"collection", (Object)new BsonString(this.getName()))};
        this.defaults = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final MongoDatabaseImpl getDatabase() {
        return this.database;
    }

    @PublishedApi
    public static /* synthetic */ void getDatabase$annotations() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Map<String, BsonValue> getDefaults() {
        return this.defaults;
    }

    @Override
    @NotNull
    public <T> MongoCollection<T> withDocumentClass(@Nullable EJson eJson) {
        String string = this.getName();
        EJson eJson2 = eJson;
        if (eJson2 == null) {
            eJson2 = this.getEJson();
        }
        return new MongoDatabaseCollection<T>(this.database, string, eJson2);
    }
}

