/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.ext.IterableExtKt;
import io.realm.kotlin.internal.RealmInstantImplKt;
import io.realm.kotlin.internal.RealmObjectCompanion;
import io.realm.kotlin.internal.interop.CollectionType;
import io.realm.kotlin.internal.platform.RealmObjectKt;
import io.realm.kotlin.internal.schema.RealmClassImpl;
import io.realm.kotlin.internal.schema.RealmPropertyTypeImplKt;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.schema.RealmProperty;
import io.realm.kotlin.schema.RealmPropertyType;
import io.realm.kotlin.schema.RealmStorageType;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.MutableRealmInt;
import io.realm.kotlin.types.RealmAny;
import io.realm.kotlin.types.RealmInstant;
import io.realm.kotlin.types.RealmObject;
import io.realm.kotlin.types.RealmUUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonArray;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBinarySubType;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDateTime;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\b\u0000\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0002H\u0002J\"\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010\u001e\u001a\u0004\u0018\u00010'H\u0002J\u0012\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J5\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010-\u001a\u0004\u0018\u00010\"H\u0000\u00a2\u0006\u0002\b.J\u0014\u0010/\u001a\u0004\u0018\u00010*2\b\u0010-\u001a\u0004\u0018\u00010\"H\u0002R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lio/realm/kotlin/mongodb/internal/MongoDBSerializer;", "Lkotlinx/serialization/KSerializer;", "Lio/realm/kotlin/types/BaseRealmObject;", "clazz", "Lkotlin/reflect/KClass;", "schema", "", "", "Lio/realm/kotlin/internal/RealmObjectCompanion;", "<init>", "(Lkotlin/reflect/KClass;Ljava/util/Map;)V", "getSchema$io_realm_kotlin_library", "()Ljava/util/Map;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "companion", "getCompanion$annotations", "()V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "bsonToObject", "bsonDocument", "Lorg/mongodb/kbson/BsonDocument;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "objectToBson", "realmObject", "storageTypeToBsonValue", "Lorg/mongodb/kbson/BsonValue;", "collectionType", "Lio/realm/kotlin/internal/interop/CollectionType;", "elementType", "Lio/realm/kotlin/schema/RealmStorageType;", "", "realmAnyToBsonValue", "realmAny", "Lio/realm/kotlin/types/RealmAny;", "bsonValueToStorageType", "kClass", "bsonValue", "bsonValueToStorageType$io_realm_kotlin_library", "bsonValueToRealmAny", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nMongoDBSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBSerializer.kt\nio/realm/kotlin/mongodb/internal/MongoDBSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 RealmInstantImpl.kt\nio/realm/kotlin/internal/RealmInstantImplKt\n+ 5 RealmUUIDImpl.kt\nio/realm/kotlin/internal/RealmUUIDImplKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 RealmAny.kt\nio/realm/kotlin/types/RealmAny$Companion\n*L\n1#1,426:1\n1863#2,2:427\n1557#2:433\n1628#2,3:434\n1557#2:437\n1628#2,3:438\n1246#2,4:443\n1557#2:449\n1628#2,3:450\n1246#2,4:455\n1557#2:461\n1628#2,3:462\n1246#2,4:467\n1557#2:471\n1628#2,3:472\n1246#2,4:479\n1557#2:483\n1628#2,3:484\n216#3,2:429\n49#4:431\n49#4:447\n50#4:459\n50#4:475\n107#5:432\n107#5:448\n108#5:460\n462#6:441\n412#6:442\n462#6:453\n412#6:454\n462#6:465\n412#6:466\n462#6:477\n412#6:478\n370#7:476\n*S KotlinDebug\n*F\n+ 1 MongoDBSerializer.kt\nio/realm/kotlin/mongodb/internal/MongoDBSerializer\n*L\n90#1:427,2\n177#1:433\n177#1:434,3\n188#1:437\n188#1:438,3\n201#1:443,4\n249#1:449\n249#1:450,3\n252#1:455,4\n319#1:461\n319#1:462,3\n328#1:467,4\n338#1:471\n338#1:472,3\n404#1:479,4\n410#1:483\n410#1:484,3\n113#1:429,2\n169#1:431\n221#1:447\n312#1:459\n374#1:475\n171#1:432\n226#1:448\n314#1:460\n201#1:441\n201#1:442\n252#1:453\n252#1:454\n328#1:465\n328#1:466\n404#1:477\n404#1:478\n401#1:476\n*E\n"})
public final class MongoDBSerializer
implements KSerializer<BaseRealmObject> {
    @NotNull
    private final Map<String, RealmObjectCompanion> schema;
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final RealmObjectCompanion companion;

    public MongoDBSerializer(@NotNull KClass<? extends BaseRealmObject> clazz, @NotNull Map<String, ? extends RealmObjectCompanion> schema) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.schema = schema;
        this.descriptor = BsonDocument.Companion.serializer().getDescriptor();
        this.companion = RealmObjectKt.realmObjectCompanionOrThrow(clazz);
    }

    public /* synthetic */ MongoDBSerializer(KClass kClass, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this((KClass<? extends BaseRealmObject>)kClass, map);
    }

    @NotNull
    public final Map<String, RealmObjectCompanion> getSchema$io_realm_kotlin_library() {
        return this.schema;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    private static /* synthetic */ void getCompanion$annotations() {
    }

    @NotNull
    public BaseRealmObject deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return this.bsonToObject(this.companion, (BsonDocument)decoder.decodeSerializableValue((DeserializationStrategy)BsonDocument.Companion.serializer()));
    }

    private final BaseRealmObject bsonToObject(RealmObjectCompanion companion, BsonDocument bsonDocument) {
        Object object = companion.io_realm_kotlin_newInstance();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.realm.kotlin.types.BaseRealmObject");
        BaseRealmObject instance = (BaseRealmObject)object;
        Map fields = companion.getIo_realm_kotlin_fields();
        RealmClassImpl schema = companion.io_realm_kotlin_schema();
        Iterable $this$forEach$iv = bsonDocument.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair;
            String key = (String)element$iv;
            boolean bl = false;
            if ((Pair)fields.get(key) == null) {
                throw new SerializationException("Unknown field '" + key + "' for type " + companion.getIo_realm_kotlin_className());
            }
            KClass kClass = (KClass)pair.component1();
            KProperty1 accessor = (KProperty1)pair.component2();
            RealmProperty realmProperty = schema.get(key);
            if (realmProperty == null || (realmProperty = realmProperty.getType()) == null) {
                throw new SerializationException("Unknown field '" + key + "' for type " + companion.getIo_realm_kotlin_className());
            }
            RealmProperty type = realmProperty;
            Object value = this.bsonValueToStorageType$io_realm_kotlin_library(RealmPropertyTypeImplKt.getCollectionType((RealmPropertyType)type), type.getStorageType(), kClass, (BsonValue)bsonDocument.get((Object)key));
            Intrinsics.checkNotNull((Object)accessor, (String)"null cannot be cast to non-null type kotlin.reflect.KMutableProperty1<io.realm.kotlin.types.BaseRealmObject, kotlin.Any?>");
            ((KMutableProperty1)accessor).set((Object)instance, value);
        }
        return instance;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull BaseRealmObject value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeSerializableValue((SerializationStrategy)BsonDocument.Companion.serializer(), (Object)this.objectToBson(this.companion, value));
    }

    private final BsonDocument objectToBson(RealmObjectCompanion companion, BaseRealmObject realmObject) {
        Map fields = companion.getIo_realm_kotlin_fields();
        RealmClassImpl schema = companion.io_realm_kotlin_schema();
        BsonDocument document = new BsonDocument(null, 1, null);
        Map $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String fieldName = (String)entry.getKey();
            Pair fieldDetails = (Pair)entry.getValue();
            KProperty1 accessor = (KProperty1)fieldDetails.component2();
            RealmProperty realmProperty = schema.get(fieldName);
            if (realmProperty == null || (realmProperty = realmProperty.getType()) == null) {
                Validation.INSTANCE.sdkError("Schema does not contain property " + fieldName);
                throw new KotlinNothingValueException();
            }
            RealmProperty type = realmProperty;
            BsonValue it = this.storageTypeToBsonValue(RealmPropertyTypeImplKt.getCollectionType((RealmPropertyType)type), type.getStorageType(), accessor.get((Object)realmObject));
            boolean bl2 = false;
            ((Map)document).put(fieldName, it);
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private final BsonValue storageTypeToBsonValue(CollectionType collectionType, RealmStorageType elementType, Object value) {
        BsonValue bsonValue;
        if (value == null) {
            return (BsonValue)BsonNull.INSTANCE;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[collectionType.ordinal()]) {
            case 1: {
                switch (WhenMappings.$EnumSwitchMapping$0[elementType.ordinal()]) {
                    case 1: {
                        bsonValue = (BsonValue)new BsonBoolean(((Boolean)value).booleanValue());
                        break block0;
                    }
                    case 2: {
                        BsonInt32 bsonInt32;
                        Object object = value;
                        if (object instanceof Byte) {
                            bsonInt32 = new BsonInt32((int)((Number)value).byteValue());
                        } else if (object instanceof Character) {
                            bsonInt32 = new BsonInt32((int)((Character)value).charValue());
                        } else if (object instanceof Short) {
                            bsonInt32 = new BsonInt32((int)((Number)value).shortValue());
                        } else if (object instanceof Integer) {
                            bsonInt32 = new BsonInt32(((Number)value).intValue());
                        } else if (object instanceof Long) {
                            bsonInt32 = new BsonInt64(((Number)value).longValue());
                        } else if (object instanceof MutableRealmInt) {
                            bsonInt32 = new BsonInt64(((MutableRealmInt)value).longValue());
                        } else {
                            Validation.INSTANCE.sdkError("Unexpected value of type " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + " for field with storage type " + elementType);
                            throw new KotlinNothingValueException();
                        }
                        bsonValue = (BsonValue)bsonInt32;
                        break block0;
                    }
                    case 3: {
                        bsonValue = (BsonValue)new BsonString((String)value);
                        break block0;
                    }
                    case 4: {
                        bsonValue = (BsonValue)new BsonBinary((byte[])value);
                        break block0;
                    }
                    case 5: {
                        RealmObjectCompanion targetCompanion2 = RealmObjectKt.realmObjectCompanionOrThrow((KClass)Reflection.getOrCreateKotlinClass(value.getClass()));
                        KMutableProperty1 primaryKeyProperty = targetCompanion2.getIo_realm_kotlin_primaryKey();
                        if (primaryKeyProperty == null) {
                            bsonValue = (BsonValue)this.objectToBson(targetCompanion2, (BaseRealmObject)value);
                            break block0;
                        }
                        RealmProperty realmProperty = targetCompanion2.io_realm_kotlin_schema().getPrimaryKey();
                        Intrinsics.checkNotNull((Object)realmProperty);
                        RealmStorageType targetStorageType = realmProperty.getType().getStorageType();
                        Object primaryKey = primaryKeyProperty.get((Object)((BaseRealmObject)value));
                        bsonValue = this.storageTypeToBsonValue(CollectionType.RLM_COLLECTION_TYPE_NONE, targetStorageType, primaryKey);
                        break block0;
                    }
                    case 6: {
                        bsonValue = (BsonValue)new BsonDouble((double)((Float)value).floatValue());
                        break block0;
                    }
                    case 7: {
                        bsonValue = (BsonValue)new BsonDouble(((Double)value).doubleValue());
                        break block0;
                    }
                    case 8: {
                        bsonValue = (BsonValue)((BsonDecimal128)value);
                        break block0;
                    }
                    case 9: {
                        RealmInstant $this$asBsonDateTime$iv = (RealmInstant)value;
                        boolean $i$f$asBsonDateTime = false;
                        bsonValue = (BsonValue)new BsonDateTime(Duration.getInWholeMilliseconds-impl((long)RealmInstantImplKt.toDuration((RealmInstant)$this$asBsonDateTime$iv)));
                        break block0;
                    }
                    case 10: {
                        bsonValue = (BsonValue)((BsonObjectId)value);
                        break block0;
                    }
                    case 11: {
                        RealmUUID $this$asBsonBinary$iv = (RealmUUID)value;
                        boolean $i$f$asBsonBinary = false;
                        bsonValue = (BsonValue)new BsonBinary(BsonBinarySubType.UUID_STANDARD, $this$asBsonBinary$iv.getBytes());
                        break block0;
                    }
                    case 12: {
                        bsonValue = this.realmAnyToBsonValue((RealmAny)value);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (List)value;
                boolean $i$f$map = false;
                Iterable $this$asBsonBinary$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator targetStorageType = $this$mapTo$iv$iv.iterator();
                while (targetStorageType.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = targetStorageType.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.storageTypeToBsonValue(CollectionType.RLM_COLLECTION_TYPE_NONE, elementType, it));
                }
                List list = (List)destination$iv$iv;
                bsonValue = (BsonValue)new BsonArray(list);
                break;
            }
            case 3: {
                Iterable $this$map$iv = (Set)value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator targetStorageType = $this$mapTo$iv$iv.iterator();
                while (targetStorageType.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = targetStorageType.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.storageTypeToBsonValue(CollectionType.RLM_COLLECTION_TYPE_NONE, elementType, it));
                }
                List list = (List)destination$iv$iv;
                bsonValue = (BsonValue)new BsonArray(list);
                break;
            }
            case 4: {
                void $this$mapValuesTo$iv$iv;
                Map map;
                Map $this$mapValues$iv = map = (Map)value;
                boolean $i$f$mapValues = false;
                Map destination$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl2 = false;
                    Object v = entry2.getValue();
                    BsonValue bsonValue2 = this.storageTypeToBsonValue(CollectionType.RLM_COLLECTION_TYPE_NONE, elementType, v);
                    map3.put(k, bsonValue2);
                }
                Map map4 = destination$iv$iv2;
                bsonValue = (BsonValue)new BsonDocument(map4);
                break;
            }
            default: {
                Validation.INSTANCE.sdkError("Unknown collection type: " + collectionType);
                throw new KotlinNothingValueException();
            }
        }
        return bsonValue;
    }

    /*
     * WARNING - void declaration
     */
    private final BsonValue realmAnyToBsonValue(RealmAny realmAny) {
        BsonValue bsonValue;
        RealmAny realmAny2 = realmAny;
        Object object = realmAny2 != null ? realmAny2.getType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$2[object.ordinal()]) {
            case -1: {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
                break;
            }
            case 1: {
                bsonValue = (BsonValue)new BsonBoolean(realmAny.asBoolean());
                break;
            }
            case 2: {
                bsonValue = (BsonValue)new BsonInt64(realmAny.asLong());
                break;
            }
            case 3: {
                bsonValue = (BsonValue)new BsonString(realmAny.asString());
                break;
            }
            case 4: {
                bsonValue = (BsonValue)new BsonBinary(realmAny.asByteArray());
                break;
            }
            case 5: {
                RealmInstant $this$asBsonDateTime$iv = realmAny.asRealmInstant();
                boolean $i$f$asBsonDateTime = false;
                bsonValue = (BsonValue)new BsonDateTime(Duration.getInWholeMilliseconds-impl((long)RealmInstantImplKt.toDuration((RealmInstant)$this$asBsonDateTime$iv)));
                break;
            }
            case 6: {
                bsonValue = (BsonValue)new BsonDouble((double)realmAny.asFloat());
                break;
            }
            case 7: {
                bsonValue = (BsonValue)new BsonDouble(realmAny.asDouble());
                break;
            }
            case 8: {
                bsonValue = (BsonValue)realmAny.asDecimal128();
                break;
            }
            case 9: {
                bsonValue = (BsonValue)realmAny.asObjectId();
                break;
            }
            case 10: {
                RealmUUID $this$asBsonBinary$iv = realmAny.asRealmUUID();
                boolean $i$f$asBsonBinary = false;
                bsonValue = (BsonValue)new BsonBinary(BsonBinarySubType.UUID_STANDARD, $this$asBsonBinary$iv.getBytes());
                break;
            }
            case 11: {
                BaseRealmObject target = realmAny.asRealmObject(Reflection.getOrCreateKotlinClass(BaseRealmObject.class));
                RealmObjectCompanion targetCompanion2 = RealmObjectKt.realmObjectCompanionOrThrow((KClass)Reflection.getOrCreateKotlinClass(target.getClass()));
                RealmProperty realmProperty = targetCompanion2.io_realm_kotlin_schema().getPrimaryKey();
                if (realmProperty == null) {
                    throw new SerializationException("Cannot serialize class without primary key: '" + targetCompanion2.getIo_realm_kotlin_className() + '\'');
                }
                RealmProperty primaryKeySchemaProperty = realmProperty;
                Pair pair = (Pair)targetCompanion2.getIo_realm_kotlin_fields().get(primaryKeySchemaProperty.getName());
                if (pair == null) {
                    throw new SerializationException("Cannot serialize class without primary key: '" + targetCompanion2.getIo_realm_kotlin_className() + '\'');
                }
                KProperty1 primaryKeyAccessor = (KProperty1)pair.component2();
                BsonValue primaryKey = this.storageTypeToBsonValue(CollectionType.RLM_COLLECTION_TYPE_NONE, primaryKeySchemaProperty.getType().getStorageType(), primaryKeyAccessor.get((Object)target));
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"$ref", (Object)new BsonString(targetCompanion2.getIo_realm_kotlin_className())), TuplesKt.to((Object)"$id", (Object)primaryKey)};
                bsonValue = (BsonValue)new BsonDocument(pairArray);
                break;
            }
            case 12: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)realmAny.asList();
                boolean $i$f$map = false;
                Iterable primaryKeySchemaProperty = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RealmAny realmAny3 = (RealmAny)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.realmAnyToBsonValue((RealmAny)it));
                }
                List list = (List)destination$iv$iv;
                bsonValue = (BsonValue)new BsonArray(list);
                break;
            }
            case 13: {
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv = (Map)realmAny.asDictionary();
                boolean $i$f$mapValues = false;
                Map $this$mapTo$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map2 = map;
                    boolean bl2 = false;
                    RealmAny v = (RealmAny)entry2.getValue();
                    BsonValue bsonValue2 = this.realmAnyToBsonValue(v);
                    map2.put(k, bsonValue2);
                }
                Map map = destination$iv$iv;
                bsonValue = (BsonValue)new BsonDocument(map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bsonValue;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object bsonValueToStorageType$io_realm_kotlin_library(@NotNull CollectionType collectionType, @NotNull RealmStorageType elementType, @NotNull KClass<?> kClass, @Nullable BsonValue bsonValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)collectionType, (String)"collectionType");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        if (bsonValue == null || Intrinsics.areEqual((Object)bsonValue, (Object)BsonNull.INSTANCE)) {
            return null;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[collectionType.ordinal()]) {
            case 1: {
                switch (WhenMappings.$EnumSwitchMapping$0[elementType.ordinal()]) {
                    case 1: {
                        object = bsonValue.asBoolean().getValue();
                        break block0;
                    }
                    case 2: {
                        KClass<?> kClass2 = kClass;
                        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                            object = (byte)bsonValue.asNumber().longValue();
                            break block0;
                        }
                        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
                            object = Character.valueOf((char)bsonValue.asNumber().intValue());
                            break block0;
                        }
                        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                            object = (short)bsonValue.asNumber().intValue();
                            break block0;
                        }
                        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            object = bsonValue.asNumber().intValue();
                            break block0;
                        }
                        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            object = bsonValue.asNumber().longValue();
                            break block0;
                        }
                        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(MutableRealmInt.class))) {
                            object = MutableRealmInt.Companion.create(bsonValue.asNumber().longValue());
                            break block0;
                        }
                        Validation.INSTANCE.sdkError("Unexpected KClass ('" + kClass.getSimpleName() + "') for element with storage type '" + elementType + '\'');
                        throw new KotlinNothingValueException();
                    }
                    case 3: {
                        object = bsonValue.asString().getValue();
                        break block0;
                    }
                    case 4: {
                        object = bsonValue.asBinary().getData();
                        break block0;
                    }
                    case 5: {
                        RealmObjectCompanion realmObjectCompanion = RealmObjectKt.realmObjectCompanionOrNull(kClass);
                        if (realmObjectCompanion == null) {
                            Validation.INSTANCE.sdkError("Unexpected kClass ('" + new PropertyReference0Impl(kClass){

                                public Object get() {
                                    return ((KClass)this.receiver).getSimpleName();
                                }
                            } + "') without realm companion");
                            throw new KotlinNothingValueException();
                        }
                        RealmObjectCompanion targetCompanion2 = realmObjectCompanion;
                        RealmProperty primaryKeySchemaProperty = targetCompanion2.io_realm_kotlin_schema().getPrimaryKey();
                        if (primaryKeySchemaProperty == null) {
                            object = this.bsonToObject(targetCompanion2, bsonValue.asDocument());
                            break block0;
                        }
                        Pair pair = (Pair)targetCompanion2.getIo_realm_kotlin_fields().get(primaryKeySchemaProperty.getName());
                        if (pair == null) {
                            throw new SerializationException("Target class does not have a primary key: '" + targetCompanion2.getIo_realm_kotlin_className() + '\'');
                        }
                        Pair pair2 = pair;
                        KClass targetKClass = (KClass)pair2.component1();
                        KProperty1 primaryKeyAccessor = (KProperty1)pair2.component2();
                        Object object2 = targetCompanion2.io_realm_kotlin_newInstance();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.realm.kotlin.types.BaseRealmObject");
                        BaseRealmObject targetInstance = (BaseRealmObject)object2;
                        Intrinsics.checkNotNull((Object)primaryKeyAccessor, (String)"null cannot be cast to non-null type kotlin.reflect.KMutableProperty1<io.realm.kotlin.types.BaseRealmObject, kotlin.Any?>");
                        ((KMutableProperty1)primaryKeyAccessor).set((Object)targetInstance, this.bsonValueToStorageType$io_realm_kotlin_library(CollectionType.RLM_COLLECTION_TYPE_NONE, primaryKeySchemaProperty.getType().getStorageType(), targetKClass, bsonValue));
                        object = targetInstance;
                        break block0;
                    }
                    case 6: {
                        object = Float.valueOf((float)bsonValue.asDouble().getValue());
                        break block0;
                    }
                    case 7: {
                        object = bsonValue.asDouble().getValue();
                        break block0;
                    }
                    case 8: {
                        object = bsonValue.asDecimal128();
                        break block0;
                    }
                    case 9: {
                        BsonDateTime $this$asRealmInstant$iv = bsonValue.asDateTime();
                        boolean $i$f$asRealmInstant = false;
                        object = RealmInstantImplKt.toRealmInstant-LRDsOJo((long)DurationKt.toDuration((long)$this$asRealmInstant$iv.getValue(), (DurationUnit)DurationUnit.MILLISECONDS));
                        break block0;
                    }
                    case 10: {
                        object = bsonValue.asObjectId();
                        break block0;
                    }
                    case 11: {
                        BsonBinary $this$asRealmUUID$iv = bsonValue.asBinary();
                        boolean $i$f$asRealmUUID = false;
                        object = RealmUUID.Companion.from($this$asRealmUUID$iv.getData());
                        break block0;
                    }
                    case 12: {
                        object = this.bsonValueToRealmAny(bsonValue);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)bsonValue.asArray();
                boolean $i$f$map = false;
                Iterable $this$asRealmUUID$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BsonValue targetInstance = (BsonValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.bsonValueToStorageType$io_realm_kotlin_library(CollectionType.RLM_COLLECTION_TYPE_NONE, elementType, kClass, (BsonValue)it));
                }
                object = IterableExtKt.toRealmList((Iterable)((List)destination$iv$iv));
                break;
            }
            case 4: {
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv = (Map)bsonValue.asDocument();
                boolean $i$f$mapValues = false;
                Map $this$mapTo$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map2 = map;
                    boolean bl2 = false;
                    Object object3 = this.bsonValueToStorageType$io_realm_kotlin_library(CollectionType.RLM_COLLECTION_TYPE_NONE, elementType, kClass, (BsonValue)it.getValue());
                    map2.put(k, object3);
                }
                object = IterableExtKt.toRealmDictionary((Map)destination$iv$iv);
                break;
            }
            case 3: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)bsonValue.asArray();
                boolean $i$f$map = false;
                Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    BsonValue it = (BsonValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.bsonValueToStorageType$io_realm_kotlin_library(CollectionType.RLM_COLLECTION_TYPE_NONE, elementType, kClass, it));
                }
                object = IterableExtKt.toRealmSet((Iterable)((List)destination$iv$iv));
                break;
            }
            default: {
                Validation.INSTANCE.sdkError("Unknown collection type: " + collectionType);
                throw new KotlinNothingValueException();
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final RealmAny bsonValueToRealmAny(BsonValue bsonValue) {
        RealmAny realmAny;
        BsonValue bsonValue2 = bsonValue;
        Object object = bsonValue2 != null ? bsonValue2.getBsonType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$3[object.ordinal()]) {
            case -1: 
            case 1: {
                realmAny = null;
                break;
            }
            case 2: {
                realmAny = RealmAny.Companion.create(bsonValue.asDouble().getValue());
                break;
            }
            case 3: {
                realmAny = RealmAny.Companion.create(bsonValue.asString().getValue());
                break;
            }
            case 4: {
                realmAny = RealmAny.Companion.create(bsonValue.asInt32().getValue());
                break;
            }
            case 5: {
                realmAny = RealmAny.Companion.create(bsonValue.asInt64().getValue());
                break;
            }
            case 6: {
                realmAny = RealmAny.Companion.create(bsonValue.asDecimal128());
                break;
            }
            case 7: {
                realmAny = RealmAny.Companion.create(bsonValue.asBinary().getData());
                break;
            }
            case 8: {
                realmAny = RealmAny.Companion.create(bsonValue.asObjectId());
                break;
            }
            case 9: {
                realmAny = RealmAny.Companion.create(bsonValue.asBoolean().getValue());
                break;
            }
            case 10: {
                BsonDateTime $this$asRealmInstant$iv = bsonValue.asDateTime();
                boolean $i$f$asRealmInstant = false;
                realmAny = RealmAny.Companion.create(RealmInstantImplKt.toRealmInstant-LRDsOJo((long)DurationKt.toDuration((long)$this$asRealmInstant$iv.getValue(), (DurationUnit)DurationUnit.MILLISECONDS)));
                break;
            }
            case 11: {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                BsonDocument document = bsonValue.asDocument();
                BsonValue bsonValue3 = (BsonValue)document.get((Object)"$ref");
                String type = bsonValue3 != null && (bsonValue3 = bsonValue3.asString()) != null ? bsonValue3.getValue() : null;
                RealmObjectCompanion targetCompanion2 = this.schema.get(type);
                BsonValue primaryKey = (BsonValue)document.get((Object)"$id");
                if (targetCompanion2 != null && primaryKey != null) {
                    RealmProperty realmProperty = targetCompanion2.io_realm_kotlin_schema().getPrimaryKey();
                    if (realmProperty == null) {
                        throw new SerializationException("Target class does not have a primary key: '$ref=" + type + '\'');
                    }
                    RealmProperty primaryKeySchemaProperty = realmProperty;
                    Pair pair = (Pair)targetCompanion2.getIo_realm_kotlin_fields().get(primaryKeySchemaProperty.getName());
                    if (pair == null) {
                        throw new SerializationException("Target class does not have a primary key: '$ref=" + type + '\'');
                    }
                    Pair pair2 = pair;
                    KClass primaryKeyType = (KClass)pair2.component1();
                    KProperty1 primaryKeyAccessor = (KProperty1)pair2.component2();
                    Object object2 = targetCompanion2.io_realm_kotlin_newInstance();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.realm.kotlin.types.RealmObject");
                    RealmObject instance = (RealmObject)object2;
                    Intrinsics.checkNotNull((Object)primaryKeyAccessor, (String)"null cannot be cast to non-null type kotlin.reflect.KMutableProperty1<io.realm.kotlin.types.BaseRealmObject, kotlin.Any?>");
                    ((KMutableProperty1)primaryKeyAccessor).set((Object)instance, this.bsonValueToStorageType$io_realm_kotlin_library(CollectionType.RLM_COLLECTION_TYPE_NONE, primaryKeySchemaProperty.getType().getStorageType(), primaryKeyType, primaryKey));
                    RealmAny.Companion this_$iv = RealmAny.Companion;
                    boolean $i$f$create = false;
                    realmAny = this_$iv.create(instance, Reflection.getOrCreateKotlinClass(RealmObject.class));
                    break;
                }
                Map primaryKeySchemaProperty = (Map)document;
                RealmAny.Companion companion = RealmAny.Companion;
                boolean $i$f$mapValues = false;
                void primaryKeyType = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv2;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map2 = map;
                    boolean bl2 = false;
                    BsonValue v = (BsonValue)entry2.getValue();
                    RealmAny realmAny2 = this.bsonValueToRealmAny(v);
                    map2.put(k, realmAny2);
                }
                realmAny = companion.create(IterableExtKt.toRealmDictionary((Map)destination$iv$iv2));
                break;
            }
            case 12: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable document = (Iterable)bsonValue.asArray();
                RealmAny.Companion companion = RealmAny.Companion;
                boolean $i$f$map = false;
                void targetCompanion2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BsonValue destination$iv$iv2 = (BsonValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.bsonValueToRealmAny((BsonValue)it));
                }
                realmAny = companion.create(IterableExtKt.toRealmList((Iterable)((List)destination$iv$iv)));
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                throw new SerializationException("Deserializer does not support " + bsonValue.getBsonType());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return realmAny;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[RealmStorageType.values().length];
            try {
                nArray[RealmStorageType.BOOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.BINARY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.OBJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.DECIMAL128.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.TIMESTAMP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.OBJECT_ID.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.UUID.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmStorageType.ANY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CollectionType.values().length];
            try {
                nArray[CollectionType.RLM_COLLECTION_TYPE_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CollectionType.RLM_COLLECTION_TYPE_LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CollectionType.RLM_COLLECTION_TYPE_SET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CollectionType.RLM_COLLECTION_TYPE_DICTIONARY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RealmAny.Type.values().length];
            try {
                nArray[RealmAny.Type.BOOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.BINARY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.TIMESTAMP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.DECIMAL128.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.OBJECT_ID.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.UUID.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.OBJECT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.LIST.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RealmAny.Type.DICTIONARY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[BsonType.values().length];
            try {
                nArray[BsonType.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DOUBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.INT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.INT64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DECIMAL128.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.BINARY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.OBJECT_ID.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.BOOLEAN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DATE_TIME.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DOCUMENT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.ARRAY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.TIMESTAMP.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.END_OF_DOCUMENT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.UNDEFINED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.REGULAR_EXPRESSION.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DB_POINTER.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.JAVASCRIPT.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.SYMBOL.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.JAVASCRIPT_WITH_SCOPE.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.MIN_KEY.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.MAX_KEY.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

