/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.mongodb.internal.FunctionsImpl;
import io.realm.kotlin.mongodb.internal.MongoDatabaseImpl;
import io.realm.kotlin.mongodb.internal.UserImpl;
import io.realm.kotlin.mongodb.mongo.MongoClient;
import io.realm.kotlin.mongodb.mongo.MongoDatabase;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.serialization.EJson;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lio/realm/kotlin/mongodb/internal/MongoClientImpl;", "Lio/realm/kotlin/mongodb/mongo/MongoClient;", "user", "Lio/realm/kotlin/mongodb/internal/UserImpl;", "serviceName", "", "eJson", "Lorg/mongodb/kbson/serialization/EJson;", "<init>", "(Lio/realm/kotlin/mongodb/internal/UserImpl;Ljava/lang/String;Lorg/mongodb/kbson/serialization/EJson;)V", "getUser$io_realm_kotlin_library", "()Lio/realm/kotlin/mongodb/internal/UserImpl;", "getServiceName", "()Ljava/lang/String;", "getEJson", "()Lorg/mongodb/kbson/serialization/EJson;", "functions", "Lio/realm/kotlin/mongodb/internal/FunctionsImpl;", "getFunctions", "()Lio/realm/kotlin/mongodb/internal/FunctionsImpl;", "database", "Lio/realm/kotlin/mongodb/mongo/MongoDatabase;", "databaseName", "io.realm.kotlin.library"})
@PublishedApi
public final class MongoClientImpl
implements MongoClient {
    @NotNull
    private final UserImpl user;
    @NotNull
    private final String serviceName;
    @NotNull
    private final EJson eJson;
    @NotNull
    private final FunctionsImpl functions;

    public MongoClientImpl(@NotNull UserImpl user, @NotNull String serviceName, @NotNull EJson eJson) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)eJson, (String)"eJson");
        this.user = user;
        this.serviceName = serviceName;
        this.eJson = eJson;
        this.functions = new FunctionsImpl(this.user.getApp(), this.user, this.getServiceName());
    }

    @NotNull
    public final UserImpl getUser$io_realm_kotlin_library() {
        return this.user;
    }

    @Override
    @NotNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    public final EJson getEJson() {
        return this.eJson;
    }

    @NotNull
    public final FunctionsImpl getFunctions() {
        return this.functions;
    }

    @Override
    @NotNull
    public MongoDatabase database(@NotNull String databaseName, @Nullable EJson eJson) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        EJson eJson2 = eJson;
        if (eJson2 == null) {
            eJson2 = this.eJson;
        }
        return new MongoDatabaseImpl(this, databaseName, eJson2);
    }
}

