/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.BaseRealm;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmBaseSubscriptionSet;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSubscriptionT;
import io.realm.kotlin.internal.interop.sync.CoreSubscriptionSetState;
import io.realm.kotlin.internal.query.ObjectQuery;
import io.realm.kotlin.mongodb.internal.SubscriptionImpl;
import io.realm.kotlin.mongodb.sync.BaseSubscriptionSet;
import io.realm.kotlin.mongodb.sync.Subscription;
import io.realm.kotlin.mongodb.sync.SubscriptionSetState;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.types.RealmObject;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\b \u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001(B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u0010\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\r0\fj\u0002`\u000bH$\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0004J\"\u0010\u0013\u001a\u0004\u0018\u00010\u0014\"\b\b\u0001\u0010\u0001*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140'H\u0096\u0002R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\r0\fj\u0002`\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lio/realm/kotlin/mongodb/internal/BaseSubscriptionSetImpl;", "T", "Lio/realm/kotlin/BaseRealm;", "Lio/realm/kotlin/mongodb/sync/BaseSubscriptionSet;", "realm", "<init>", "(Lio/realm/kotlin/BaseRealm;)V", "getRealm", "()Lio/realm/kotlin/BaseRealm;", "Lio/realm/kotlin/BaseRealm;", "nativePointer", "Lio/realm/kotlin/internal/interop/RealmBaseSubscriptionSetPointer;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmBaseSubscriptionSet;", "getNativePointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getIteratorSafePointer", "checkClosed", "", "findByQuery", "Lio/realm/kotlin/mongodb/sync/Subscription;", "Lio/realm/kotlin/types/RealmObject;", "query", "Lio/realm/kotlin/query/RealmQuery;", "findByName", "name", "", "state", "Lio/realm/kotlin/mongodb/sync/SubscriptionSetState;", "getState", "()Lio/realm/kotlin/mongodb/sync/SubscriptionSetState;", "errorMessage", "getErrorMessage", "()Ljava/lang/String;", "size", "", "getSize", "()I", "iterator", "", "Companion", "io.realm.kotlin.library"})
public abstract class BaseSubscriptionSetImpl<T extends BaseRealm>
implements BaseSubscriptionSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T realm;

    public BaseSubscriptionSetImpl(@NotNull T realm) {
        Intrinsics.checkNotNullParameter(realm, (String)"realm");
        this.realm = realm;
    }

    @NotNull
    protected final T getRealm() {
        return this.realm;
    }

    @NotNull
    protected abstract NativePointer<? extends RealmBaseSubscriptionSet> getNativePointer();

    @NotNull
    protected abstract NativePointer<? extends RealmBaseSubscriptionSet> getIteratorSafePointer();

    protected final void checkClosed() {
        T t = this.realm;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type io.realm.kotlin.internal.BaseRealmImpl");
        ((BaseRealmImpl)t).getRealmReference().checkClosed();
    }

    @Override
    @Nullable
    public <T extends RealmObject> Subscription findByQuery(@NotNull RealmQuery<T> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        NativePointer queryPointer = ((ObjectQuery)query).getQueryPointer$io_realm_kotlin_library();
        NativePointer<RealmBaseSubscriptionSet> subscriptionSetPointer = this.getNativePointer();
        boolean bl = false;
        NativePointer subscriptionPointer = RealmInterop.INSTANCE.realm_sync_find_subscription_by_query(subscriptionSetPointer, queryPointer);
        return subscriptionPointer == null ? null : new SubscriptionImpl((BaseRealm)this.realm, (NativePointer<? extends RealmBaseSubscriptionSet>)subscriptionSetPointer, (NativePointer<RealmSubscriptionT>)subscriptionPointer);
    }

    @Override
    @Nullable
    public Subscription findByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NativePointer sub = RealmInterop.INSTANCE.realm_sync_find_subscription_by_name(this.getNativePointer(), name);
        return sub == null ? null : (Subscription)new SubscriptionImpl((BaseRealm)this.realm, (NativePointer<? extends RealmBaseSubscriptionSet>)this.getNativePointer(), (NativePointer<RealmSubscriptionT>)sub);
    }

    @Override
    @NotNull
    public SubscriptionSetState getState() {
        CoreSubscriptionSetState state = RealmInterop.INSTANCE.realm_sync_subscriptionset_state(this.getNativePointer());
        return Companion.stateFrom$io_realm_kotlin_library(state);
    }

    @Override
    @Nullable
    public String getErrorMessage() {
        return RealmInterop.INSTANCE.realm_sync_subscriptionset_error_str(this.getNativePointer());
    }

    @Override
    public int getSize() {
        return (int)RealmInterop.INSTANCE.realm_sync_subscriptionset_size(this.getNativePointer());
    }

    @Override
    @NotNull
    public Iterator<Subscription> iterator() {
        NativePointer<RealmBaseSubscriptionSet> iteratorPointer = this.getIteratorSafePointer();
        return new Iterator<Subscription>(iteratorPointer, this){
            private final NativePointer<? extends RealmBaseSubscriptionSet> nativePointer;
            private long cursor;
            private final long size;
            final /* synthetic */ BaseSubscriptionSetImpl<T> this$0;
            {
                this.this$0 = $receiver;
                this.nativePointer = $iteratorPointer;
                this.size = RealmInterop.INSTANCE.realm_sync_subscriptionset_size(this.nativePointer);
            }

            public boolean hasNext() {
                return this.cursor < this.size;
            }

            public Subscription next() {
                if (this.cursor >= this.size) {
                    throw new NoSuchElementException("Iterator has no more elements. Tried index " + this.cursor + ". Size is " + this.size + '.');
                }
                NativePointer ptr = RealmInterop.INSTANCE.realm_sync_subscription_at(this.nativePointer, this.cursor);
                long l = this.cursor;
                this.cursor = l + 1L;
                return new SubscriptionImpl((BaseRealm)this.this$0.getRealm(), this.nativePointer, (NativePointer<RealmSubscriptionT>)ptr);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/mongodb/internal/BaseSubscriptionSetImpl$Companion;", "", "<init>", "()V", "stateFrom", "Lio/realm/kotlin/mongodb/sync/SubscriptionSetState;", "coreState", "Lio/realm/kotlin/internal/interop/sync/CoreSubscriptionSetState;", "stateFrom$io_realm_kotlin_library", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SubscriptionSetState stateFrom$io_realm_kotlin_library(@NotNull CoreSubscriptionSetState coreState) {
            SubscriptionSetState subscriptionSetState;
            Intrinsics.checkNotNullParameter((Object)coreState, (String)"coreState");
            switch (WhenMappings.$EnumSwitchMapping$0[coreState.ordinal()]) {
                case 1: {
                    subscriptionSetState = SubscriptionSetState.UNCOMMITTED;
                    break;
                }
                case 2: {
                    subscriptionSetState = SubscriptionSetState.PENDING;
                    break;
                }
                case 3: {
                    subscriptionSetState = SubscriptionSetState.BOOTSTRAPPING;
                    break;
                }
                case 4: {
                    subscriptionSetState = SubscriptionSetState.COMPLETE;
                    break;
                }
                case 5: {
                    subscriptionSetState = SubscriptionSetState.ERROR;
                    break;
                }
                case 6: {
                    subscriptionSetState = SubscriptionSetState.SUPERSEDED;
                    break;
                }
                case 7: {
                    subscriptionSetState = SubscriptionSetState.AWAITING_MARK;
                    break;
                }
                default: {
                    String string = "Unsupported state: " + coreState;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
            return subscriptionSetState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CoreSubscriptionSetState.values().length];
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_UNCOMMITTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_PENDING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_BOOTSTRAPPING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_COMPLETE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_SUPERSEDED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreSubscriptionSetState.RLM_SYNC_SUBSCRIPTION_AWAITING_MARK.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

