/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb;

import io.ktor.client.plugins.logging.Logger;
import io.realm.kotlin.annotations.ExperimentalRealmSerializerApi;
import io.realm.kotlin.internal.ContextLogger;
import io.realm.kotlin.internal.interop.sync.MetadataMode;
import io.realm.kotlin.internal.interop.sync.NetworkTransport;
import io.realm.kotlin.internal.interop.sync.WebSocketTransport;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.internal.util.CoroutineDispatcherFactory;
import io.realm.kotlin.internal.util.DispatcherHolder;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.mongodb.HttpLogObfuscator;
import io.realm.kotlin.mongodb.internal.AppConfigurationImpl;
import io.realm.kotlin.mongodb.internal.KtorNetworkTransport;
import io.realm.kotlin.mongodb.internal.LogObfuscatorImpl;
import io.realm.kotlin.mongodb.internal.RealmWebSocketTransport;
import io.realm.kotlin.mongodb.sync.SyncTimeoutOptions;
import io.realm.kotlin.mongodb.sync.SyncTimeoutOptionsBuilder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.serialization.EJson;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 .2\u00020\u0001:\u0002./R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u001e\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0005R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0005R\u0018\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u0004\u0018\u00010#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0012\u0010*\u001a\u00020+X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration;", "", "appId", "", "getAppId", "()Ljava/lang/String;", "baseUrl", "getBaseUrl", "encryptionKey", "", "getEncryptionKey", "()[B", "metadataMode", "Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "getMetadataMode", "()Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "syncRootDirectory", "getSyncRootDirectory", "authorizationHeaderName", "getAuthorizationHeaderName", "customRequestHeaders", "", "getCustomRequestHeaders", "()Ljava/util/Map;", "appName", "getAppName", "appVersion", "getAppVersion", "ejson", "Lorg/mongodb/kbson/serialization/EJson;", "getEjson$annotations", "()V", "getEjson", "()Lorg/mongodb/kbson/serialization/EJson;", "httpLogObfuscator", "Lio/realm/kotlin/mongodb/HttpLogObfuscator;", "getHttpLogObfuscator", "()Lio/realm/kotlin/mongodb/HttpLogObfuscator;", "enableSessionMultiplexing", "", "getEnableSessionMultiplexing", "()Z", "syncTimeoutOptions", "Lio/realm/kotlin/mongodb/sync/SyncTimeoutOptions;", "getSyncTimeoutOptions", "()Lio/realm/kotlin/mongodb/sync/SyncTimeoutOptions;", "Companion", "Builder", "io.realm.kotlin.library"})
public interface AppConfiguration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.AppConfiguration$Companion.$$INSTANCE;
    @NotNull
    public static final String DEFAULT_BASE_URL = "https://services.cloud.mongodb.com";
    @NotNull
    public static final String DEFAULT_AUTHORIZATION_HEADER_NAME = "Authorization";

    @NotNull
    public String getAppId();

    @NotNull
    public String getBaseUrl();

    @Nullable
    public byte[] getEncryptionKey();

    @NotNull
    public MetadataMode getMetadataMode();

    @NotNull
    public String getSyncRootDirectory();

    @NotNull
    public String getAuthorizationHeaderName();

    @NotNull
    public Map<String, String> getCustomRequestHeaders();

    @Nullable
    public String getAppName();

    @Nullable
    public String getAppVersion();

    @NotNull
    public EJson getEjson();

    @Nullable
    public HttpLogObfuscator getHttpLogObfuscator();

    public boolean getEnableSessionMultiplexing();

    @NotNull
    public SyncTimeoutOptions getSyncTimeoutOptions();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0003J+\u0010\u0018\u001a\u00020\u00002#\u0010#\u001a\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019\u0012\u0004\u0012\u00020%0$\u00a2\u0006\u0002\b&J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001cJ\u001f\u0010(\u001a\u00020\u00002\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020%0$\u00a2\u0006\u0002\b&J\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020\u001cJ\u0017\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b,J\u0006\u0010-\u001a\u00020.J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration$Builder;", "", "appId", "", "<init>", "(Ljava/lang/String;)V", "baseUrl", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "encryptionKey", "", "syncRootDirectory", "networkTransport", "Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "websocketTransport", "Lio/realm/kotlin/internal/interop/sync/WebSocketTransport;", "appName", "appVersion", "ejson", "Lorg/mongodb/kbson/serialization/EJson;", "getEjson$annotations", "()V", "httpLogObfuscator", "Lio/realm/kotlin/mongodb/HttpLogObfuscator;", "customRequestHeaders", "", "authorizationHeaderName", "enableSessionMultiplexing", "", "syncTimeoutOptions", "Lio/realm/kotlin/mongodb/sync/SyncTimeoutOptions;", "usePlatformNetworking", "key", "rootDir", "name", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "enabled", "syncTimeouts", "action", "Lio/realm/kotlin/mongodb/sync/SyncTimeoutOptionsBuilder;", "enable", "networkTransport$io_realm_kotlin_library", "build", "Lio/realm/kotlin/mongodb/AppConfiguration;", "bundleId", "io.realm.kotlin.library"})
    @SourceDebugExtension(value={"SMAP\nAppConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppConfiguration.kt\nio/realm/kotlin/mongodb/AppConfiguration$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n1#2:455\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String appId;
        @NotNull
        private String baseUrl;
        @Nullable
        private CoroutineDispatcher dispatcher;
        @Nullable
        private byte[] encryptionKey;
        @NotNull
        private String syncRootDirectory;
        @Nullable
        private NetworkTransport networkTransport;
        @Nullable
        private WebSocketTransport websocketTransport;
        @Nullable
        private String appName;
        @Nullable
        private String appVersion;
        @NotNull
        private EJson ejson;
        @Nullable
        private HttpLogObfuscator httpLogObfuscator;
        @NotNull
        private final Map<String, String> customRequestHeaders;
        @NotNull
        private String authorizationHeaderName;
        private boolean enableSessionMultiplexing;
        @NotNull
        private SyncTimeoutOptions syncTimeoutOptions;
        private boolean usePlatformNetworking;

        public Builder(@NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            this.appId = appId;
            this.baseUrl = AppConfiguration.DEFAULT_BASE_URL;
            this.syncRootDirectory = SystemUtilsJvmKt.appFilesDirectory();
            this.ejson = (EJson)EJson.Default;
            this.httpLogObfuscator = LogObfuscatorImpl.INSTANCE;
            this.customRequestHeaders = new LinkedHashMap();
            this.authorizationHeaderName = AppConfiguration.DEFAULT_AUTHORIZATION_HEADER_NAME;
            this.syncTimeoutOptions = new SyncTimeoutOptionsBuilder().build$io_realm_kotlin_library();
        }

        private static /* synthetic */ void getEjson$annotations() {
        }

        @NotNull
        public final Builder encryptionKey(@NotNull byte[] key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$encryptionKey_u24lambda_u240 = builder = this;
            boolean bl = false;
            if (key.length != 64) {
                throw new IllegalArgumentException("The provided key must be 64 bytes. Yours was: " + key.length + '.');
            }
            byte[] byArray = Arrays.copyOf(key, key.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            $this$encryptionKey_u24lambda_u240.encryptionKey = byArray;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u241.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Builder $this$dispatcher_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$dispatcher_u24lambda_u242.dispatcher = dispatcher;
            return builder;
        }

        @NotNull
        public final Builder syncRootDirectory(@NotNull String rootDir) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Builder $this$syncRootDirectory_u24lambda_u243 = builder = this;
            boolean bl = false;
            boolean directoryExists = SystemUtilsKt.directoryExists((String)rootDir);
            if (!directoryExists && SystemUtilsKt.fileExists((String)rootDir)) {
                throw new IllegalArgumentException("'rootDir' is a file, not a directory: " + rootDir + '.');
            }
            if (!directoryExists) {
                SystemUtilsKt.prepareRealmDirectoryPath((String)rootDir);
            }
            if (!SystemUtilsKt.canWrite((String)rootDir)) {
                throw new IllegalArgumentException("Realm directory is not writable: " + rootDir + '.');
            }
            $this$syncRootDirectory_u24lambda_u243.syncRootDirectory = rootDir;
            return builder;
        }

        @NotNull
        public final Builder appName(@NotNull String appName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
            Builder $this$appName_u24lambda_u244 = builder = this;
            boolean bl = false;
            Validation.INSTANCE.checkEmpty(appName, "appName");
            $this$appName_u24lambda_u244.appName = appName;
            return builder;
        }

        @NotNull
        public final Builder appVersion(@NotNull String appVersion) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
            Builder $this$appVersion_u24lambda_u245 = builder = this;
            boolean bl = false;
            Validation.INSTANCE.checkEmpty(appVersion, "appVersion");
            $this$appVersion_u24lambda_u245.appVersion = appVersion;
            return builder;
        }

        @NotNull
        public final Builder httpLogObfuscator(@Nullable HttpLogObfuscator httpLogObfuscator) {
            Builder builder;
            Builder $this$httpLogObfuscator_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$httpLogObfuscator_u24lambda_u246.httpLogObfuscator = httpLogObfuscator;
            return builder;
        }

        @NotNull
        public final Builder authorizationHeaderName(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$authorizationHeaderName_u24lambda_u248 = builder = this;
            boolean bl = false;
            if (!(((CharSequence)name).length() > 0)) {
                boolean bl2 = false;
                String string = "Non-empty 'name' required.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$authorizationHeaderName_u24lambda_u248.authorizationHeaderName = name;
            return builder;
        }

        @NotNull
        public final Builder customRequestHeaders(@NotNull Function1<? super Map<String, String>, Unit> block) {
            Builder builder;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder $this$customRequestHeaders_u24lambda_u2410 = builder = this;
            boolean bl = false;
            block.invoke($this$customRequestHeaders_u24lambda_u2410.customRequestHeaders);
            if (!(!$this$customRequestHeaders_u24lambda_u2410.customRequestHeaders.containsKey(""))) {
                boolean bl2 = false;
                String string = "Non-empty custom header name required.";
                throw new IllegalArgumentException(string.toString());
            }
            return builder;
        }

        @ExperimentalRealmSerializerApi
        @NotNull
        public final Builder ejson(@NotNull EJson ejson) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)ejson, (String)"ejson");
            Builder $this$ejson_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$ejson_u24lambda_u2411.ejson = ejson;
            return builder;
        }

        @NotNull
        public final Builder enableSessionMultiplexing(boolean enabled) {
            this.enableSessionMultiplexing = enabled;
            return this;
        }

        @NotNull
        public final Builder syncTimeouts(@NotNull Function1<? super SyncTimeoutOptionsBuilder, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            SyncTimeoutOptionsBuilder builder = new SyncTimeoutOptionsBuilder();
            action.invoke((Object)builder);
            this.syncTimeoutOptions = builder.build$io_realm_kotlin_library();
            return this;
        }

        @NotNull
        public final Builder usePlatformNetworking(boolean enable2) {
            Builder builder;
            Builder $this$usePlatformNetworking_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$usePlatformNetworking_u24lambda_u2412.usePlatformNetworking = enable2;
            return builder;
        }

        public static /* synthetic */ Builder usePlatformNetworking$default(Builder builder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return builder.usePlatformNetworking(bl);
        }

        @NotNull
        public final Builder networkTransport$io_realm_kotlin_library(@Nullable NetworkTransport networkTransport2) {
            Builder builder;
            Builder $this$networkTransport_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$networkTransport_u24lambda_u2413.networkTransport = networkTransport2;
            return builder;
        }

        @NotNull
        public final AppConfiguration build() {
            return this.build("UNKNOWN_BUNDLE_ID");
        }

        @NotNull
        public final AppConfiguration build(@NotNull String bundleId) {
            WebSocketTransport webSocketTransport;
            CoroutineDispatcherFactory coroutineDispatcherFactory;
            Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
            if (this.dispatcher != null) {
                CoroutineDispatcher coroutineDispatcher = this.dispatcher;
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default((CoroutineDispatcherFactory.Companion)CoroutineDispatcherFactory.Companion, (String)("app-dispatcher-" + this.appId), (int)0, (int)2, null);
            }
            CoroutineDispatcherFactory appNetworkDispatcherFactory = coroutineDispatcherFactory;
            ContextLogger appLogger = new ContextLogger(null, 1, null);
            Function1 networkTransport2 = arg_0 -> Builder.build$lambda$14(this, appLogger, arg_0);
            if (this.usePlatformNetworking) {
                webSocketTransport = this.websocketTransport;
                if (webSocketTransport == null) {
                    webSocketTransport = new RealmWebSocketTransport(60000L);
                }
            } else {
                webSocketTransport = null;
            }
            WebSocketTransport websocketTransport = webSocketTransport;
            String string = this.appId;
            String string2 = this.baseUrl;
            byte[] byArray = this.encryptionKey;
            MetadataMode metadataMode = this.encryptionKey == null ? MetadataMode.RLM_SYNC_CLIENT_METADATA_MODE_PLAINTEXT : MetadataMode.RLM_SYNC_CLIENT_METADATA_MODE_ENCRYPTED;
            String string3 = this.syncRootDirectory;
            String string4 = this.appName;
            String string5 = this.appVersion;
            EJson eJson = this.ejson;
            HttpLogObfuscator httpLogObfuscator = this.httpLogObfuscator;
            Map<String, String> map = this.customRequestHeaders;
            String string6 = this.authorizationHeaderName;
            boolean bl = this.enableSessionMultiplexing;
            SyncTimeoutOptions syncTimeoutOptions = this.syncTimeoutOptions;
            return new AppConfigurationImpl(string, string2, byArray, appNetworkDispatcherFactory, (Function1<? super DispatcherHolder, ? extends NetworkTransport>)networkTransport2, websocketTransport, metadataMode, string3, string4, string5, bundleId, eJson, httpLogObfuscator, map, string6, bl, syncTimeoutOptions, appLogger);
        }

        private static final NetworkTransport build$lambda$14(Builder this$0, ContextLogger $appLogger, DispatcherHolder dispatcherHolder) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$appLogger, (String)"$appLogger");
            Intrinsics.checkNotNullParameter((Object)dispatcherHolder, (String)"dispatcherHolder");
            Logger logger2 = new Logger(this$0, $appLogger){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ ContextLogger $appLogger;
                {
                    this.this$0 = $receiver;
                    this.$appLogger = $appLogger;
                }

                public void log(String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    HttpLogObfuscator httpLogObfuscator = Builder.access$getHttpLogObfuscator$p(this.this$0);
                    String obfuscatedMessage = httpLogObfuscator != null ? httpLogObfuscator.obfuscate(message) : null;
                    String string = obfuscatedMessage;
                    if (string == null) {
                        string = message;
                    }
                    this.$appLogger.debug(string, new Object[0]);
                }
            };
            NetworkTransport networkTransport2 = this$0.networkTransport;
            if (networkTransport2 == null) {
                Map<String, String> map = this$0.customRequestHeaders;
                String string = this$0.authorizationHeaderName;
                networkTransport2 = new KtorNetworkTransport(string, map, 120000L, dispatcherHolder, logger2);
            }
            return networkTransport2;
        }

        public static final /* synthetic */ HttpLogObfuscator access$getHttpLogObfuscator$p(Builder $this) {
            return $this.httpLogObfuscator;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration$Companion;", "", "<init>", "()V", "DEFAULT_BASE_URL", "", "DEFAULT_AUTHORIZATION_HEADER_NAME", "create", "Lio/realm/kotlin/mongodb/AppConfiguration;", "appId", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String DEFAULT_BASE_URL = "https://services.cloud.mongodb.com";
        @NotNull
        public static final String DEFAULT_AUTHORIZATION_HEADER_NAME = "Authorization";

        private Companion() {
        }

        @NotNull
        public final AppConfiguration create(@NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            return new Builder(appId).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ void getEjson$annotations() {
        }
    }
}

