/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.interop.AppCallback;
import io.realm.kotlin.internal.interop.CodeDescription;
import io.realm.kotlin.internal.interop.ErrorCategory;
import io.realm.kotlin.internal.interop.ErrorCode;
import io.realm.kotlin.internal.interop.sync.AppError;
import io.realm.kotlin.internal.interop.sync.ProtocolConnectionErrorCode;
import io.realm.kotlin.internal.interop.sync.ProtocolSessionErrorCode;
import io.realm.kotlin.internal.interop.sync.SyncError;
import io.realm.kotlin.internal.interop.sync.SyncErrorCode;
import io.realm.kotlin.internal.interop.sync.SyncErrorCodeCategory;
import io.realm.kotlin.mongodb.exceptions.AppException;
import io.realm.kotlin.mongodb.exceptions.AuthException;
import io.realm.kotlin.mongodb.exceptions.BadFlexibleSyncQueryException;
import io.realm.kotlin.mongodb.exceptions.BadRequestException;
import io.realm.kotlin.mongodb.exceptions.CompensatingWriteException;
import io.realm.kotlin.mongodb.exceptions.ConnectionException;
import io.realm.kotlin.mongodb.exceptions.CredentialsCannotBeLinkedException;
import io.realm.kotlin.mongodb.exceptions.FunctionExecutionException;
import io.realm.kotlin.mongodb.exceptions.InvalidCredentialsException;
import io.realm.kotlin.mongodb.exceptions.ServiceException;
import io.realm.kotlin.mongodb.exceptions.SyncException;
import io.realm.kotlin.mongodb.exceptions.UnrecoverableSyncException;
import io.realm.kotlin.mongodb.exceptions.UserAlreadyConfirmedException;
import io.realm.kotlin.mongodb.exceptions.UserAlreadyExistsException;
import io.realm.kotlin.mongodb.exceptions.UserNotFoundException;
import io.realm.kotlin.mongodb.exceptions.WrongSyncTypeException;
import io.realm.kotlin.serializers.MutableRealmIntKSerializer;
import io.realm.kotlin.serializers.RealmAnyKSerializer;
import io.realm.kotlin.serializers.RealmInstantKSerializer;
import io.realm.kotlin.serializers.RealmUUIDKSerializer;
import io.realm.kotlin.types.MutableRealmInt;
import io.realm.kotlin.types.RealmAny;
import io.realm.kotlin.types.RealmInstant;
import io.realm.kotlin.types.RealmUUID;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aE\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\bH\u0001\u00f8\u0001\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0000\u001a\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0017\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0018H\u0081\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"channelResultCallback", "Lio/realm/kotlin/internal/interop/AppCallback;", "T", "R", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lkotlin/Result;", "success", "Lkotlin/Function1;", "convertAppError", "", "appError", "Lio/realm/kotlin/internal/interop/sync/AppError;", "convertSyncError", "Lio/realm/kotlin/mongodb/exceptions/SyncException;", "syncError", "Lio/realm/kotlin/internal/interop/sync/SyncError;", "createMessageFromAppError", "", "error", "createMessageFromSyncError", "Lio/realm/kotlin/internal/interop/sync/SyncErrorCode;", "serializerOrRealmBuiltInSerializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/modules/SerializersModule;", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmSyncUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmSyncUtils.kt\nio/realm/kotlin/mongodb/internal/RealmSyncUtilsKt\n+ 2 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 3 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,419:1\n32#2:420\n80#3:421\n*S KotlinDebug\n*F\n+ 1 RealmSyncUtils.kt\nio/realm/kotlin/mongodb/internal/RealmSyncUtilsKt\n*L\n417#1:420\n417#1:421\n*E\n"})
public final class RealmSyncUtilsKt {
    @PublishedApi
    @NotNull
    public static final <T, R> AppCallback<T> channelResultCallback(@NotNull Channel<Result<R>> channel, @NotNull Function1<? super T, ? extends R> success) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter(success, (String)"success");
        return new AppCallback<T>(channel, success){
            final /* synthetic */ Channel<Result<R>> $channel;
            final /* synthetic */ Function1<T, R> $success;
            {
                this.$channel = $channel;
                this.$success = $success;
            }

            public void onSuccess(T result2) {
                block3: {
                    try {
                        Object sendResult = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)this.$success.invoke(result2))));
                        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
                            Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)sendResult);
                            Intrinsics.checkNotNull((Object)throwable);
                            throw throwable;
                        }
                    }
                    catch (Throwable ex) {
                        Object it = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex))));
                        boolean bl = false;
                        if (ChannelResult.isSuccess-impl((Object)it)) break block3;
                        Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)it);
                        Intrinsics.checkNotNull((Object)throwable);
                        throw throwable;
                    }
                }
            }

            public void onError(@NotNull AppError error) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    try {
                        Object sendResult = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)RealmSyncUtilsKt.convertAppError(error)))));
                        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
                            Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)sendResult);
                            Intrinsics.checkNotNull((Object)throwable);
                            throw throwable;
                        }
                    }
                    catch (Throwable ex) {
                        Object it = this.$channel.trySend-JP2dKIU((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex))));
                        boolean bl = false;
                        if (ChannelResult.isSuccess-impl((Object)it)) break block3;
                        Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)it);
                        Intrinsics.checkNotNull((Object)throwable);
                        throw throwable;
                    }
                }
            }
        };
    }

    @NotNull
    public static final SyncException convertSyncError(@NotNull SyncError syncError) {
        CodeDescription codeDescription;
        CodeDescription codeDescription2;
        Intrinsics.checkNotNullParameter((Object)syncError, (String)"syncError");
        SyncErrorCode errorCode = syncError.getErrorCode();
        String message = RealmSyncUtilsKt.createMessageFromSyncError(errorCode);
        CodeDescription codeDescription3 = errorCode.getCategory();
        SyncException syncException = codeDescription3 == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_CLIENT ? new SyncException(message) : (codeDescription3 == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_CONNECTION ? (((((((((((codeDescription2 = errorCode.getCode()) == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_UNKNOWN_MESSAGE ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BAD_SYNTAX) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_WRONG_PROTOCOL_VERSION) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BAD_SESSION_IDENT) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_REUSE_OF_SESSION_IDENT) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BOUND_IN_OTHER_SESSION) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BAD_MESSAGE_ORDER) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BAD_DECOMPRESSION) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BAD_CHANGESET_HEADER_SYNTAX) ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_BAD_CHANGESET_SIZE) ? (SyncException)new UnrecoverableSyncException(message) : ((codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_SWITCH_TO_FLX_SYNC ? true : codeDescription2 == ProtocolConnectionErrorCode.RLM_SYNC_ERR_CONNECTION_SWITCH_TO_PBS) ? (SyncException)new WrongSyncTypeException(message) : new SyncException(message))) : (codeDescription3 == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_SESSION ? ((codeDescription = errorCode.getCode()) == ProtocolSessionErrorCode.RLM_SYNC_ERR_SESSION_BAD_QUERY ? (SyncException)new BadFlexibleSyncQueryException(message) : (codeDescription == ProtocolSessionErrorCode.RLM_SYNC_ERR_SESSION_PERMISSION_DENIED ? (SyncException)new UnrecoverableSyncException(message) : (codeDescription == ProtocolSessionErrorCode.RLM_SYNC_ERR_SESSION_COMPENSATING_WRITE ? (SyncException)new CompensatingWriteException(message, syncError.getCompensatingWrites()) : new SyncException(message)))) : ((codeDescription3 == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_SYSTEM ? true : codeDescription3 == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_UNKNOWN) ? new SyncException(message) : new SyncException(message))));
        return syncException;
    }

    @NotNull
    public static final Throwable convertAppError(@NotNull AppError appError) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)appError, (String)"appError");
        String msg = RealmSyncUtilsKt.createMessageFromAppError(appError);
        if (appError.contains(ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR)) {
            throwable = (Throwable)((Object)new ConnectionException(msg));
        } else if (appError.contains(ErrorCategory.RLM_ERR_CAT_HTTP_ERROR)) {
            ServiceException serviceException;
            int statusCode = appError.getCode().getNativeValue();
            int n = statusCode;
            boolean bl = 300 <= n ? n < 400 : false;
            if (bl) {
                serviceException = new ConnectionException(msg);
            } else if (n == 401) {
                serviceException = new InvalidCredentialsException(msg);
            } else {
                boolean bl2;
                switch (n) {
                    case 408: 
                    case 429: {
                        bl2 = true;
                        break;
                    }
                    default: {
                        if (500 <= n) {
                            if (n < 600) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        bl2 = false;
                    }
                }
                serviceException = bl2 ? (ServiceException)new ConnectionException(msg) : new ServiceException(msg, null, 2, null);
            }
            throwable = (Throwable)((Object)serviceException);
        } else {
            CodeDescription codeDescription;
            CodeDescription codeDescription2;
            throwable = appError.contains(ErrorCategory.RLM_ERR_CAT_JSON_ERROR) ? (Throwable)((Object)new ConnectionException(msg)) : (appError.contains(ErrorCategory.RLM_ERR_CAT_CLIENT_ERROR) ? (Throwable)((codeDescription2 = appError.getCode()) == ErrorCode.RLM_ERR_CLIENT_USER_NOT_FOUND ? (RuntimeException)new IllegalStateException(msg) : (codeDescription2 == ErrorCode.RLM_ERR_CLIENT_USER_NOT_LOGGED_IN ? (RuntimeException)((Object)new InvalidCredentialsException(msg)) : (codeDescription2 == ErrorCode.RLM_ERR_CLIENT_APP_DEALLOCATED ? (RuntimeException)((Object)new AppException(msg)) : (RuntimeException)((Object)new AppException(msg))))) : (appError.contains(ErrorCategory.RLM_ERR_CAT_SERVICE_ERROR) ? (Throwable)((Object)((codeDescription = appError.getCode()) == ErrorCode.RLM_ERR_INTERNAL_SERVER_ERROR ? (StringsKt.contains$default((CharSequence)msg, (CharSequence)"linking an anonymous identity is not allowed", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)msg, (CharSequence)"linking a local-userpass identity is not allowed", (boolean)false, (int)2, null) ? (ServiceException)new CredentialsCannotBeLinkedException(msg) : new ServiceException(msg, null, 2, null)) : (codeDescription == ErrorCode.RLM_ERR_INVALID_SESSION ? (ServiceException)new CredentialsCannotBeLinkedException(msg) : ((codeDescription == ErrorCode.RLM_ERR_USER_DISABLED ? true : codeDescription == ErrorCode.RLM_ERR_AUTH_ERROR) ? (ServiceException)(StringsKt.contains$default((CharSequence)msg, (CharSequence)"invalid API key", (boolean)false, (int)2, null) ? (AuthException)new InvalidCredentialsException(msg) : (StringsKt.contains$default((CharSequence)msg, (CharSequence)"invalid custom auth token:", (boolean)false, (int)2, null) ? (AuthException)new InvalidCredentialsException(msg) : new AuthException(msg))) : (codeDescription == ErrorCode.RLM_ERR_USER_NOT_FOUND ? (ServiceException)new UserNotFoundException(msg) : (codeDescription == ErrorCode.RLM_ERR_ACCOUNT_NAME_IN_USE ? (ServiceException)new UserAlreadyExistsException(msg) : (codeDescription == ErrorCode.RLM_ERR_USER_ALREADY_CONFIRMED ? (ServiceException)new UserAlreadyConfirmedException(msg) : (codeDescription == ErrorCode.RLM_ERR_INVALID_PASSWORD ? (ServiceException)new InvalidCredentialsException(msg) : (codeDescription == ErrorCode.RLM_ERR_BAD_REQUEST ? (ServiceException)new BadRequestException(msg) : (((codeDescription == ErrorCode.RLM_ERR_FUNCTION_NOT_FOUND ? true : codeDescription == ErrorCode.RLM_ERR_EXECUTION_TIME_LIMIT_EXCEEDED) ? true : codeDescription == ErrorCode.RLM_ERR_FUNCTION_EXECUTION_ERROR) ? (ServiceException)new FunctionExecutionException(msg) : new ServiceException(msg, appError.getCode()))))))))))) : (Throwable)((Object)new AppException(msg))));
        }
        return throwable;
    }

    @NotNull
    public static final String createMessageFromSyncError(@NotNull SyncErrorCode error) {
        String errorCodeDesc;
        String string;
        String categoryDesc;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        String string2 = error.getCategory().getDescription();
        if (string2 == null) {
            string2 = categoryDesc = String.valueOf(error.getCategory().getNativeValue());
        }
        if ((string = error.getCode().getDescription()) == null) {
            CodeDescription codeDescription = error.getCategory();
            string = (codeDescription == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_SYSTEM ? true : codeDescription == SyncErrorCodeCategory.RLM_SYNC_ERROR_CATEGORY_UNKNOWN) ? null : "Unknown";
        }
        String errorDesc = (errorCodeDesc = string) == null ? String.valueOf(error.getCode().getNativeValue()) : errorCodeDesc + '(' + error.getCode().getNativeValue() + ')';
        String message = error.getMessage();
        boolean bl = false;
        String msg = ' ' + message + (!StringsKt.endsWith$default((String)message, (String)".", (boolean)false, (int)2, null) ? "." : "");
        return '[' + categoryDesc + "][" + errorDesc + ']' + msg;
    }

    private static final String createMessageFromAppError(AppError error) {
        String string;
        String msg;
        String errorCodeDesc;
        String categoryDesc;
        block67: {
            block66: {
                block65: {
                    String string2;
                    block64: {
                        String string3;
                        ErrorCategory errorCategory = error.contains(ErrorCategory.RLM_ERR_CAT_CLIENT_ERROR) ? ErrorCategory.RLM_ERR_CAT_CLIENT_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_JSON_ERROR) ? ErrorCategory.RLM_ERR_CAT_JSON_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_SERVICE_ERROR) ? ErrorCategory.RLM_ERR_CAT_SERVICE_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_HTTP_ERROR) ? ErrorCategory.RLM_ERR_CAT_HTTP_ERROR : (error.contains(ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR) ? ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR : null))));
                        categoryDesc = errorCategory != null && (string3 = errorCategory.getDescription()) != null ? string3 : String.valueOf(error.getCategoryFlags());
                        String string4 = error.getCode().getDescription();
                        if (string4 == null) {
                            if (error.contains(ErrorCategory.RLM_ERR_CAT_HTTP_ERROR)) {
                                switch (error.getCode().getNativeValue()) {
                                    case 300: {
                                        string4 = "MultipleChoices";
                                        break;
                                    }
                                    case 301: {
                                        string4 = "MovedPermanently";
                                        break;
                                    }
                                    case 302: {
                                        string4 = "Found";
                                        break;
                                    }
                                    case 303: {
                                        string4 = "SeeOther";
                                        break;
                                    }
                                    case 304: {
                                        string4 = "NotModified";
                                        break;
                                    }
                                    case 305: {
                                        string4 = "UseProxy";
                                        break;
                                    }
                                    case 307: {
                                        string4 = "TemporaryRedirect";
                                        break;
                                    }
                                    case 308: {
                                        string4 = "PermanentRedirect";
                                        break;
                                    }
                                    case 400: {
                                        string4 = "BadRequest";
                                        break;
                                    }
                                    case 401: {
                                        string4 = "Unauthorized";
                                        break;
                                    }
                                    case 402: {
                                        string4 = "PaymentRequired";
                                        break;
                                    }
                                    case 403: {
                                        string4 = "Forbidden";
                                        break;
                                    }
                                    case 404: {
                                        string4 = "NotFound";
                                        break;
                                    }
                                    case 405: {
                                        string4 = "MethodNotAllowed";
                                        break;
                                    }
                                    case 406: {
                                        string4 = "NotAcceptable";
                                        break;
                                    }
                                    case 407: {
                                        string4 = "ProxyAuthenticationRequired";
                                        break;
                                    }
                                    case 408: {
                                        string4 = "RequestTimeout";
                                        break;
                                    }
                                    case 409: {
                                        string4 = "Conflict";
                                        break;
                                    }
                                    case 410: {
                                        string4 = "Gone";
                                        break;
                                    }
                                    case 411: {
                                        string4 = "LengthRequired";
                                        break;
                                    }
                                    case 412: {
                                        string4 = "PreconditionFailed";
                                        break;
                                    }
                                    case 413: {
                                        string4 = "ContentTooLarge";
                                        break;
                                    }
                                    case 414: {
                                        string4 = "UriTooLong";
                                        break;
                                    }
                                    case 415: {
                                        string4 = "UnsupportedMediaType";
                                        break;
                                    }
                                    case 416: {
                                        string4 = "RangeNotSatisfiable";
                                        break;
                                    }
                                    case 417: {
                                        string4 = "ExpectationFailed";
                                        break;
                                    }
                                    case 421: {
                                        string4 = "MisdirectedRequest";
                                        break;
                                    }
                                    case 422: {
                                        string4 = "UnprocessableContent";
                                        break;
                                    }
                                    case 423: {
                                        string4 = "Locked";
                                        break;
                                    }
                                    case 424: {
                                        string4 = "FailedDependency";
                                        break;
                                    }
                                    case 425: {
                                        string4 = "TooEarly";
                                        break;
                                    }
                                    case 426: {
                                        string4 = "UpgradeRequired";
                                        break;
                                    }
                                    case 428: {
                                        string4 = "PreconditionRequired";
                                        break;
                                    }
                                    case 429: {
                                        string4 = "TooManyRequests";
                                        break;
                                    }
                                    case 431: {
                                        string4 = "RequestHeaderFieldsTooLarge";
                                        break;
                                    }
                                    case 451: {
                                        string4 = "UnavailableForLegalReasons";
                                        break;
                                    }
                                    case 500: {
                                        string4 = "InternalServerError";
                                        break;
                                    }
                                    case 501: {
                                        string4 = "NotImplemented";
                                        break;
                                    }
                                    case 502: {
                                        string4 = "BadGateway";
                                        break;
                                    }
                                    case 503: {
                                        string4 = "ServiceUnavailable";
                                        break;
                                    }
                                    case 504: {
                                        string4 = "GatewayTimeout";
                                        break;
                                    }
                                    case 505: {
                                        string4 = "HttpVersionNotSupported";
                                        break;
                                    }
                                    case 506: {
                                        string4 = "VariantAlsoNegotiates";
                                        break;
                                    }
                                    case 507: {
                                        string4 = "InsufficientStorage";
                                        break;
                                    }
                                    case 508: {
                                        string4 = "LoopDetected";
                                        break;
                                    }
                                    case 510: {
                                        string4 = "NotExtended";
                                        break;
                                    }
                                    case 511: {
                                        string4 = "NetworkAuthenticationRequired";
                                        break;
                                    }
                                    default: {
                                        string4 = "Unknown";
                                        break;
                                    }
                                }
                            } else if (error.contains(ErrorCategory.RLM_ERR_CAT_CUSTOM_ERROR)) {
                                switch (error.getCode().getNativeValue()) {
                                    case 1000: {
                                        string4 = "IO";
                                        break;
                                    }
                                    case 1001: {
                                        string4 = "Interrupted";
                                        break;
                                    }
                                    default: {
                                        string4 = "Unknown";
                                        break;
                                    }
                                }
                            } else {
                                string4 = errorCodeDesc = "Unknown";
                            }
                        }
                        if ((string2 = error.getMessage()) == null) break block64;
                        String message = string2;
                        boolean bl = false;
                        String string5 = StringsKt.endsWith$default((String)message, (String)".", (boolean)false, (int)2, null) ? message : ' ' + message + '.';
                        string2 = string5;
                        if (string5 != null) break block65;
                    }
                    string2 = msg = "";
                }
                if ((string = error.getLinkToServerLog()) == null) break block66;
                String link = string;
                boolean bl = false;
                String string6 = " Server log entry: " + link;
                string = string6;
                if (string6 != null) break block67;
            }
            string = "";
        }
        String serverLogsLink = string;
        String errorDesc = errorCodeDesc + '(' + error.getCode().getNativeValue() + ')';
        return '[' + categoryDesc + "][" + errorDesc + ']' + msg + serverLogsLink;
    }

    @PublishedApi
    public static final /* synthetic */ <T> KSerializer<T> serializerOrRealmBuiltInSerializer(SerializersModule $this$serializerOrRealmBuiltInSerializer) {
        KSerializer kSerializer;
        Intrinsics.checkNotNullParameter((Object)$this$serializerOrRealmBuiltInSerializer, (String)"<this>");
        boolean $i$f$serializerOrRealmBuiltInSerializer = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MutableRealmInt.class))) {
            kSerializer = (KSerializer)MutableRealmIntKSerializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmUUID.class))) {
            kSerializer = (KSerializer)RealmUUIDKSerializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmInstant.class))) {
            kSerializer = (KSerializer)RealmInstantKSerializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmAny.class))) {
            kSerializer = (KSerializer)RealmAnyKSerializer.INSTANCE;
        } else {
            SerializersModule $this$serializer$iv = $this$serializerOrRealmBuiltInSerializer;
            boolean $i$f$serializer = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            KSerializer $this$cast$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv, null);
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            kSerializer = $this$cast$iv$iv;
        }
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of io.realm.kotlin.mongodb.internal.RealmSyncUtilsKt.serializerOrRealmBuiltInSerializer>");
        return kSerializer;
    }
}

