/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.BaseRealm;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmBaseSubscriptionSet;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmMutableSubscriptionSetT;
import io.realm.kotlin.internal.interop.RealmSubscriptionT;
import io.realm.kotlin.internal.platform.RealmObjectKt;
import io.realm.kotlin.internal.query.ObjectQuery;
import io.realm.kotlin.mongodb.internal.BaseSubscriptionSetImpl;
import io.realm.kotlin.mongodb.internal.SubscriptionImpl;
import io.realm.kotlin.mongodb.sync.MutableSubscriptionSet;
import io.realm.kotlin.mongodb.sync.Subscription;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.types.RealmObject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0002\u0010\nJ2\u0010\r\u001a\u00020\u000e\"\b\b\u0001\u0010\u0001*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00170\u0007j\u0002`\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J \u0010\u001b\u001a\u00020\u0015\"\b\b\u0001\u0010\u0001*\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00010\u001eH\u0016R\u001e\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lio/realm/kotlin/mongodb/internal/MutableSubscriptionSetImpl;", "T", "Lio/realm/kotlin/BaseRealm;", "Lio/realm/kotlin/mongodb/internal/BaseSubscriptionSetImpl;", "Lio/realm/kotlin/mongodb/sync/MutableSubscriptionSet;", "realm", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmMutableSubscriptionSetT;", "Lio/realm/kotlin/internal/interop/RealmMutableSubscriptionSetPointer;", "(Lio/realm/kotlin/BaseRealm;Lio/realm/kotlin/internal/interop/NativePointer;)V", "getNativePointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "add", "Lio/realm/kotlin/mongodb/sync/Subscription;", "Lio/realm/kotlin/types/RealmObject;", "query", "Lio/realm/kotlin/query/RealmQuery;", "name", "", "updateExisting", "", "getIteratorSafePointer", "Lio/realm/kotlin/internal/interop/RealmBaseSubscriptionSet;", "Lio/realm/kotlin/internal/interop/RealmBaseSubscriptionSetPointer;", "remove", "subscription", "removeAll", "objectType", "type", "Lkotlin/reflect/KClass;", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nMutableSubscriptionSetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableSubscriptionSetImpl.kt\nio/realm/kotlin/mongodb/internal/MutableSubscriptionSetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1855#2,2:110\n1855#2,2:112\n*S KotlinDebug\n*F\n+ 1 MutableSubscriptionSetImpl.kt\nio/realm/kotlin/mongodb/internal/MutableSubscriptionSetImpl\n*L\n82#1:110,2\n97#1:112,2\n*E\n"})
public final class MutableSubscriptionSetImpl<T extends BaseRealm>
extends BaseSubscriptionSetImpl<T>
implements MutableSubscriptionSet {
    @NotNull
    private final NativePointer<RealmMutableSubscriptionSetT> nativePointer;

    public MutableSubscriptionSetImpl(@NotNull T realm, @NotNull NativePointer<RealmMutableSubscriptionSetT> nativePointer) {
        Intrinsics.checkNotNullParameter(realm, (String)"realm");
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        super(realm);
        this.nativePointer = nativePointer;
    }

    @Override
    @NotNull
    protected NativePointer<RealmMutableSubscriptionSetT> getNativePointer() {
        return this.nativePointer;
    }

    @Override
    @NotNull
    protected NativePointer<? extends RealmBaseSubscriptionSet> getIteratorSafePointer() {
        return this.getNativePointer();
    }

    @Override
    @NotNull
    public <T extends RealmObject> Subscription add(@NotNull RealmQuery<T> query, @Nullable String name, boolean updateExisting) {
        Subscription existingSub;
        Intrinsics.checkNotNullParameter(query, (String)"query");
        String string = name;
        Subscription subscription = existingSub = string != null ? this.findByName(string) : this.findByQuery(query);
        if (subscription != null) {
            Subscription it = subscription;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)name, (Object)existingSub.getName()) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)query.description())).toString(), (Object)((Object)StringsKt.trim((CharSequence)existingSub.getQueryDescription())).toString())) {
                return existingSub;
            }
        }
        Pair pair = RealmInterop.INSTANCE.realm_sync_subscriptionset_insert_or_assign(this.getNativePointer(), ((ObjectQuery)query).getQueryPointer$io_realm_kotlin_library(), name);
        NativePointer ptr = (NativePointer)pair.component1();
        boolean inserted = (Boolean)pair.component2();
        if (!updateExisting && !inserted) {
            throw new IllegalStateException("Existing query '" + name + "' was found and could not be updated as `updateExisting = false`");
        }
        return new SubscriptionImpl((BaseRealm)this.getRealm(), (NativePointer<? extends RealmBaseSubscriptionSet>)this.getNativePointer(), (NativePointer<RealmSubscriptionT>)ptr);
    }

    @Override
    public boolean remove(@NotNull Subscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        return RealmInterop.INSTANCE.realm_sync_subscriptionset_erase_by_id(this.getNativePointer(), ((SubscriptionImpl)subscription).getNativePointer$io_realm_kotlin_library());
    }

    @Override
    public boolean remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RealmInterop.INSTANCE.realm_sync_subscriptionset_erase_by_name(this.getNativePointer(), name);
    }

    @Override
    public boolean removeAll(@NotNull String objectType) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        if (this.getRealm().schema().get(objectType) == null) {
            throw new IllegalArgumentException('\'' + objectType + "' is not part of the schema for this Realm: " + this.getRealm().getConfiguration().getPath());
        }
        boolean result2 = false;
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Subscription sub = (Subscription)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)sub.getObjectType(), (Object)objectType)) continue;
            result2 = this.remove(sub) || result2;
        }
        return result2;
    }

    @Override
    public <T extends RealmObject> boolean removeAll(@NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        boolean result2 = false;
        String objectType = RealmObjectKt.realmObjectCompanionOrThrow(type).getIo_realm_kotlin_className();
        if (this.getRealm().schema().get(objectType) == null) {
            throw new IllegalArgumentException("" + '\'' + type + "' is not part of the schema for this Realm: " + this.getRealm().getConfiguration().getPath());
        }
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Subscription sub = (Subscription)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)sub.getObjectType(), (Object)objectType)) continue;
            result2 = this.remove(sub) || result2;
        }
        return result2;
    }

    @Override
    public boolean removeAll() {
        return RealmInterop.INSTANCE.realm_sync_subscriptionset_clear(this.getNativePointer());
    }

    @Override
    @NotNull
    public Subscription subscribe(@NotNull RealmQuery<? extends RealmObject> $this$subscribe) {
        return MutableSubscriptionSet.DefaultImpls.subscribe(this, $this$subscribe);
    }

    @Override
    @NotNull
    public Subscription subscribe(@NotNull RealmQuery<? extends RealmObject> $this$subscribe, @NotNull String name, boolean updateExisting) {
        return MutableSubscriptionSet.DefaultImpls.subscribe(this, $this$subscribe, name, updateExisting);
    }
}

