/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.exceptions;

import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmAppT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.sync.SyncError;
import io.realm.kotlin.mongodb.internal.RealmSyncUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/mongodb/exceptions/ClientResetRequiredException;", "", "appPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmAppT;", "Lio/realm/kotlin/internal/interop/RealmAppPointer;", "error", "Lio/realm/kotlin/internal/interop/sync/SyncError;", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/interop/sync/SyncError;)V", "originalFilePath", "", "getOriginalFilePath", "()Ljava/lang/String;", "recoveryFilePath", "getRecoveryFilePath", "executeClientReset", "", "io.realm.kotlin.library"})
public final class ClientResetRequiredException
extends Throwable {
    @NotNull
    private final NativePointer<RealmAppT> appPointer;
    @NotNull
    private final String originalFilePath;
    @NotNull
    private final String recoveryFilePath;

    public ClientResetRequiredException(@NotNull NativePointer<RealmAppT> appPointer, @NotNull SyncError error) {
        Intrinsics.checkNotNullParameter(appPointer, (String)"appPointer");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super(RealmSyncUtilsKt.createMessageFromSyncError(error.getErrorCode()));
        this.appPointer = appPointer;
        String string = error.getOriginalFilePath();
        Intrinsics.checkNotNull((Object)string);
        this.originalFilePath = string;
        String string2 = error.getRecoveryFilePath();
        Intrinsics.checkNotNull((Object)string2);
        this.recoveryFilePath = string2;
    }

    @NotNull
    public final String getOriginalFilePath() {
        return this.originalFilePath;
    }

    @NotNull
    public final String getRecoveryFilePath() {
        return this.recoveryFilePath;
    }

    public final void executeClientReset() {
        RealmInterop.INSTANCE.realm_sync_immediately_run_file_actions(this.appPointer, this.originalFilePath);
    }
}

