/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmAppT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSyncConfigT;
import io.realm.kotlin.internal.interop.sync.SyncError;
import io.realm.kotlin.internal.interop.sync.SyncSessionResyncMode;
import io.realm.kotlin.mongodb.exceptions.ClientResetRequiredException;
import io.realm.kotlin.mongodb.internal.ClientResetStrategyHelper;
import io.realm.kotlin.mongodb.sync.ManuallyRecoverUnsyncedChangesStrategy;
import io.realm.kotlin.mongodb.sync.SyncSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0016J*\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00110\nj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/realm/kotlin/mongodb/internal/ManuallyRecoverUnsyncedChangesHelper;", "Lio/realm/kotlin/mongodb/internal/ClientResetStrategyHelper;", "strategy", "Lio/realm/kotlin/mongodb/sync/ManuallyRecoverUnsyncedChangesStrategy;", "(Lio/realm/kotlin/mongodb/sync/ManuallyRecoverUnsyncedChangesStrategy;)V", "getStrategy", "()Lio/realm/kotlin/mongodb/sync/ManuallyRecoverUnsyncedChangesStrategy;", "initialize", "", "nativeSyncConfig", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSyncConfigT;", "Lio/realm/kotlin/internal/interop/RealmSyncConfigurationPointer;", "onSyncError", "session", "Lio/realm/kotlin/mongodb/sync/SyncSession;", "appPointer", "Lio/realm/kotlin/internal/interop/RealmAppT;", "Lio/realm/kotlin/internal/interop/RealmAppPointer;", "error", "Lio/realm/kotlin/internal/interop/sync/SyncError;", "io.realm.kotlin.library"})
final class ManuallyRecoverUnsyncedChangesHelper
implements ClientResetStrategyHelper {
    @NotNull
    private final ManuallyRecoverUnsyncedChangesStrategy strategy;

    public ManuallyRecoverUnsyncedChangesHelper(@NotNull ManuallyRecoverUnsyncedChangesStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.strategy = strategy;
    }

    @NotNull
    public final ManuallyRecoverUnsyncedChangesStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void initialize(@NotNull NativePointer<RealmSyncConfigT> nativeSyncConfig) {
        Intrinsics.checkNotNullParameter(nativeSyncConfig, (String)"nativeSyncConfig");
        RealmInterop.INSTANCE.realm_sync_config_set_resync_mode(nativeSyncConfig, SyncSessionResyncMode.RLM_SYNC_SESSION_RESYNC_MODE_MANUAL);
    }

    @Override
    public void onSyncError(@NotNull SyncSession session2, @NotNull NativePointer<RealmAppT> appPointer, @NotNull SyncError error) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(appPointer, (String)"appPointer");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.strategy.onClientReset(session2, new ClientResetRequiredException(appPointer, error));
    }
}

