/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmCredentialsT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.mongodb.AuthenticationProvider;
import io.realm.kotlin.mongodb.Credentials;
import io.realm.kotlin.mongodb.GoogleAuthType;
import io.realm.kotlin.mongodb.internal.AuthenticationProviderImpl;
import io.realm.kotlin.mongodb.internal.BsonEncoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.Bson;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/mongodb/internal/CredentialsImpl;", "Lio/realm/kotlin/mongodb/Credentials;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmCredentialsT;", "Lio/realm/kotlin/internal/interop/RealmCredentialsPointer;", "(Lio/realm/kotlin/internal/interop/NativePointer;)V", "authenticationProvider", "Lio/realm/kotlin/mongodb/AuthenticationProvider;", "getAuthenticationProvider", "()Lio/realm/kotlin/mongodb/AuthenticationProvider;", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "asJson", "", "asJson$io_realm_kotlin_library", "Companion", "io.realm.kotlin.library"})
public final class CredentialsImpl
implements Credentials {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativePointer<RealmCredentialsT> nativePointer;
    @NotNull
    private final AuthenticationProvider authenticationProvider;

    public CredentialsImpl(@NotNull NativePointer<RealmCredentialsT> nativePointer) {
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        this.nativePointer = nativePointer;
        this.authenticationProvider = AuthenticationProviderImpl.Companion.fromId$io_realm_kotlin_library(RealmInterop.INSTANCE.realm_auth_credentials_get_provider(this.nativePointer));
    }

    @NotNull
    public final NativePointer<RealmCredentialsT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @Override
    @NotNull
    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    @NotNull
    public final String asJson$io_realm_kotlin_library() {
        return RealmInterop.INSTANCE.realm_app_credentials_serialize_as_json(this.nativePointer);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001f\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u001f\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u000f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u0013J'\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0017J\u001f\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0019\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001aJ'\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u001f\u0010 \u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010!\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\"\u00a8\u0006#"}, d2={"Lio/realm/kotlin/mongodb/internal/CredentialsImpl$Companion;", "", "()V", "anonymous", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmCredentialsT;", "Lio/realm/kotlin/internal/interop/RealmCredentialsPointer;", "reuseExisting", "", "anonymous$io_realm_kotlin_library", "apiKey", "key", "", "apiKey$io_realm_kotlin_library", "apple", "idToken", "apple$io_realm_kotlin_library", "customFunction", "payload", "customFunction$io_realm_kotlin_library", "emailPassword", "email", "password", "emailPassword$io_realm_kotlin_library", "facebook", "accessToken", "facebook$io_realm_kotlin_library", "google", "token", "type", "Lio/realm/kotlin/mongodb/GoogleAuthType;", "google$io_realm_kotlin_library", "jwt", "jwtToken", "jwt$io_realm_kotlin_library", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> anonymous$io_realm_kotlin_library(boolean reuseExisting) {
            return RealmInterop.INSTANCE.realm_app_credentials_new_anonymous(reuseExisting);
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> emailPassword$io_realm_kotlin_library(@NotNull String email, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return RealmInterop.INSTANCE.realm_app_credentials_new_email_password(Validation.INSTANCE.checkEmpty(email, "email"), Validation.INSTANCE.checkEmpty(password, "password"));
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> apiKey$io_realm_kotlin_library(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return RealmInterop.INSTANCE.realm_app_credentials_new_api_key(Validation.INSTANCE.checkEmpty(key, "key"));
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> apple$io_realm_kotlin_library(@NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            return RealmInterop.INSTANCE.realm_app_credentials_new_apple(Validation.INSTANCE.checkEmpty(idToken, "idToken"));
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> facebook$io_realm_kotlin_library(@NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return RealmInterop.INSTANCE.realm_app_credentials_new_facebook(Validation.INSTANCE.checkEmpty(accessToken, "accessToken"));
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> google$io_realm_kotlin_library(@NotNull String token, @NotNull GoogleAuthType type) {
            NativePointer nativePointer;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Validation.INSTANCE.checkEmpty(token, "token");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    nativePointer = RealmInterop.INSTANCE.realm_app_credentials_new_google_auth_code(token);
                    break;
                }
                case 2: {
                    nativePointer = RealmInterop.INSTANCE.realm_app_credentials_new_google_id_token(token);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return nativePointer;
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> jwt$io_realm_kotlin_library(@NotNull String jwtToken) {
            Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
            return RealmInterop.INSTANCE.realm_app_credentials_new_jwt(Validation.INSTANCE.checkEmpty(jwtToken, "jwtToken"));
        }

        @NotNull
        public final NativePointer<RealmCredentialsT> customFunction$io_realm_kotlin_library(@NotNull Object payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            BsonValue bsonValue = BsonEncoder.INSTANCE.encodeToBsonValue(payload);
            boolean bl = false;
            if (!(bsonValue.getBsonType() == BsonType.DOCUMENT)) {
                boolean bl2 = false;
                String string = "Invalid payload type '" + Reflection.getOrCreateKotlinClass(payload.getClass()).getSimpleName() + "', only BsonDocument and maps are supported.";
                throw new IllegalArgumentException(string.toString());
            }
            return RealmInterop.INSTANCE.realm_app_credentials_new_custom_function(Bson.INSTANCE.toJson(bsonValue));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GoogleAuthType.values().length];
                try {
                    nArray[GoogleAuthType.AUTH_CODE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GoogleAuthType.ID_TOKEN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

