/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.RealmLog;
import io.realm.kotlin.internal.interop.CoreLogLevel;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmAppConfigT;
import io.realm.kotlin.internal.interop.RealmAppT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSyncClientConfigT;
import io.realm.kotlin.internal.interop.SyncConnectionParams;
import io.realm.kotlin.internal.interop.SyncLogCallback;
import io.realm.kotlin.internal.interop.sync.MetadataMode;
import io.realm.kotlin.internal.interop.sync.NetworkTransport;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.mongodb.AppConfiguration;
import io.realm.kotlin.mongodb.internal.AppConfigurationImpl;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010 \u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020#0\"j\u0002`$0!J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J.\u0010+\u001a\f\u0012\u0004\u0012\u00020,0\"j\u0002`-2\b\u0010.\u001a\u0004\u0018\u00010\u00032\b\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u00100\u001a\u00020\tH\u0002J&\u00101\u001a\f\u0012\u0004\u0012\u0002020\"j\u0002`32\b\u00104\u001a\u0004\u0018\u00010\u00032\b\u00105\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013\u00a8\u00066"}, d2={"Lio/realm/kotlin/mongodb/internal/AppConfigurationImpl;", "Lio/realm/kotlin/mongodb/AppConfiguration;", "appId", "", "baseUrl", "encryptionKey", "", "networkTransportFactory", "Lkotlin/Function0;", "Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "metadataMode", "Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "syncRootDirectory", "log", "Lio/realm/kotlin/internal/RealmLog;", "appName", "appVersion", "(Ljava/lang/String;Ljava/lang/String;[BLkotlin/jvm/functions/Function0;Lio/realm/kotlin/internal/interop/sync/MetadataMode;Ljava/lang/String;Lio/realm/kotlin/internal/RealmLog;Ljava/lang/String;Ljava/lang/String;)V", "getAppId", "()Ljava/lang/String;", "getAppName", "getAppVersion", "getBaseUrl", "getEncryptionKey", "()[B", "getLog", "()Lio/realm/kotlin/internal/RealmLog;", "getMetadataMode", "()Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "getNetworkTransportFactory$io_realm_kotlin_library", "()Lkotlin/jvm/functions/Function0;", "getSyncRootDirectory", "createNativeApp", "Lkotlin/Pair;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmAppT;", "Lio/realm/kotlin/internal/interop/RealmAppPointer;", "equals", "", "other", "", "hashCode", "", "initializeRealmAppConfig", "Lio/realm/kotlin/internal/interop/RealmAppConfigT;", "Lio/realm/kotlin/internal/interop/RealmAppConfigurationPointer;", "localAppName", "localAppVersion", "networkTransport", "initializeSyncClientConfig", "Lio/realm/kotlin/internal/interop/RealmSyncClientConfigT;", "Lio/realm/kotlin/internal/interop/RealmSyncClientConfigurationPointer;", "sdkInfo", "applicationInfo", "io.realm.kotlin.library"})
public final class AppConfigurationImpl
implements AppConfiguration {
    @NotNull
    private final String appId;
    @NotNull
    private final String baseUrl;
    @Nullable
    private final byte[] encryptionKey;
    @NotNull
    private final Function0<NetworkTransport> networkTransportFactory;
    @NotNull
    private final MetadataMode metadataMode;
    @NotNull
    private final String syncRootDirectory;
    @NotNull
    private final RealmLog log;
    @Nullable
    private final String appName;
    @Nullable
    private final String appVersion;

    public AppConfigurationImpl(@NotNull String appId, @NotNull String baseUrl, @Nullable byte[] encryptionKey, @NotNull Function0<? extends NetworkTransport> networkTransportFactory, @NotNull MetadataMode metadataMode, @NotNull String syncRootDirectory, @NotNull RealmLog log, @Nullable String appName, @Nullable String appVersion) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(networkTransportFactory, (String)"networkTransportFactory");
        Intrinsics.checkNotNullParameter((Object)metadataMode, (String)"metadataMode");
        Intrinsics.checkNotNullParameter((Object)syncRootDirectory, (String)"syncRootDirectory");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.appId = appId;
        this.baseUrl = baseUrl;
        this.encryptionKey = encryptionKey;
        this.networkTransportFactory = networkTransportFactory;
        this.metadataMode = metadataMode;
        this.syncRootDirectory = syncRootDirectory;
        this.log = log;
        this.appName = appName;
        this.appVersion = appVersion;
    }

    public /* synthetic */ AppConfigurationImpl(String string, String string2, byte[] byArray, Function0 function0, MetadataMode metadataMode, String string3, RealmLog realmLog, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "https://realm.mongodb.com";
        }
        this(string, string2, byArray, (Function0<? extends NetworkTransport>)function0, metadataMode, string3, realmLog, string4, string5);
    }

    @Override
    @NotNull
    public String getAppId() {
        return this.appId;
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nullable
    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    @NotNull
    public final Function0<NetworkTransport> getNetworkTransportFactory$io_realm_kotlin_library() {
        return this.networkTransportFactory;
    }

    @Override
    @NotNull
    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    @Override
    @NotNull
    public String getSyncRootDirectory() {
        return this.syncRootDirectory;
    }

    @NotNull
    public final RealmLog getLog() {
        return this.log;
    }

    @Override
    @Nullable
    public String getAppName() {
        return this.appName;
    }

    @Override
    @Nullable
    public String getAppVersion() {
        return this.appVersion;
    }

    @NotNull
    public final Pair<NetworkTransport, NativePointer<RealmAppT>> createNativeApp() {
        String applicationInfo;
        NativePointer<RealmAppConfigT> appConfigPointer;
        NetworkTransport networkTransport2;
        block4: {
            StringBuilder info;
            block8: {
                CharSequence charSequence;
                block7: {
                    String it;
                    block6: {
                        CharSequence charSequence2;
                        block5: {
                            networkTransport2 = (NetworkTransport)this.networkTransportFactory.invoke();
                            appConfigPointer = this.initializeRealmAppConfig(this.getAppName(), this.getAppVersion(), networkTransport2);
                            applicationInfo = null;
                            if (this.getAppName() == null && this.getAppVersion() != null) break block4;
                            info = new StringBuilder();
                            charSequence2 = this.getAppName();
                            if (charSequence2 == null) break block5;
                            it = charSequence2;
                            boolean bl = false;
                            StringBuilder stringBuilder = info.append(this.getAppName());
                            charSequence2 = stringBuilder;
                            if (stringBuilder != null) break block6;
                        }
                        charSequence2 = info.append("Unknown");
                    }
                    info.append("/");
                    charSequence = this.getAppVersion();
                    if (charSequence == null) break block7;
                    it = charSequence;
                    boolean bl = false;
                    StringBuilder stringBuilder = info.append(this.getAppVersion());
                    charSequence = stringBuilder;
                    if (stringBuilder != null) break block8;
                }
                charSequence = info.append("Unknown");
            }
            applicationInfo = info.toString();
        }
        String sdkInfo = "RealmKotlin/1.7.1";
        NativePointer<RealmSyncClientConfigT> synClientConfig = this.initializeSyncClientConfig(sdkInfo, String.valueOf(applicationInfo));
        return new Pair((Object)networkTransport2, (Object)RealmInterop.INSTANCE.realm_app_get(appConfigPointer, synClientConfig, SystemUtilsJvmKt.appFilesDirectory()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        AppConfigurationImpl cfr_ignored_0 = (AppConfigurationImpl)other;
        if (!Intrinsics.areEqual((Object)this.getAppId(), (Object)((AppConfigurationImpl)other).getAppId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBaseUrl(), (Object)((AppConfigurationImpl)other).getBaseUrl())) {
            return false;
        }
        if (this.getMetadataMode() != ((AppConfigurationImpl)other).getMetadataMode()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.log, (Object)((AppConfigurationImpl)other).log);
    }

    public int hashCode() {
        int result2 = this.getAppId().hashCode();
        result2 = 31 * result2 + this.getBaseUrl().hashCode();
        result2 = 31 * result2 + this.getMetadataMode().hashCode();
        result2 = 31 * result2 + this.log.hashCode();
        return result2;
    }

    private final NativePointer<RealmAppConfigT> initializeRealmAppConfig(String localAppName, String localAppVersion, NetworkTransport networkTransport2) {
        RealmInterop realmInterop = RealmInterop.INSTANCE;
        String string = this.getAppId();
        String string2 = this.getBaseUrl();
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_network_transport_new(networkTransport2);
        SyncConnectionParams syncConnectionParams = new SyncConnectionParams("1.7.1", localAppName, localAppVersion, SystemUtilsJvmKt.getOS_NAME(), SystemUtilsJvmKt.getOS_VERSION(), SystemUtilsJvmKt.getCPU_ARCH(), SystemUtilsJvmKt.getDEVICE_MANUFACTURER(), SystemUtilsJvmKt.getDEVICE_MODEL(), SystemUtilsJvmKt.getRUNTIME(), SystemUtilsJvmKt.getRUNTIME_VERSION());
        return realmInterop.realm_app_config_new(string, nativePointer, string2, syncConnectionParams);
    }

    private final NativePointer<RealmSyncClientConfigT> initializeSyncClientConfig(String sdkInfo, String applicationInfo) {
        NativePointer nativePointer;
        block2: {
            String it;
            NativePointer syncClientConfig = nativePointer = RealmInterop.INSTANCE.realm_sync_client_config_new();
            boolean bl = false;
            RealmInterop.INSTANCE.realm_sync_client_config_set_default_binding_thread_observer(syncClientConfig, this.getAppId());
            RealmInterop.INSTANCE.realm_sync_client_config_set_log_level(syncClientConfig, CoreLogLevel.Companion.valueFromPriority((short)this.log.getLogLevel().getPriority()));
            RealmInterop.INSTANCE.realm_sync_client_config_set_log_callback(syncClientConfig, new SyncLogCallback(this){
                final /* synthetic */ AppConfigurationImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public void log(short logLevel, @Nullable String message) {
                    CoreLogLevel coreLogLevel = CoreLogLevel.Companion.valueFromPriority(logLevel);
                    switch (initializeSyncClientConfig.1.WhenMappings.$EnumSwitchMapping$0[coreLogLevel.ordinal()]) {
                        case 1: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.trace(string, new Object[0]);
                            break;
                        }
                        case 2: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.debug(string, new Object[0]);
                            break;
                        }
                        case 3: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.debug(string, new Object[0]);
                            break;
                        }
                        case 4: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.info(string, new Object[0]);
                            break;
                        }
                        case 5: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.warn(string, new Object[0]);
                            break;
                        }
                        case 6: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.error(string, new Object[0]);
                            break;
                        }
                        case 7: {
                            RealmLog realmLog = this.this$0.getLog();
                            String string = message;
                            if (string == null) {
                                string = "";
                            }
                            realmLog.error(string, new Object[0]);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported level: " + coreLogLevel);
                        }
                    }
                }
            });
            RealmInterop.INSTANCE.realm_sync_client_config_set_metadata_mode(syncClientConfig, this.getMetadataMode());
            RealmInterop.INSTANCE.realm_sync_client_config_set_base_file_path(syncClientConfig, this.getSyncRootDirectory());
            byte[] byArray = this.getEncryptionKey();
            if (byArray != null) {
                byte[] it2 = byArray;
                boolean bl2 = false;
                RealmInterop.INSTANCE.realm_sync_client_config_set_metadata_encryption_key(syncClientConfig, it2);
            }
            String string = sdkInfo;
            if (string != null) {
                it = string;
                boolean bl3 = false;
                RealmInterop.INSTANCE.realm_sync_client_config_set_user_agent_binding_info(syncClientConfig, it);
            }
            String string2 = applicationInfo;
            if (string2 == null) break block2;
            it = string2;
            boolean bl4 = false;
            RealmInterop.INSTANCE.realm_sync_client_config_set_user_agent_application_info(syncClientConfig, it);
        }
        return nativePointer;
    }
}

