/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb;

import io.ktor.client.plugins.logging.Logger;
import io.realm.kotlin.LogConfiguration;
import io.realm.kotlin.internal.RealmLog;
import io.realm.kotlin.internal.interop.sync.MetadataMode;
import io.realm.kotlin.internal.interop.sync.NetworkTransport;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.internal.util.CoroutineDispatcherFactory;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.mongodb.internal.AppConfigurationImpl;
import io.realm.kotlin.mongodb.internal.KtorNetworkTransport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration;", "", "appId", "", "getAppId", "()Ljava/lang/String;", "appName", "getAppName", "appVersion", "getAppVersion", "baseUrl", "getBaseUrl", "encryptionKey", "", "getEncryptionKey", "()[B", "metadataMode", "Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "getMetadataMode", "()Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "syncRootDirectory", "getSyncRootDirectory", "Builder", "Companion", "io.realm.kotlin.library"})
public interface AppConfiguration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.AppConfiguration$Companion.$$INSTANCE;
    @NotNull
    public static final String DEFAULT_BASE_URL = "https://realm.mongodb.com";
    @NotNull
    public static final String DEFAULT_AUTHORIZATION_HEADER_NAME = "Authorization";

    @NotNull
    public String getAppId();

    @NotNull
    public String getBaseUrl();

    @Nullable
    public byte[] getEncryptionKey();

    @NotNull
    public MetadataMode getMetadataMode();

    @NotNull
    public String getSyncRootDirectory();

    @Nullable
    public String getAppName();

    @Nullable
    public String getAppVersion();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration$Companion;", "", "()V", "DEFAULT_AUTHORIZATION_HEADER_NAME", "", "DEFAULT_BASE_URL", "create", "Lio/realm/kotlin/mongodb/AppConfiguration;", "appId", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String DEFAULT_BASE_URL = "https://realm.mongodb.com";
        @NotNull
        public static final String DEFAULT_AUTHORIZATION_HEADER_NAME = "Authorization";

        private Companion() {
        }

        @NotNull
        public final AppConfiguration create(@NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            return new Builder(appId).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000bJ \u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\r2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0017\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u0010\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration$Builder;", "", "appId", "", "(Ljava/lang/String;)V", "appName", "appVersion", "baseUrl", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "encryptionKey", "", "logLevel", "Lio/realm/kotlin/log/LogLevel;", "networkTransport", "Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "removeSystemLogger", "", "syncRootDirectory", "userLoggers", "", "Lio/realm/kotlin/log/RealmLogger;", "build", "Lio/realm/kotlin/mongodb/AppConfiguration;", "key", "log", "level", "customLoggers", "networkTransport$io_realm_kotlin_library", "removeSystemLogger$io_realm_kotlin_library", "rootDir", "io.realm.kotlin.library"})
    public static final class Builder {
        @NotNull
        private final String appId;
        @NotNull
        private String baseUrl;
        @Nullable
        private CoroutineDispatcher dispatcher;
        @Nullable
        private byte[] encryptionKey;
        @NotNull
        private LogLevel logLevel;
        private boolean removeSystemLogger;
        @NotNull
        private String syncRootDirectory;
        @NotNull
        private List<? extends RealmLogger> userLoggers;
        @Nullable
        private NetworkTransport networkTransport;
        @Nullable
        private String appName;
        @Nullable
        private String appVersion;

        public Builder(@NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            this.appId = appId;
            this.baseUrl = AppConfiguration.DEFAULT_BASE_URL;
            this.logLevel = LogLevel.WARN;
            this.syncRootDirectory = SystemUtilsJvmKt.appFilesDirectory();
            this.userLoggers = CollectionsKt.emptyList();
        }

        @NotNull
        public final Builder encryptionKey(@NotNull byte[] key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$encryptionKey_u24lambda_u240 = builder = this;
            boolean bl = false;
            if (key.length != 64) {
                throw new IllegalArgumentException("The provided key must be 64 bytes. Yours was: " + key.length + '.');
            }
            byte[] byArray = Arrays.copyOf(key, key.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
            $this$encryptionKey_u24lambda_u240.encryptionKey = byArray;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u241.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Builder $this$dispatcher_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$dispatcher_u24lambda_u242.dispatcher = dispatcher;
            return builder;
        }

        @NotNull
        public final Builder log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            Builder $this$log_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$log_u24lambda_u243.logLevel = level;
            $this$log_u24lambda_u243.userLoggers = customLoggers;
            return builder;
        }

        public static /* synthetic */ Builder log$default(Builder builder, LogLevel logLevel, List list, int n, Object object) {
            if ((n & 1) != 0) {
                logLevel = LogLevel.WARN;
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return builder.log(logLevel, list);
        }

        @NotNull
        public final Builder syncRootDirectory(@NotNull String rootDir) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Builder $this$syncRootDirectory_u24lambda_u244 = builder = this;
            boolean bl = false;
            boolean directoryExists = SystemUtilsKt.directoryExists((String)rootDir);
            if (!directoryExists && SystemUtilsKt.fileExists((String)rootDir)) {
                throw new IllegalArgumentException("'rootDir' is a file, not a directory: " + rootDir + '.');
            }
            if (!directoryExists) {
                SystemUtilsKt.prepareRealmDirectoryPath((String)rootDir);
            }
            if (!SystemUtilsKt.canWrite((String)rootDir)) {
                throw new IllegalArgumentException("Realm directory is not writable: " + rootDir + '.');
            }
            $this$syncRootDirectory_u24lambda_u244.syncRootDirectory = rootDir;
            return builder;
        }

        @NotNull
        public final Builder appName(@NotNull String appName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
            Builder $this$appName_u24lambda_u245 = builder = this;
            boolean bl = false;
            Validation.INSTANCE.checkEmpty(appName, "appName");
            $this$appName_u24lambda_u245.appName = appName;
            return builder;
        }

        @NotNull
        public final Builder appVersion(@NotNull String appVersion) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
            Builder $this$appVersion_u24lambda_u246 = builder = this;
            boolean bl = false;
            Validation.INSTANCE.checkEmpty(appVersion, "appVersion");
            $this$appVersion_u24lambda_u246.appVersion = appVersion;
            return builder;
        }

        @NotNull
        public final Builder removeSystemLogger$io_realm_kotlin_library() {
            Builder builder;
            Builder $this$removeSystemLogger_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$removeSystemLogger_u24lambda_u247.removeSystemLogger = true;
            return builder;
        }

        @NotNull
        public final Builder networkTransport$io_realm_kotlin_library(@Nullable NetworkTransport networkTransport2) {
            Builder builder;
            Builder $this$networkTransport_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$networkTransport_u24lambda_u248.networkTransport = networkTransport2;
            return builder;
        }

        @NotNull
        public final AppConfiguration build() {
            CoroutineDispatcherFactory coroutineDispatcherFactory;
            List allLoggers = new ArrayList();
            if (!this.removeSystemLogger) {
                allLoggers.add(SystemUtilsJvmKt.createDefaultSystemLogger$default((String)"REALM", null, (int)2, null));
            }
            allLoggers.addAll((Collection)this.userLoggers);
            RealmLog appLogger = new RealmLog(null, new LogConfiguration(this.logLevel, allLoggers), 1, null);
            if (this.dispatcher != null) {
                CoroutineDispatcher coroutineDispatcher = this.dispatcher;
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default((CoroutineDispatcherFactory.Companion)CoroutineDispatcherFactory.Companion, (String)("app-dispatcher-" + this.appId), (int)0, (int)2, null);
            }
            CoroutineDispatcherFactory appNetworkDispatcherFactory = coroutineDispatcherFactory;
            Function0 networkTransport2 = (Function0)new Function0<NetworkTransport>(this, appNetworkDispatcherFactory, appLogger){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ CoroutineDispatcherFactory $appNetworkDispatcherFactory;
                final /* synthetic */ RealmLog $appLogger;
                {
                    this.this$0 = $receiver;
                    this.$appNetworkDispatcherFactory = $appNetworkDispatcherFactory;
                    this.$appLogger = $appLogger;
                    super(0);
                }

                @NotNull
                public final NetworkTransport invoke() {
                    NetworkTransport networkTransport2 = Builder.access$getNetworkTransport$p(this.this$0);
                    if (networkTransport2 == null) {
                        networkTransport2 = new KtorNetworkTransport(null, null, 15000L, this.$appNetworkDispatcherFactory, new Logger(this.$appLogger){
                            final /* synthetic */ RealmLog $appLogger;
                            {
                                this.$appLogger = $appLogger;
                            }

                            public void log(@NotNull String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                this.$appLogger.debug(message, new Object[0]);
                            }
                        }, 3, null);
                    }
                    return networkTransport2;
                }
            };
            String string = this.appId;
            String string2 = this.baseUrl;
            byte[] byArray = this.encryptionKey;
            MetadataMode metadataMode = this.encryptionKey == null ? MetadataMode.RLM_SYNC_CLIENT_METADATA_MODE_PLAINTEXT : MetadataMode.RLM_SYNC_CLIENT_METADATA_MODE_ENCRYPTED;
            String string3 = this.syncRootDirectory;
            String string4 = this.appName;
            String string5 = this.appVersion;
            return new AppConfigurationImpl(string, string2, byArray, (Function0<? extends NetworkTransport>)networkTransport2, metadataMode, string3, appLogger, string4, string5);
        }

        public static final /* synthetic */ NetworkTransport access$getNetworkTransport$p(Builder $this) {
            return $this.networkTransport;
        }
    }
}

