/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.sync;

import io.realm.kotlin.Configuration;
import io.realm.kotlin.LogConfiguration;
import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.internal.ConfigurationImpl;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.RealmLog;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmUserT;
import io.realm.kotlin.internal.interop.SchemaMode;
import io.realm.kotlin.internal.platform.CoroutineUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.mongodb.User;
import io.realm.kotlin.mongodb.exceptions.ClientResetRequiredException;
import io.realm.kotlin.mongodb.exceptions.SyncException;
import io.realm.kotlin.mongodb.internal.SyncConfigurationImpl;
import io.realm.kotlin.mongodb.internal.UserImpl;
import io.realm.kotlin.mongodb.sync.DiscardUnsyncedChangesStrategy;
import io.realm.kotlin.mongodb.sync.InitialRemoteDataConfiguration;
import io.realm.kotlin.mongodb.sync.InitialSubscriptionsCallback;
import io.realm.kotlin.mongodb.sync.InitialSubscriptionsConfiguration;
import io.realm.kotlin.mongodb.sync.ManuallyRecoverUnsyncedChangesStrategy;
import io.realm.kotlin.mongodb.sync.PartitionValue;
import io.realm.kotlin.mongodb.sync.SyncClientResetStrategy;
import io.realm.kotlin.mongodb.sync.SyncConfiguration;
import io.realm.kotlin.mongodb.sync.SyncMode;
import io.realm.kotlin.mongodb.sync.SyncSession;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.ObjectId;
import io.realm.kotlin.types.RealmUUID;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "Lio/realm/kotlin/Configuration;", "errorHandler", "Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "getErrorHandler", "()Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "initialRemoteData", "Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "getInitialRemoteData", "()Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "initialSubscriptions", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "getInitialSubscriptions", "()Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "syncClientResetStrategy", "Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "getSyncClientResetStrategy", "()Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "syncMode", "Lio/realm/kotlin/mongodb/sync/SyncMode;", "getSyncMode", "()Lio/realm/kotlin/mongodb/sync/SyncMode;", "user", "Lio/realm/kotlin/mongodb/User;", "getUser", "()Lio/realm/kotlin/mongodb/User;", "Builder", "Companion", "io.realm.kotlin.library"})
public interface SyncConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.sync.SyncConfiguration$Companion.$$INSTANCE;

    @NotNull
    public User getUser();

    @NotNull
    public SyncSession.ErrorHandler getErrorHandler();

    @NotNull
    public SyncClientResetStrategy getSyncClientResetStrategy();

    @NotNull
    public SyncMode getSyncMode();

    @Nullable
    public InitialSubscriptionsConfiguration getInitialSubscriptions();

    @Nullable
    public InitialRemoteDataConfiguration getInitialRemoteData();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\fB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\r\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u000eB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000f\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0010B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0011\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0012B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0013\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0014B/\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0015\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0016J\b\u0010&\u001a\u00020\u0002H\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010'\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u000e\u0010\"\u001a\u00020\u00002\u0006\u00102\u001a\u00020#J\u001d\u00103\u001a\u00020\u00002\b\b\u0002\u00104\u001a\u000205\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0013X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder;", "Lio/realm/kotlin/Configuration$SharedBuilder;", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "user", "Lio/realm/kotlin/mongodb/User;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "(Lio/realm/kotlin/mongodb/User;Ljava/util/Set;)V", "partitionValue", "Lio/realm/kotlin/types/ObjectId;", "(Lio/realm/kotlin/mongodb/User;Lio/realm/kotlin/types/ObjectId;Ljava/util/Set;)V", "Lio/realm/kotlin/types/RealmUUID;", "(Lio/realm/kotlin/mongodb/User;Lio/realm/kotlin/types/RealmUUID;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Integer;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Long;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/String;Ljava/util/Set;)V", "Lio/realm/kotlin/mongodb/sync/PartitionValue;", "(Lio/realm/kotlin/mongodb/User;Lio/realm/kotlin/mongodb/sync/PartitionValue;Ljava/util/Set;)V", "appLog", "Lio/realm/kotlin/internal/RealmLog;", "errorHandler", "Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "initialSubscriptions", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "syncClientResetStrategy", "Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "waitForServerChanges", "Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "build", "getAbsolutePath", "rerunOnOpen", "", "initialSubscriptionBlock", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsCallback;", "log", "level", "Lio/realm/kotlin/log/LogLevel;", "customLoggers", "", "Lio/realm/kotlin/log/RealmLogger;", "resetStrategy", "waitForInitialRemoteData", "timeout", "Lkotlin/time/Duration;", "waitForInitialRemoteData-LRDsOJo", "(J)Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder;", "io.realm.kotlin.library"})
    public static final class Builder
    extends Configuration.SharedBuilder<SyncConfiguration, Builder> {
        @NotNull
        private User user;
        @Nullable
        private PartitionValue partitionValue;
        @Nullable
        private String name;
        @Nullable
        private SyncSession.ErrorHandler errorHandler;
        @Nullable
        private SyncClientResetStrategy syncClientResetStrategy;
        @Nullable
        private InitialSubscriptionsConfiguration initialSubscriptions;
        @Nullable
        private InitialRemoteDataConfiguration waitForServerChanges;
        private RealmLog appLog;

        private Builder(User user, PartitionValue partitionValue, Set<? extends KClass<? extends BaseRealmObject>> schema) {
            super(schema);
            this.user = user;
            this.partitionValue = partitionValue;
            if (!this.user.getLoggedIn()) {
                throw new IllegalArgumentException("A valid, logged in user is required.");
            }
            User user2 = this.user;
            Intrinsics.checkNotNull((Object)user2, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
            this.appLog = ((UserImpl)user2).getApp().getConfiguration().getLog();
            RealmLog realmLog = this.appLog;
            if (realmLog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appLog");
                realmLog = null;
            }
            this.setLogLevel(realmLog.getConfiguration().getLevel());
            RealmLog realmLog2 = this.appLog;
            if (realmLog2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appLog");
                realmLog2 = null;
            }
            this.setUserLoggers(realmLog2.getConfiguration().getLoggers());
            this.setRemoveSystemLogger(true);
        }

        @Nullable
        protected String getName() {
            return this.name;
        }

        protected void setName(@Nullable String string) {
            this.name = string;
        }

        public Builder(@NotNull User user, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, (PartitionValue)null, schema);
        }

        public Builder(@NotNull User user, @Nullable ObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, new PartitionValue(partitionValue), schema);
        }

        public Builder(@NotNull User user, @Nullable RealmUUID partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, new PartitionValue(partitionValue), schema);
        }

        public Builder(@NotNull User user, @Nullable Integer partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, new PartitionValue(partitionValue), schema);
        }

        public Builder(@NotNull User user, @Nullable Long partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, new PartitionValue(partitionValue), schema);
        }

        public Builder(@NotNull User user, @Nullable String partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, new PartitionValue(partitionValue), schema);
        }

        @NotNull
        public final Builder errorHandler(@NotNull SyncSession.ErrorHandler errorHandler) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
            Builder $this$errorHandler_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$errorHandler_u24lambda_u240.errorHandler = errorHandler;
            return builder;
        }

        @NotNull
        public final Builder syncClientResetStrategy(@NotNull SyncClientResetStrategy resetStrategy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resetStrategy, (String)"resetStrategy");
            Builder $this$syncClientResetStrategy_u24lambda_u241 = builder = this;
            boolean bl = false;
            if ($this$syncClientResetStrategy_u24lambda_u241.partitionValue == null && resetStrategy instanceof DiscardUnsyncedChangesStrategy) {
                throw new IllegalArgumentException("DiscardUnsyncedChangesStrategy is not supported on Flexible Sync");
            }
            if ($this$syncClientResetStrategy_u24lambda_u241.partitionValue != null && resetStrategy instanceof ManuallyRecoverUnsyncedChangesStrategy) {
                throw new IllegalArgumentException("ManuallyRecoverUnsyncedChangesStrategy is not supported on Partition-based Sync");
            }
            $this$syncClientResetStrategy_u24lambda_u241.syncClientResetStrategy = resetStrategy;
            return builder;
        }

        @NotNull
        public Builder log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            Builder $this$log_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$log_u24lambda_u242.setLogLevel(level);
            $this$log_u24lambda_u242.setUserLoggers(customLoggers);
            $this$log_u24lambda_u242.setRemoveSystemLogger(false);
            return builder;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$name_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$name_u24lambda_u243.checkName(name);
            $this$name_u24lambda_u243.setName(name);
            return builder;
        }

        @NotNull
        public final Builder waitForInitialRemoteData-LRDsOJo(long timeout) {
            Builder builder;
            Builder $this$waitForInitialRemoteData_LRDsOJo_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$waitForInitialRemoteData_LRDsOJo_u24lambda_u244.waitForServerChanges = new InitialRemoteDataConfiguration(timeout, null);
            return builder;
        }

        public static /* synthetic */ Builder waitForInitialRemoteData-LRDsOJo$default(Builder builder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = Duration.Companion.getINFINITE-UwyO8pc();
            }
            return builder.waitForInitialRemoteData-LRDsOJo(l);
        }

        @NotNull
        public final Builder initialSubscriptions(boolean rerunOnOpen, @NotNull InitialSubscriptionsCallback initialSubscriptionBlock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)initialSubscriptionBlock, (String)"initialSubscriptionBlock");
            Builder $this$initialSubscriptions_u24lambda_u245 = builder = this;
            boolean bl = false;
            if ($this$initialSubscriptions_u24lambda_u245.partitionValue != null) {
                throw new IllegalStateException("Defining initial subscriptions is only available if the configuration is for Flexible Sync.");
            }
            $this$initialSubscriptions_u24lambda_u245.initialSubscriptions = new InitialSubscriptionsConfiguration(initialSubscriptionBlock, rerunOnOpen);
            return builder;
        }

        public static /* synthetic */ Builder initialSubscriptions$default(Builder builder, boolean bl, InitialSubscriptionsCallback initialSubscriptionsCallback, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return builder.initialSubscriptions(bl, initialSubscriptionsCallback);
        }

        @NotNull
        public SyncConfiguration build() {
            CoroutineDispatcher coroutineDispatcher;
            List allLoggers = CollectionsKt.toMutableList((Collection)this.getUserLoggers());
            if (!this.getRemoveSystemLogger()) {
                allLoggers.add(0, SystemUtilsJvmKt.createDefaultSystemLogger$default((String)"REALM", null, (int)2, null));
            }
            if (this.errorHandler == null) {
                this.errorHandler = new SyncSession.ErrorHandler(this){
                    @NotNull
                    private final Lazy fallbackErrorLogger$delegate;
                    final /* synthetic */ Builder this$0;
                    {
                        this.this$0 = $receiver;
                        this.fallbackErrorLogger$delegate = LazyKt.lazy((Function0)build.fallbackErrorLogger.2.INSTANCE);
                    }

                    private final RealmLogger getFallbackErrorLogger() {
                        Lazy lazy = this.fallbackErrorLogger$delegate;
                        return (RealmLogger)lazy.getValue();
                    }

                    public void onError(@NotNull SyncSession session2, @NotNull SyncException error) {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                            String string = error.getMessage();
                            if (string == null) break block2;
                            String string2 = string;
                            Builder builder = this.this$0;
                            String it = string2;
                            boolean bl = false;
                            if (!((Collection)Builder.access$getUserLoggers(builder)).isEmpty()) {
                                ((RealmLogger)Builder.access$getUserLoggers(builder).get(0)).log(LogLevel.WARN, it);
                            } else {
                                this.getFallbackErrorLogger().log(LogLevel.WARN, it);
                            }
                        }
                    }
                };
            }
            if (this.syncClientResetStrategy == null) {
                SyncClientResetStrategy syncClientResetStrategy = this.syncClientResetStrategy = this.partitionValue == null ? (SyncClientResetStrategy)new ManuallyRecoverUnsyncedChangesStrategy(this){
                    final /* synthetic */ Builder this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onClientReset(@NotNull SyncSession session2, @NotNull ClientResetRequiredException exception) {
                        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        RealmLog realmLog = Builder.access$getAppLog$p(this.this$0);
                        if (realmLog == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"appLog");
                            realmLog = null;
                        }
                        realmLog.error("Client Reset required on Realm: " + exception.getOriginalFilePath(), new Object[0]);
                    }
                } : (SyncClientResetStrategy)new DiscardUnsyncedChangesStrategy(this){
                    final /* synthetic */ Builder this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onBeforeReset(@NotNull TypedRealm realm) {
                        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
                        RealmLog realmLog = Builder.access$getAppLog$p(this.this$0);
                        if (realmLog == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"appLog");
                            realmLog = null;
                        }
                        realmLog.info("Client Reset is about to happen on Realm: " + realm.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onAfterReset(@NotNull TypedRealm before, @NotNull MutableRealm after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        RealmLog realmLog = Builder.access$getAppLog$p(this.this$0);
                        if (realmLog == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"appLog");
                            realmLog = null;
                        }
                        realmLog.info("Client Reset complete on Realm: " + after.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onError(@NotNull SyncSession session2, @NotNull ClientResetRequiredException exception) {
                        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        RealmLog realmLog = Builder.access$getAppLog$p(this.this$0);
                        if (realmLog == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"appLog");
                            realmLog = null;
                        }
                        realmLog.error("Discard unsynced changes client reset failed on Realm: " + exception.getOriginalFilePath(), new Object[0]);
                    }
                };
            }
            if (this.partitionValue == null && this.getName() == null) {
                this.setName("default.realm");
            }
            String fullPathToFile = this.getAbsolutePath(this.getName());
            String fileName = StringsKt.substringAfterLast$default((String)fullPathToFile, (String)SystemUtilsKt.getPATH_SEPARATOR(), null, (int)2, null);
            String directory = StringsKt.removeSuffix((String)fullPathToFile, (CharSequence)(SystemUtilsKt.getPATH_SEPARATOR() + fileName));
            Set set = this.getSchema();
            LogConfiguration logConfiguration = new LogConfiguration(this.getLogLevel(), allLoggers);
            long l = this.getMaxNumberOfActiveVersions();
            CoroutineDispatcher coroutineDispatcher2 = this.getNotificationDispatcher();
            if (coroutineDispatcher2 == null) {
                coroutineDispatcher2 = CoroutineUtilsJvmKt.singleThreadDispatcher((String)fileName);
            }
            if ((coroutineDispatcher = this.getWriteDispatcher()) == null) {
                coroutineDispatcher = CoroutineUtilsJvmKt.singleThreadDispatcher((String)fileName);
            }
            ConfigurationImpl baseConfiguration = new ConfigurationImpl(directory, fileName, set, logConfiguration, l, coroutineDispatcher2, coroutineDispatcher, this.getSchemaVersion(), SchemaMode.RLM_SCHEMA_MODE_ADDITIVE_DISCOVERED, this.getEncryptionKey(), this.getCompactOnLaunchCallback(), null, this.getInitialDataCallback(), this.partitionValue == null);
            InternalConfiguration internalConfiguration = (InternalConfiguration)baseConfiguration;
            User user = this.user;
            Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
            UserImpl userImpl = (UserImpl)user;
            SyncSession.ErrorHandler errorHandler = this.errorHandler;
            Intrinsics.checkNotNull((Object)errorHandler);
            SyncClientResetStrategy syncClientResetStrategy = this.syncClientResetStrategy;
            Intrinsics.checkNotNull((Object)syncClientResetStrategy);
            return new SyncConfigurationImpl(internalConfiguration, this.partitionValue, userImpl, errorHandler, syncClientResetStrategy, this.initialSubscriptions, this.waitForServerChanges);
        }

        private final String getAbsolutePath(String name) {
            NativePointer nativePointer;
            boolean bl;
            boolean bl2 = bl = this.partitionValue == null;
            if (bl) {
                User user = this.user;
                Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                nativePointer = RealmInterop.INSTANCE.realm_flx_sync_config_new(((UserImpl)user).getNativePointer());
            } else if (!bl) {
                User user = this.user;
                Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                NativePointer<RealmUserT> nativePointer2 = ((UserImpl)user).getNativePointer();
                PartitionValue partitionValue = this.partitionValue;
                Intrinsics.checkNotNull((Object)partitionValue);
                nativePointer = RealmInterop.INSTANCE.realm_sync_config_new(nativePointer2, partitionValue.asSyncPartition());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            NativePointer auxSyncConfig = nativePointer;
            boolean bl3 = false;
            User user = this.user;
            Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
            String absolutePath = RealmInterop.INSTANCE.realm_app_sync_client_get_default_file_path_for_realm(((UserImpl)user).getApp().getNativePointer$io_realm_kotlin_library(), auxSyncConfig, name);
            return name != null ? StringsKt.removeSuffix((String)absolutePath, (CharSequence)".realm") : absolutePath;
        }

        public static final /* synthetic */ List access$getUserLoggers(Builder $this) {
            return $this.getUserLoggers();
        }

        public static final /* synthetic */ RealmLog access$getAppLog$p(Builder $this) {
            return $this.appLog;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nJ.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\r2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nJ3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00102\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\u0011J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00122\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nJ$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a8\u0006\u0013"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Companion;", "", "()V", "create", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "user", "Lio/realm/kotlin/mongodb/User;", "partitionValue", "Lio/realm/kotlin/types/ObjectId;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/types/RealmUUID;", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Integer;Ljava/util/Set;)Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Long;Ljava/util/Set;)Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable String partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable Integer partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable Long partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable ObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable RealmUUID partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

