/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.sync;

import io.realm.kotlin.types.ObjectId;
import io.realm.kotlin.types.RealmUUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\u0011\b\u0002\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/realm/kotlin/mongodb/sync/PartitionValue;", "", "value", "", "(Ljava/lang/String;)V", "", "(Ljava/lang/Long;)V", "", "(Ljava/lang/Integer;)V", "Lio/realm/kotlin/types/ObjectId;", "(Lio/realm/kotlin/types/ObjectId;)V", "Lio/realm/kotlin/types/RealmUUID;", "(Lio/realm/kotlin/types/RealmUUID;)V", "bsonValue", "(Ljava/lang/Object;)V", "valueType", "Lio/realm/kotlin/mongodb/sync/PartitionValue$ValueType;", "asSyncPartition", "equals", "", "other", "hashCode", "ValueType", "io.realm.kotlin.library"})
public final class PartitionValue {
    @Nullable
    private final Object bsonValue;
    @NotNull
    private final ValueType valueType;

    private PartitionValue(Object bsonValue) {
        ValueType valueType;
        this.bsonValue = bsonValue;
        Object object = this.bsonValue;
        if (object instanceof String) {
            valueType = ValueType.STRING;
        } else if (object instanceof Long) {
            valueType = ValueType.LONG;
        } else if (object instanceof Integer) {
            valueType = ValueType.INT;
        } else if (object instanceof ObjectId) {
            valueType = ValueType.OBJECT_ID;
        } else if (object instanceof RealmUUID) {
            valueType = ValueType.UUID;
        } else if (object == null) {
            valueType = ValueType.NULL;
        } else {
            String string = "Unsupported type: " + Reflection.getOrCreateKotlinClass(this.bsonValue.getClass());
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        this.valueType = valueType;
    }

    public PartitionValue(@Nullable String value) {
        this((Object)value);
    }

    public PartitionValue(@Nullable Long value) {
        this((Object)value);
    }

    public PartitionValue(@Nullable Integer value) {
        this((Object)value);
    }

    public PartitionValue(@Nullable ObjectId value) {
        this((Object)value);
    }

    public PartitionValue(@Nullable RealmUUID value) {
        this((Object)value);
    }

    @NotNull
    public final String asSyncPartition() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.valueType.ordinal()]) {
            case 1: {
                StringBuilder stringBuilder = new StringBuilder().append('\"');
                Object object = this.bsonValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                string = stringBuilder.append((String)object).append('\"').toString();
                break;
            }
            case 2: {
                StringBuilder stringBuilder = new StringBuilder().append("{\"$numberLong\":\"");
                Object object = this.bsonValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                string = stringBuilder.append((Long)object).append("\"}").toString();
                break;
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder().append("{\"$numberInt\":\"");
                Object object = this.bsonValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                string = stringBuilder.append((Integer)object).append("\"}").toString();
                break;
            }
            case 4: {
                StringBuilder stringBuilder = new StringBuilder().append("{\"$oid\":\"");
                Object object = this.bsonValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.realm.kotlin.types.ObjectId");
                string = stringBuilder.append((ObjectId)object).append("\"}").toString();
                break;
            }
            case 5: {
                StringBuilder stringBuilder = new StringBuilder().append("{\"$uuid\":\"");
                Object object = this.bsonValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.realm.kotlin.types.RealmUUID");
                string = stringBuilder.append((RealmUUID)object).append("\"}").toString();
                break;
            }
            case 6: {
                string = "null";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PartitionValue && Intrinsics.areEqual((Object)this.asSyncPartition(), (Object)((PartitionValue)other).asSyncPartition());
    }

    public int hashCode() {
        Object object = this.bsonValue;
        int result2 = object != null ? object.hashCode() : 0;
        result2 = 31 * result2 + this.valueType.hashCode();
        return result2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/mongodb/sync/PartitionValue$ValueType;", "", "(Ljava/lang/String;I)V", "STRING", "LONG", "INT", "NULL", "OBJECT_ID", "UUID", "io.realm.kotlin.library"})
    public static final class ValueType
    extends Enum<ValueType> {
        public static final /* enum */ ValueType STRING = new ValueType();
        public static final /* enum */ ValueType LONG = new ValueType();
        public static final /* enum */ ValueType INT = new ValueType();
        public static final /* enum */ ValueType NULL = new ValueType();
        public static final /* enum */ ValueType OBJECT_ID = new ValueType();
        public static final /* enum */ ValueType UUID = new ValueType();
        private static final /* synthetic */ ValueType[] $VALUES;

        public static ValueType[] values() {
            return (ValueType[])$VALUES.clone();
        }

        public static ValueType valueOf(String value) {
            return Enum.valueOf(ValueType.class, value);
        }

        static {
            $VALUES = valueTypeArray = new ValueType[]{ValueType.STRING, ValueType.LONG, ValueType.INT, ValueType.NULL, ValueType.OBJECT_ID, ValueType.UUID};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.INT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.OBJECT_ID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.UUID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

