/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.interop.AppCallback;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmUserT;
import io.realm.kotlin.internal.interop.sync.AuthProvider;
import io.realm.kotlin.internal.interop.sync.CoreUserState;
import io.realm.kotlin.internal.interop.sync.SyncUserIdentity;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.mongodb.AuthenticationProvider;
import io.realm.kotlin.mongodb.Credentials;
import io.realm.kotlin.mongodb.User;
import io.realm.kotlin.mongodb.UserIdentity;
import io.realm.kotlin.mongodb.exceptions.CredentialsCannotBeLinkedException;
import io.realm.kotlin.mongodb.exceptions.ServiceException;
import io.realm.kotlin.mongodb.internal.AppImpl;
import io.realm.kotlin.mongodb.internal.CredentialsImpl;
import io.realm.kotlin.mongodb.internal.RealmSyncUtilsKt;
import io.realm.kotlin.mongodb.internal.UserImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010*\u001a\u00020+H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0013\u0010-\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010/H\u0096\u0002J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000204H\u0016J\u0019\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u000207H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0011\u00109\u001a\u00020+H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0011\u0010:\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\fR\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Lio/realm/kotlin/mongodb/internal/UserImpl;", "Lio/realm/kotlin/mongodb/User;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmUserT;", "Lio/realm/kotlin/internal/interop/RealmUserPointer;", "app", "Lio/realm/kotlin/mongodb/internal/AppImpl;", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/mongodb/internal/AppImpl;)V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "getApp", "()Lio/realm/kotlin/mongodb/internal/AppImpl;", "deviceId", "getDeviceId", "id", "getId", "identities", "", "Lio/realm/kotlin/mongodb/UserIdentity;", "getIdentities", "()Ljava/util/List;", "identity", "getIdentity", "loggedIn", "", "getLoggedIn", "()Z", "getNativePointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "provider", "Lio/realm/kotlin/mongodb/AuthenticationProvider;", "getProvider", "()Lio/realm/kotlin/mongodb/AuthenticationProvider;", "refreshToken", "getRefreshToken", "state", "Lio/realm/kotlin/mongodb/User$State;", "getState", "()Lio/realm/kotlin/mongodb/User$State;", "delete", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "other", "", "getProviderFromCore", "authProvider", "Lio/realm/kotlin/internal/interop/sync/AuthProvider;", "hashCode", "", "linkCredentials", "credentials", "Lio/realm/kotlin/mongodb/Credentials;", "(Lio/realm/kotlin/mongodb/Credentials;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logOut", "remove", "Companion", "io.realm.kotlin.library"})
public final class UserImpl
implements User {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativePointer<RealmUserT> nativePointer;
    @NotNull
    private final AppImpl app;

    public UserImpl(@NotNull NativePointer<RealmUserT> nativePointer, @NotNull AppImpl app) {
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.nativePointer = nativePointer;
        this.app = app;
    }

    @NotNull
    public final NativePointer<RealmUserT> getNativePointer() {
        return this.nativePointer;
    }

    @Override
    @NotNull
    public AppImpl getApp() {
        return this.app;
    }

    @Override
    @NotNull
    public User.State getState() {
        return Companion.fromCoreState(RealmInterop.INSTANCE.realm_user_get_state(this.nativePointer));
    }

    @Override
    @NotNull
    public String getIdentity() {
        return this.getId();
    }

    @Override
    @NotNull
    public String getId() {
        return RealmInterop.INSTANCE.realm_user_get_identity(this.nativePointer);
    }

    @Override
    public boolean getLoggedIn() {
        return RealmInterop.INSTANCE.realm_user_is_logged_in(this.nativePointer);
    }

    @Override
    @NotNull
    public AuthenticationProvider getProvider() {
        return this.getProviderFromCore(RealmInterop.INSTANCE.realm_user_get_auth_provider(this.nativePointer));
    }

    @Override
    @NotNull
    public String getAccessToken() {
        return RealmInterop.INSTANCE.realm_user_get_access_token(this.nativePointer);
    }

    @Override
    @NotNull
    public String getRefreshToken() {
        return RealmInterop.INSTANCE.realm_user_get_refresh_token(this.nativePointer);
    }

    @Override
    @NotNull
    public String getDeviceId() {
        return RealmInterop.INSTANCE.realm_user_get_device_id(this.nativePointer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<UserIdentity> getIdentities() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RealmInterop.INSTANCE.realm_user_get_all_identities(this.nativePointer);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SyncUserIdentity syncUserIdentity = (SyncUserIdentity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserIdentity(it.getId(), this.getProviderFromCore(it.getProvider())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object logOut(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof logOut.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ UserImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logOut((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$use$iv = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
                $i$f$use = false;
                channel = $this$use$iv;
                $i$a$-use-UserImpl$logOut$2 = false;
                RealmInterop.INSTANCE.realm_app_log_out(this.getApp().getNativePointer$io_realm_kotlin_library(), this.nativePointer, (AppCallback)SystemUtilsKt.freeze(RealmSyncUtilsKt.channelResultCallback(channel, logOut.2.1.INSTANCE)));
                $continuation.L$0 = $this$use$iv;
                $continuation.label = 1;
                v0 = channel.receive((Continuation)$continuation);
                ** if (v0 != var10_4) goto lbl24
lbl23:
                // 1 sources

                return var10_4;
lbl24:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-UserImpl$logOut$2 = false;
                $this$use$iv = (Channel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    var6_11 = ((Result)v0).unbox-impl();
                    ResultKt.throwOnFailure((Object)var6_11);
                    var7_12 = Unit.INSTANCE;
                }
                catch (Throwable var7_13) {
                    throw var7_13;
                }
                finally {
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)$this$use$iv), null, (int)1, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object remove(@NotNull Continuation<? super User> var1_1) {
        if (!(var1_1 instanceof remove.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ UserImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.remove((Continuation<? super User>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$use$iv = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
                $i$f$use = false;
                channel = $this$use$iv;
                $i$a$-use-UserImpl$remove$2 = false;
                RealmInterop.INSTANCE.realm_app_remove_user(this.getApp().getNativePointer$io_realm_kotlin_library(), this.nativePointer, (AppCallback)SystemUtilsKt.freeze(RealmSyncUtilsKt.channelResultCallback(channel, remove.2.1.INSTANCE)));
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.label = 1;
                v0 = channel.receive((Continuation)$continuation);
                ** if (v0 != var10_4) goto lbl25
lbl24:
                // 1 sources

                return var10_4;
lbl25:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-UserImpl$remove$2 = false;
                $this$use$iv = (Channel)$continuation.L$1;
                this = (UserImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl35:
                    // 2 sources

                    var6_11 = ((Result)v0).unbox-impl();
                    ResultKt.throwOnFailure((Object)var6_11);
                    var7_12 = Unit.INSTANCE;
                }
                catch (Throwable var7_13) {
                    throw var7_13;
                }
                finally {
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)$this$use$iv), null, (int)1, null);
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object delete(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof delete.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ UserImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.delete((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getState() != User.State.LOGGED_IN) {
                    throw new IllegalStateException("User must be logged in, in order to be deleted.");
                }
                $this$use$iv = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
                $i$f$use = false;
                channel = $this$use$iv;
                $i$a$-use-UserImpl$delete$2 = false;
                RealmInterop.INSTANCE.realm_app_delete_user(this.getApp().getNativePointer$io_realm_kotlin_library(), this.nativePointer, (AppCallback)SystemUtilsKt.freeze(RealmSyncUtilsKt.channelResultCallback(channel, delete.2.1.INSTANCE)));
                $continuation.L$0 = $this$use$iv;
                $continuation.label = 1;
                v0 = channel.receive((Continuation)$continuation);
                ** if (v0 != var10_4) goto lbl26
lbl25:
                // 1 sources

                return var10_4;
lbl26:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-UserImpl$delete$2 = false;
                $this$use$iv = (Channel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl35:
                    // 2 sources

                    var6_11 = ((Result)v0).unbox-impl();
                    ResultKt.throwOnFailure((Object)var6_11);
                    var7_12 = Unit.INSTANCE;
                }
                catch (Throwable var7_13) {
                    throw var7_13;
                }
                finally {
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)$this$use$iv), null, (int)1, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Object linkCredentials(@NotNull Credentials var1_1, @NotNull Continuation<? super User> var2_2) {
        if (!(var2_2 instanceof linkCredentials.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ UserImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.linkCredentials(null, (Continuation<? super User>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getState() != User.State.LOGGED_IN) {
                    throw new IllegalStateException("User must be logged in, in order to link credentials to it.");
                }
                try {
                    $this$use$iv = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
                    $i$f$use = false;
                    channel = $this$use$iv;
                    $i$a$-use-UserImpl$linkCredentials$2 = false;
                    v0 = this.getApp().getNativePointer$io_realm_kotlin_library();
                    Intrinsics.checkNotNull((Object)credentials, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.CredentialsImpl");
                    RealmInterop.INSTANCE.realm_app_link_credentials(v0, this.nativePointer, ((CredentialsImpl)credentials).getNativePointer$io_realm_kotlin_library(), (AppCallback)SystemUtilsKt.freeze(RealmSyncUtilsKt.channelResultCallback(channel, (Function1)new Function1<NativePointer<RealmUserT>, User>(this){
                        final /* synthetic */ UserImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final User invoke(@NotNull NativePointer<RealmUserT> userPointer) {
                            Intrinsics.checkNotNullParameter(userPointer, (String)"userPointer");
                            return new UserImpl(userPointer, this.this$0.getApp());
                        }
                    })));
                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$use$iv;
                    $continuation.label = 1;
                    v1 = channel.receive((Continuation)$continuation);
                }
                catch (ServiceException ex) {
                    v2 = ex.getMessage();
                    if ((v2 != null ? StringsKt.contains$default((CharSequence)v2, (CharSequence)"[Service][InvalidSession(2)] a user already exists with the specified provider.", (boolean)false, (int)2, null) : false) == false) throw ex;
                    v3 = ex.getMessage();
                    Intrinsics.checkNotNull((Object)v3);
                    throw new CredentialsCannotBeLinkedException(v3);
                }
                v4 = v1;
                if (v1 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl51
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-UserImpl$linkCredentials$2 = false;
                $this$use$iv = (Channel)$continuation.L$1;
                this = (UserImpl)$continuation.L$0;
                ** try [egrp 3[TRYBLOCK] [1 : 248->272)] { 
lbl48:
                // 1 sources

                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl51:
                // 2 sources

                var7_13 = ((Result)v4).unbox-impl();
                ResultKt.throwOnFailure((Object)var7_13);
                return this;
lbl54:
                // 1 sources

                finally {
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)$this$use$iv), null, (int)1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        UserImpl cfr_ignored_0 = (UserImpl)other;
        if (!Intrinsics.areEqual((Object)this.getIdentity(), (Object)((UserImpl)other).getIdentity())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getApp().getConfiguration(), (Object)((UserImpl)other).getApp().getConfiguration());
    }

    public int hashCode() {
        int result2 = this.getIdentity().hashCode();
        result2 = 31 * result2 + this.getApp().getConfiguration().getAppId().hashCode();
        return result2;
    }

    private final AuthenticationProvider getProviderFromCore(AuthProvider authProvider) {
        AuthenticationProvider authenticationProvider;
        switch (WhenMappings.$EnumSwitchMapping$0[authProvider.ordinal()]) {
            case 1: {
                authenticationProvider = AuthenticationProvider.ANONYMOUS;
                break;
            }
            case 2: {
                authenticationProvider = AuthenticationProvider.ANONYMOUS;
                break;
            }
            case 3: {
                authenticationProvider = AuthenticationProvider.FACEBOOK;
                break;
            }
            case 4: {
                authenticationProvider = AuthenticationProvider.GOOGLE;
                break;
            }
            case 5: {
                authenticationProvider = AuthenticationProvider.APPLE;
                break;
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
            case 7: {
                authenticationProvider = AuthenticationProvider.EMAIL_PASSWORD;
                break;
            }
            case 8: {
                throw new NotImplementedError(null, 1, null);
            }
            case 9: {
                authenticationProvider = AuthenticationProvider.API_KEY;
                break;
            }
            case 10: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new IllegalStateException("Unknown auth provider: " + authProvider);
            }
        }
        return authenticationProvider;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/realm/kotlin/mongodb/internal/UserImpl$Companion;", "", "()V", "fromCoreState", "Lio/realm/kotlin/mongodb/User$State;", "coreState", "Lio/realm/kotlin/internal/interop/sync/CoreUserState;", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final User.State fromCoreState(@NotNull CoreUserState coreState) {
            User.State state;
            Intrinsics.checkNotNullParameter((Object)coreState, (String)"coreState");
            switch (WhenMappings.$EnumSwitchMapping$0[coreState.ordinal()]) {
                case 1: {
                    state = User.State.LOGGED_OUT;
                    break;
                }
                case 2: {
                    state = User.State.LOGGED_IN;
                    break;
                }
                case 3: {
                    state = User.State.REMOVED;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid user state: " + coreState.name());
                }
            }
            return state;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CoreUserState.values().length];
                try {
                    nArray[CoreUserState.RLM_USER_STATE_LOGGED_OUT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreUserState.RLM_USER_STATE_LOGGED_IN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CoreUserState.RLM_USER_STATE_REMOVED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthProvider.values().length];
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_ANONYMOUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_ANONYMOUS_NO_REUSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_FACEBOOK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_GOOGLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_APPLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_CUSTOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_EMAIL_PASSWORD.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_FUNCTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_USER_API_KEY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthProvider.RLM_AUTH_PROVIDER_SERVER_API_KEY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

