/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.RealmLog;
import io.realm.kotlin.internal.interop.CoreLogLevel;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmAppConfigT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSyncClientConfigT;
import io.realm.kotlin.internal.interop.SyncLogCallback;
import io.realm.kotlin.internal.interop.sync.MetadataMode;
import io.realm.kotlin.internal.interop.sync.NetworkTransport;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.mongodb.AppConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0017H\u0002J\u0012\u0010(\u001a\f\u0012\u0004\u0012\u00020\u001d0\u0015j\u0002`\u001eH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001d0\u0015j\u0002`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000e\u00a8\u0006)"}, d2={"Lio/realm/kotlin/mongodb/internal/AppConfigurationImpl;", "Lio/realm/kotlin/mongodb/AppConfiguration;", "appId", "", "baseUrl", "networkTransport", "Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "metadataMode", "Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "syncRootDirectory", "log", "Lio/realm/kotlin/internal/RealmLog;", "(Ljava/lang/String;Ljava/lang/String;Lio/realm/kotlin/internal/interop/sync/NetworkTransport;Lio/realm/kotlin/internal/interop/sync/MetadataMode;Ljava/lang/String;Lio/realm/kotlin/internal/RealmLog;)V", "getAppId", "()Ljava/lang/String;", "getBaseUrl", "getLog", "()Lio/realm/kotlin/internal/RealmLog;", "getMetadataMode", "()Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmAppConfigT;", "Lio/realm/kotlin/internal/interop/RealmAppConfigurationPointer;", "getNativePointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getNetworkTransport", "()Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "synClientConfig", "Lio/realm/kotlin/internal/interop/RealmSyncClientConfigT;", "Lio/realm/kotlin/internal/interop/RealmSyncClientConfigurationPointer;", "getSynClientConfig", "getSyncRootDirectory", "equals", "", "other", "", "hashCode", "", "initializeRealmAppConfig", "initializeSyncClientConfig", "io.realm.kotlin.library"})
public final class AppConfigurationImpl
implements AppConfiguration {
    @NotNull
    private final String appId;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final NetworkTransport networkTransport;
    @NotNull
    private final MetadataMode metadataMode;
    @NotNull
    private final String syncRootDirectory;
    @NotNull
    private final RealmLog log;
    @NotNull
    private final NativePointer<RealmAppConfigT> nativePointer;
    @NotNull
    private final NativePointer<RealmSyncClientConfigT> synClientConfig;

    public AppConfigurationImpl(@NotNull String appId, @NotNull String baseUrl, @NotNull NetworkTransport networkTransport2, @NotNull MetadataMode metadataMode, @NotNull String syncRootDirectory, @NotNull RealmLog log) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)networkTransport2, (String)"networkTransport");
        Intrinsics.checkNotNullParameter((Object)metadataMode, (String)"metadataMode");
        Intrinsics.checkNotNullParameter((Object)syncRootDirectory, (String)"syncRootDirectory");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.appId = appId;
        this.baseUrl = baseUrl;
        this.networkTransport = networkTransport2;
        this.metadataMode = metadataMode;
        this.syncRootDirectory = syncRootDirectory;
        this.log = log;
        this.nativePointer = this.initializeRealmAppConfig();
        this.synClientConfig = this.initializeSyncClientConfig();
    }

    public /* synthetic */ AppConfigurationImpl(String string, String string2, NetworkTransport networkTransport2, MetadataMode metadataMode, String string3, RealmLog realmLog, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "https://realm.mongodb.com";
        }
        if ((n & 8) != 0) {
            metadataMode = MetadataMode.RLM_SYNC_CLIENT_METADATA_MODE_PLAINTEXT;
        }
        this(string, string2, networkTransport2, metadataMode, string3, realmLog);
    }

    @Override
    @NotNull
    public String getAppId() {
        return this.appId;
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @NotNull
    public NetworkTransport getNetworkTransport() {
        return this.networkTransport;
    }

    @Override
    @NotNull
    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    @Override
    @NotNull
    public String getSyncRootDirectory() {
        return this.syncRootDirectory;
    }

    @NotNull
    public final RealmLog getLog() {
        return this.log;
    }

    @NotNull
    public final NativePointer<RealmAppConfigT> getNativePointer() {
        return this.nativePointer;
    }

    @NotNull
    public final NativePointer<RealmSyncClientConfigT> getSynClientConfig() {
        return this.synClientConfig;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        AppConfigurationImpl cfr_ignored_0 = (AppConfigurationImpl)other;
        if (!Intrinsics.areEqual((Object)this.getAppId(), (Object)((AppConfigurationImpl)other).getAppId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBaseUrl(), (Object)((AppConfigurationImpl)other).getBaseUrl())) {
            return false;
        }
        if (this.getMetadataMode() != ((AppConfigurationImpl)other).getMetadataMode()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.log, (Object)((AppConfigurationImpl)other).log);
    }

    public int hashCode() {
        int result2 = this.getAppId().hashCode();
        result2 = 31 * result2 + this.getBaseUrl().hashCode();
        result2 = 31 * result2 + this.getMetadataMode().hashCode();
        result2 = 31 * result2 + this.log.hashCode();
        return result2;
    }

    private final NativePointer<RealmAppConfigT> initializeRealmAppConfig() {
        RealmInterop realmInterop = RealmInterop.INSTANCE;
        String string = this.getAppId();
        String string2 = this.getBaseUrl();
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_network_transport_new(this.getNetworkTransport());
        String string3 = SystemUtilsJvmKt.getOS_NAME() + '/' + SystemUtilsKt.getRUNTIME();
        String string4 = SystemUtilsJvmKt.getOS_VERSION();
        return (NativePointer)SystemUtilsKt.freeze((Object)realmInterop.realm_app_config_new(string, nativePointer, string2, string3, string4, "1.4.0"));
    }

    private final NativePointer<RealmSyncClientConfigT> initializeSyncClientConfig() {
        NativePointer nativePointer;
        NativePointer syncClientConfig = nativePointer = RealmInterop.INSTANCE.realm_sync_client_config_new();
        boolean bl = false;
        RealmLogger syncLogger = SystemUtilsJvmKt.createDefaultSystemLogger((String)"SYNC", (LogLevel)this.log.getLogLevel());
        RealmInterop.INSTANCE.realm_sync_client_config_set_log_callback(syncClientConfig, new SyncLogCallback(syncLogger){
            final /* synthetic */ RealmLogger $syncLogger;
            {
                this.$syncLogger = $syncLogger;
            }

            public void log(short logLevel, @Nullable String message) {
                CoreLogLevel coreLogLevel = CoreLogLevel.Companion.valueFromPriority(logLevel);
                LogLevel logLevel2 = LogLevel.Companion.fromCoreLogLevel(coreLogLevel);
                String string = message;
                if (string == null) {
                    string = "";
                }
                this.$syncLogger.log(logLevel2, string);
            }
        });
        RealmInterop.INSTANCE.realm_sync_client_config_set_log_level(syncClientConfig, CoreLogLevel.Companion.valueFromPriority((short)this.log.getLogLevel().getPriority()));
        RealmInterop.INSTANCE.realm_sync_client_config_set_metadata_mode(syncClientConfig, this.getMetadataMode());
        RealmInterop.INSTANCE.realm_sync_client_config_set_base_file_path(syncClientConfig, this.getSyncRootDirectory());
        return nativePointer;
    }
}

