/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb;

import io.ktor.client.plugins.logging.Logger;
import io.realm.kotlin.LogConfiguration;
import io.realm.kotlin.internal.CoreExceptionConverter;
import io.realm.kotlin.internal.RealmLog;
import io.realm.kotlin.internal.interop.sync.MetadataMode;
import io.realm.kotlin.internal.interop.sync.NetworkTransport;
import io.realm.kotlin.internal.platform.CoroutineUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.mongodb.internal.AppConfigurationImpl;
import io.realm.kotlin.mongodb.internal.KtorNetworkTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration;", "", "appId", "", "getAppId", "()Ljava/lang/String;", "baseUrl", "getBaseUrl", "metadataMode", "Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "getMetadataMode", "()Lio/realm/kotlin/internal/interop/sync/MetadataMode;", "networkTransport", "Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "getNetworkTransport", "()Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "syncRootDirectory", "getSyncRootDirectory", "Builder", "Companion", "io.realm.kotlin.library"})
public interface AppConfiguration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.AppConfiguration$Companion.$$INSTANCE;
    @NotNull
    public static final String DEFAULT_BASE_URL = "https://realm.mongodb.com";
    @NotNull
    public static final String DEFAULT_AUTHORIZATION_HEADER_NAME = "Authorization";

    @NotNull
    public String getAppId();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public NetworkTransport getNetworkTransport();

    @NotNull
    public MetadataMode getMetadataMode();

    @NotNull
    public String getSyncRootDirectory();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration$Companion;", "", "()V", "DEFAULT_AUTHORIZATION_HEADER_NAME", "", "DEFAULT_BASE_URL", "create", "Lio/realm/kotlin/mongodb/AppConfiguration;", "appId", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String DEFAULT_BASE_URL = "https://realm.mongodb.com";
        @NotNull
        public static final String DEFAULT_AUTHORIZATION_HEADER_NAME = "Authorization";

        private Companion() {
        }

        @NotNull
        public final AppConfiguration create(@NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            return new Builder(appId).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\t2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\r\u0010\n\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0015J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/realm/kotlin/mongodb/AppConfiguration$Builder;", "", "appId", "", "(Ljava/lang/String;)V", "baseUrl", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "logLevel", "Lio/realm/kotlin/log/LogLevel;", "removeSystemLogger", "", "syncRootDirectory", "userLoggers", "", "Lio/realm/kotlin/log/RealmLogger;", "build", "Lio/realm/kotlin/mongodb/AppConfiguration;", "log", "level", "customLoggers", "removeSystemLogger$io_realm_kotlin_library", "rootDir", "io.realm.kotlin.library"})
    public static final class Builder {
        @NotNull
        private final String appId;
        @NotNull
        private String baseUrl;
        @NotNull
        private CoroutineDispatcher dispatcher;
        @NotNull
        private LogLevel logLevel;
        private boolean removeSystemLogger;
        @NotNull
        private String syncRootDirectory;
        @NotNull
        private List<? extends RealmLogger> userLoggers;

        public Builder(@NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            this.appId = appId;
            CoreExceptionConverter.INSTANCE.initialize();
            this.baseUrl = AppConfiguration.DEFAULT_BASE_URL;
            this.dispatcher = CoroutineUtilsJvmKt.singleThreadDispatcher((String)("dispatcher-" + this.appId));
            this.logLevel = LogLevel.WARN;
            this.syncRootDirectory = SystemUtilsJvmKt.appFilesDirectory();
            this.userLoggers = CollectionsKt.emptyList();
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u240.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Builder $this$dispatcher_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$dispatcher_u24lambda_u241.dispatcher = dispatcher;
            return builder;
        }

        @NotNull
        public final Builder log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            Builder $this$log_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$log_u24lambda_u242.logLevel = level;
            $this$log_u24lambda_u242.userLoggers = customLoggers;
            return builder;
        }

        public static /* synthetic */ Builder log$default(Builder builder, LogLevel logLevel, List list, int n, Object object) {
            if ((n & 1) != 0) {
                logLevel = LogLevel.WARN;
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return builder.log(logLevel, list);
        }

        @NotNull
        public final Builder syncRootDirectory(@NotNull String rootDir) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Builder $this$syncRootDirectory_u24lambda_u243 = builder = this;
            boolean bl = false;
            boolean directoryExists = SystemUtilsKt.directoryExists((String)rootDir);
            if (!directoryExists && SystemUtilsKt.fileExists((String)rootDir)) {
                throw new IllegalArgumentException("'rootDir' is a file, not a directory: " + rootDir + '.');
            }
            if (!directoryExists) {
                SystemUtilsKt.prepareRealmDirectoryPath((String)rootDir);
            }
            if (!SystemUtilsKt.canWrite((String)rootDir)) {
                throw new IllegalArgumentException("Realm directory is not writable: " + rootDir + '.');
            }
            $this$syncRootDirectory_u24lambda_u243.syncRootDirectory = rootDir;
            return builder;
        }

        @NotNull
        public final Builder removeSystemLogger$io_realm_kotlin_library() {
            Builder builder;
            Builder $this$removeSystemLogger_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$removeSystemLogger_u24lambda_u244.removeSystemLogger = true;
            return builder;
        }

        @NotNull
        public final AppConfiguration build() {
            List allLoggers = new ArrayList();
            if (!this.removeSystemLogger) {
                allLoggers.add(SystemUtilsJvmKt.createDefaultSystemLogger$default((String)"REALM", null, (int)2, null));
            }
            allLoggers.addAll((Collection)this.userLoggers);
            RealmLog appLogger = new RealmLog(null, new LogConfiguration(this.logLevel, allLoggers), 1, null);
            NetworkTransport networkTransport2 = (NetworkTransport)SystemUtilsKt.freeze((Object)new KtorNetworkTransport(null, null, 15000L, this.dispatcher, new Logger(appLogger){
                final /* synthetic */ RealmLog $appLogger;
                {
                    this.$appLogger = $appLogger;
                }

                public void log(@NotNull String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    this.$appLogger.debug(message, new Object[0]);
                }
            }, 3, null));
            return new AppConfigurationImpl(this.appId, this.baseUrl, networkTransport2, null, this.syncRootDirectory, appLogger, 8, null);
        }
    }
}

