/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.internal.RealmInstantImplKt;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmAppT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmUserT;
import io.realm.kotlin.internal.interop.sync.NetworkTransport;
import io.realm.kotlin.internal.util.DispatcherHolder;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.log.RealmLog;
import io.realm.kotlin.mongodb.App;
import io.realm.kotlin.mongodb.AppConfiguration;
import io.realm.kotlin.mongodb.AuthenticationChange;
import io.realm.kotlin.mongodb.Credentials;
import io.realm.kotlin.mongodb.User;
import io.realm.kotlin.mongodb.auth.EmailPasswordAuth;
import io.realm.kotlin.mongodb.internal.AppConfigurationImpl;
import io.realm.kotlin.mongodb.internal.AppImpl;
import io.realm.kotlin.mongodb.internal.CredentialsImpl;
import io.realm.kotlin.mongodb.internal.CustomEJsonCredentialsImpl;
import io.realm.kotlin.mongodb.internal.EmailPasswordAuthImpl;
import io.realm.kotlin.mongodb.internal.LoggedInImpl;
import io.realm.kotlin.mongodb.internal.LoggedOutImpl;
import io.realm.kotlin.mongodb.internal.NetworkStateObserver;
import io.realm.kotlin.mongodb.internal.RealmSyncUtilsKt;
import io.realm.kotlin.mongodb.internal.RemovedImpl;
import io.realm.kotlin.mongodb.internal.SyncImpl;
import io.realm.kotlin.mongodb.internal.UserImpl;
import io.realm.kotlin.mongodb.sync.Sync;
import io.realm.kotlin.types.RealmInstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u001403H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b06H\u0016J\b\u00107\u001a\u000208H\u0016J\u0019\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u001d\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\rR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0019\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\f\u0012\u0004\u0012\u00020$0#j\u0002`%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010*\u001a\u00020!X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010,\u0012\u0004\b+\u0010\rR\u001b\u0010-\u001a\u00020.8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001c\u001a\u0004\b/\u00100\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006C"}, d2={"Lio/realm/kotlin/mongodb/internal/AppImpl;", "Lio/realm/kotlin/mongodb/App;", "configuration", "Lio/realm/kotlin/mongodb/internal/AppConfigurationImpl;", "(Lio/realm/kotlin/mongodb/internal/AppConfigurationImpl;)V", "appNetworkDispatcher", "Lio/realm/kotlin/internal/util/DispatcherHolder;", "getAppNetworkDispatcher$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/util/DispatcherHolder;", "authenticationChangeFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/realm/kotlin/mongodb/AuthenticationChange;", "getAuthenticationChangeFlow$annotations", "()V", "getConfiguration", "()Lio/realm/kotlin/mongodb/internal/AppConfigurationImpl;", "connectionListener", "Lio/realm/kotlin/mongodb/internal/NetworkStateObserver$ConnectionListener;", "getConnectionListener$annotations", "currentUser", "Lio/realm/kotlin/mongodb/User;", "getCurrentUser", "()Lio/realm/kotlin/mongodb/User;", "emailPasswordAuth", "Lio/realm/kotlin/mongodb/auth/EmailPasswordAuth;", "getEmailPasswordAuth", "()Lio/realm/kotlin/mongodb/auth/EmailPasswordAuth;", "emailPasswordAuth$delegate", "Lkotlin/Lazy;", "lastConnectedState", "", "Ljava/lang/Boolean;", "lastOnlineStateReported", "Lkotlin/time/Duration;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmAppT;", "Lio/realm/kotlin/internal/interop/RealmAppPointer;", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "networkTransport", "Lio/realm/kotlin/internal/interop/sync/NetworkTransport;", "reconnectThreshold", "getReconnectThreshold-UwyO8pc$annotations", "J", "sync", "Lio/realm/kotlin/mongodb/sync/Sync;", "getSync", "()Lio/realm/kotlin/mongodb/sync/Sync;", "sync$delegate", "allUsers", "", "", "authenticationChangeAsFlow", "Lkotlinx/coroutines/flow/Flow;", "close", "", "login", "credentials", "Lio/realm/kotlin/mongodb/Credentials;", "(Lio/realm/kotlin/mongodb/Credentials;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportAuthenticationChange", "user", "change", "Lio/realm/kotlin/mongodb/User$State;", "reportAuthenticationChange$io_realm_kotlin_library", "Companion", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nAppImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppImpl.kt\nio/realm/kotlin/mongodb/internal/AppImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Channel.kt\nio/realm/kotlin/internal/util/ChannelKt\n*L\n1#1,184:1\n1#2:185\n1549#3:186\n1620#3,3:187\n27#4,4:190\n*S KotlinDebug\n*F\n+ 1 AppImpl.kt\nio/realm/kotlin/mongodb/internal/AppImpl\n*L\n115#1:186\n115#1:187,3\n126#1:190,4\n*E\n"})
public final class AppImpl
implements App {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppConfigurationImpl configuration;
    @NotNull
    private final NativePointer<RealmAppT> nativePointer;
    @NotNull
    private final DispatcherHolder appNetworkDispatcher;
    @NotNull
    private final NetworkTransport networkTransport;
    @Nullable
    private Duration lastOnlineStateReported;
    @Nullable
    private Boolean lastConnectedState;
    private final long reconnectThreshold;
    @NotNull
    private final NetworkStateObserver.ConnectionListener connectionListener;
    @NotNull
    private final MutableSharedFlow<AuthenticationChange> authenticationChangeFlow;
    @NotNull
    private final Lazy emailPasswordAuth$delegate;
    @NotNull
    private final Lazy sync$delegate;

    public AppImpl(@NotNull AppConfigurationImpl configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.reconnectThreshold = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        this.connectionListener = arg_0 -> AppImpl.connectionListener$lambda$0(this, arg_0);
        this.authenticationChangeFlow = SharedFlowKt.MutableSharedFlow((int)0, (int)8, (BufferOverflow)BufferOverflow.SUSPEND);
        Triple<DispatcherHolder, NetworkTransport, NativePointer<RealmAppT>> appResources = this.getConfiguration().createNativeApp();
        this.appNetworkDispatcher = (DispatcherHolder)appResources.getFirst();
        this.networkTransport = (NetworkTransport)appResources.getSecond();
        this.nativePointer = (NativePointer)appResources.getThird();
        NetworkStateObserver.INSTANCE.addListener(this.connectionListener);
        this.emailPasswordAuth$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EmailPasswordAuthImpl>(this){
            final /* synthetic */ AppImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EmailPasswordAuthImpl invoke() {
                return new EmailPasswordAuthImpl(this.this$0.getNativePointer$io_realm_kotlin_library());
            }
        }));
        this.sync$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SyncImpl>(this){
            final /* synthetic */ AppImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SyncImpl invoke() {
                return new SyncImpl(this.this$0.getNativePointer$io_realm_kotlin_library());
            }
        }));
    }

    @Override
    @NotNull
    public AppConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final NativePointer<RealmAppT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @NotNull
    public final DispatcherHolder getAppNetworkDispatcher$io_realm_kotlin_library() {
        return this.appNetworkDispatcher;
    }

    private static /* synthetic */ void getReconnectThreshold-UwyO8pc$annotations() {
    }

    private static /* synthetic */ void getConnectionListener$annotations() {
    }

    private static /* synthetic */ void getAuthenticationChangeFlow$annotations() {
    }

    @Override
    @NotNull
    public EmailPasswordAuth getEmailPasswordAuth() {
        Lazy lazy = this.emailPasswordAuth$delegate;
        return (EmailPasswordAuth)lazy.getValue();
    }

    @Override
    @Nullable
    public User getCurrentUser() {
        UserImpl userImpl;
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_app_get_current_user(this.nativePointer);
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            userImpl = new UserImpl((NativePointer<RealmUserT>)it, this);
        } else {
            userImpl = null;
        }
        return userImpl;
    }

    @Override
    @NotNull
    public Sync getSync() {
        Lazy lazy = this.sync$delegate;
        return (Sync)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, User> allUsers() {
        void $this$mapTo$iv$iv;
        List nativeUsers = RealmInterop.INSTANCE.realm_app_get_all_users(this.nativePointer);
        Map map = new LinkedHashMap();
        Iterable $this$map$iv = nativeUsers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ptr;
            NativePointer nativePointer = (NativePointer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserImpl user = new UserImpl((NativePointer<RealmUserT>)ptr, this);
            map.put(user.getIdentity(), user);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object login(@NotNull Credentials var1_1, @NotNull Continuation<? super User> var2_2) {
        if (!(var2_2 instanceof login.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AppImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.login(null, (Continuation<? super User>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$use$iv = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
                $i$f$use = false;
                channel = $this$use$iv;
                $i$a$-use-AppImpl$login$2 = false;
                var7_12 = credentials;
                if (var7_12 instanceof CredentialsImpl) {
                    v0 = ((CredentialsImpl)credentials).getNativePointer$io_realm_kotlin_library();
                } else if (var7_12 instanceof CustomEJsonCredentialsImpl) {
                    v0 = ((CustomEJsonCredentialsImpl)credentials).nativePointer(this);
                } else {
                    throw new IllegalArgumentException("Argument 'credentials' is of an invalid type " + Reflection.getOrCreateKotlinClass(credentials.getClass()).getSimpleName());
                }
                RealmInterop.INSTANCE.realm_app_log_in_with_credentials(this.nativePointer, v0, RealmSyncUtilsKt.channelResultCallback(channel, (Function1)new Function1<NativePointer<RealmUserT>, User>(this){
                    final /* synthetic */ AppImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final User invoke(@NotNull NativePointer<RealmUserT> userPointer) {
                        Intrinsics.checkNotNullParameter(userPointer, (String)"userPointer");
                        return new UserImpl(userPointer, this.this$0);
                    }
                }));
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.label = 1;
                v1 = channel.receive((Continuation)$continuation);
                ** if (v1 != var14_5) goto lbl33
lbl32:
                // 1 sources

                return var14_5;
lbl33:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-AppImpl$login$2 = false;
                $this$use$iv = (Channel)$continuation.L$1;
                this = (AppImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl43:
                    // 2 sources

                    var7_12 = ((Result)v1).unbox-impl();
                    ResultKt.throwOnFailure((Object)var7_12);
                    user = (User)var7_12;
                    $i$a$-also-AppImpl$login$2$2 = false;
                    this.reportAuthenticationChange$io_realm_kotlin_library(user, User.State.LOGGED_IN);
                    var11_15 = var7_12;
                    return var11_15;
                }
                catch (Throwable var10_16) {
                    throw var10_16;
                }
                finally {
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)$this$use$iv), null, (int)1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void reportAuthenticationChange$io_realm_kotlin_library(@NotNull User user, @NotNull User.State change) {
        AuthenticationChange authenticationChange;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
        switch (WhenMappings.$EnumSwitchMapping$0[change.ordinal()]) {
            case 1: {
                authenticationChange = new LoggedOutImpl(user);
                break;
            }
            case 2: {
                authenticationChange = new LoggedInImpl(user);
                break;
            }
            case 3: {
                authenticationChange = new RemovedImpl(user);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AuthenticationChange event = authenticationChange;
        if (!this.authenticationChangeFlow.tryEmit((Object)event)) {
            throw new IllegalStateException("It wasn't possible to emit authentication changes because a consuming flow was blocked. Increase dispatcher processing resources or buffer `App.authenticationChangeAsFlow()` with buffer(...).");
        }
    }

    @Override
    @NotNull
    public Flow<AuthenticationChange> authenticationChangeAsFlow() {
        return (Flow)this.authenticationChangeFlow;
    }

    @Override
    public void close() {
        this.networkTransport.close();
        this.nativePointer.release();
        NetworkStateObserver.INSTANCE.removeListener(this.connectionListener);
    }

    private static final void connectionListener$lambda$0(AppImpl this$0, boolean connectionAvailable) {
        block3: {
            long now;
            block4: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                RealmLog.INSTANCE.debug$io_realm_kotlin_library("Network state change detected. ConnectionAvailable = " + connectionAvailable, new Object[0]);
                now = RealmInstantImplKt.toDuration((RealmInstant)RealmInstant.Companion.now());
                if (!connectionAvailable) break block3;
                if (this$0.lastOnlineStateReported == null) break block4;
                Duration duration = this$0.lastOnlineStateReported;
                Intrinsics.checkNotNull((Object)duration);
                if (Duration.compareTo-LRDsOJo((long)Duration.minus-LRDsOJo((long)now, (long)duration.unbox-impl()), (long)this$0.reconnectThreshold) <= 0) break block3;
            }
            RealmLog.INSTANCE.info$io_realm_kotlin_library("Trigger network reconnect.", new Object[0]);
            try {
                this$0.getSync().reconnect();
            }
            catch (Exception ex) {
                RealmLog.INSTANCE.error$io_realm_kotlin_library(ex.toString(), new Object[0]);
            }
            this$0.lastOnlineStateReported = Duration.box-impl((long)now);
        }
        this$0.lastConnectedState = connectionAvailable;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/mongodb/internal/AppImpl$Companion;", "", "()V", "create", "Lio/realm/kotlin/mongodb/App;", "appId", "", "bundleId", "create$io_realm_kotlin_library", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final App create$io_realm_kotlin_library(@NotNull String appId, @NotNull String bundleId) {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
            Validation.INSTANCE.checkEmpty(appId, "appId");
            return App.Companion.create(new AppConfiguration.Builder(appId).build(bundleId));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[User.State.values().length];
            try {
                nArray[User.State.LOGGED_OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[User.State.LOGGED_IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[User.State.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

