/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb;

import io.realm.kotlin.annotations.ExperimentalRealmSerializerApi;
import io.realm.kotlin.mongodb.AuthenticationProvider;
import io.realm.kotlin.mongodb.GoogleAuthType;
import io.realm.kotlin.mongodb.internal.AppImpl;
import io.realm.kotlin.mongodb.internal.BsonEncoder;
import io.realm.kotlin.mongodb.internal.CredentialsImpl;
import io.realm.kotlin.mongodb.internal.CustomEJsonCredentialsImpl;
import io.realm.kotlin.serializers.MutableRealmIntKSerializer;
import io.realm.kotlin.serializers.RealmAnyKSerializer;
import io.realm.kotlin.serializers.RealmInstantKSerializer;
import io.realm.kotlin.serializers.RealmUUIDKSerializer;
import io.realm.kotlin.types.MutableRealmInt;
import io.realm.kotlin.types.RealmAny;
import io.realm.kotlin.types.RealmInstant;
import io.realm.kotlin.types.RealmUUID;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.Bson;
import org.mongodb.kbson.serialization.EJson;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lio/realm/kotlin/mongodb/Credentials;", "", "authenticationProvider", "Lio/realm/kotlin/mongodb/AuthenticationProvider;", "getAuthenticationProvider", "()Lio/realm/kotlin/mongodb/AuthenticationProvider;", "Companion", "io.realm.kotlin.library"})
public interface Credentials {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.Credentials$Companion.$$INSTANCE;

    @NotNull
    public AuthenticationProvider getAuthenticationProvider();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tJ\u001e\u0010\f\u001a\u00020\u0004\"\u0006\b\u0000\u0010\r\u0018\u00012\u0006\u0010\u000e\u001a\u0002H\rH\u0087\b\u00a2\u0006\u0002\u0010\u000fJ)\u0010\f\u001a\u00020\u0004\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\f\u001a\u00020\u00042\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\u0013J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\tJ\u0016\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\t\u00a8\u0006!"}, d2={"Lio/realm/kotlin/mongodb/Credentials$Companion;", "", "()V", "anonymous", "Lio/realm/kotlin/mongodb/Credentials;", "reuseExisting", "", "apiKey", "key", "", "apple", "idToken", "customFunction", "T", "payload", "(Ljava/lang/Object;)Lio/realm/kotlin/mongodb/Credentials;", "serializer", "Lkotlinx/serialization/KSerializer;", "(Ljava/lang/Object;Lkotlinx/serialization/KSerializer;)Lio/realm/kotlin/mongodb/Credentials;", "", "Lorg/mongodb/kbson/BsonDocument;", "customFunctionInternal", "emailPassword", "email", "password", "facebook", "accessToken", "google", "token", "type", "Lio/realm/kotlin/mongodb/GoogleAuthType;", "jwt", "jwtToken", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Credentials anonymous(boolean reuseExisting) {
            return new CredentialsImpl(CredentialsImpl.Companion.anonymous$io_realm_kotlin_library(reuseExisting));
        }

        public static /* synthetic */ Credentials anonymous$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return companion.anonymous(bl);
        }

        @NotNull
        public final Credentials emailPassword(@NotNull String email, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new CredentialsImpl(CredentialsImpl.Companion.emailPassword$io_realm_kotlin_library(email, password));
        }

        @NotNull
        public final Credentials apiKey(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new CredentialsImpl(CredentialsImpl.Companion.apiKey$io_realm_kotlin_library(key));
        }

        @NotNull
        public final Credentials apple(@NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            return new CredentialsImpl(CredentialsImpl.Companion.apple$io_realm_kotlin_library(idToken));
        }

        @NotNull
        public final Credentials facebook(@NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return new CredentialsImpl(CredentialsImpl.Companion.facebook$io_realm_kotlin_library(accessToken));
        }

        @NotNull
        public final Credentials google(@NotNull String token, @NotNull GoogleAuthType type) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new CredentialsImpl(CredentialsImpl.Companion.google$io_realm_kotlin_library(token, type));
        }

        @NotNull
        public final Credentials jwt(@NotNull String jwtToken) {
            Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
            return new CredentialsImpl(CredentialsImpl.Companion.jwt$io_realm_kotlin_library(jwtToken));
        }

        @NotNull
        public final Credentials customFunction(@NotNull BsonDocument payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            return this.customFunctionInternal(payload);
        }

        @NotNull
        public final Credentials customFunction(@NotNull Map<String, ?> payload) {
            Intrinsics.checkNotNullParameter(payload, (String)"payload");
            return this.customFunctionInternal(payload);
        }

        private final Credentials customFunctionInternal(Object payload) {
            BsonValue bsonValue = BsonEncoder.INSTANCE.encodeToBsonValue(payload);
            boolean bl = false;
            if (!(bsonValue.getBsonType() == BsonType.DOCUMENT)) {
                boolean bl2 = false;
                String string = "Invalid payload type '" + Reflection.getOrCreateKotlinClass(payload.getClass()).getSimpleName() + "', only BsonDocument and maps are supported.";
                throw new IllegalArgumentException(string.toString());
            }
            return new CredentialsImpl(CredentialsImpl.Companion.customFunction(Bson.INSTANCE.toJson(bsonValue)));
        }

        @ExperimentalRealmSerializerApi
        @NotNull
        public final <T> Credentials customFunction(T payload, @NotNull KSerializer<T> serializer) {
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            return new CustomEJsonCredentialsImpl((Function1<? super AppImpl, String>)((Function1)new Function1<AppImpl, String>(serializer, payload){
                final /* synthetic */ KSerializer<T> $serializer;
                final /* synthetic */ T $payload;
                {
                    this.$serializer = $serializer;
                    this.$payload = $payload;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull AppImpl app) {
                    Intrinsics.checkNotNullParameter((Object)app, (String)"app");
                    return app.getConfiguration().getEjson().encodeToString((SerializationStrategy)this.$serializer, this.$payload);
                }
            }));
        }

        @ExperimentalRealmSerializerApi
        public final /* synthetic */ <T> Credentials customFunction(T payload) {
            boolean $i$f$customFunction = false;
            Intrinsics.needClassReification();
            return new CustomEJsonCredentialsImpl((Function1<? super AppImpl, String>)((Function1)new Function1<AppImpl, String>(payload){
                final /* synthetic */ T $payload;
                {
                    this.$payload = $payload;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull AppImpl app) {
                    KSerializer kSerializer;
                    Intrinsics.checkNotNullParameter((Object)app, (String)"app");
                    EJson eJson = app.getConfiguration().getEjson();
                    T t = this.$payload;
                    EJson $this$invoke_u24lambda_u240 = eJson;
                    boolean bl = false;
                    EJson eJson2 = app.getConfiguration().getEjson();
                    SerializersModule $this$serializerOrRealmBuiltInSerializer$iv = $this$invoke_u24lambda_u240.getSerializersModule();
                    boolean $i$f$serializerOrRealmBuiltInSerializer = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MutableRealmInt.class))) {
                        kSerializer = (KSerializer)MutableRealmIntKSerializer.INSTANCE;
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmUUID.class))) {
                        kSerializer = (KSerializer)RealmUUIDKSerializer.INSTANCE;
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmInstant.class))) {
                        kSerializer = (KSerializer)RealmInstantKSerializer.INSTANCE;
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(RealmAny.class))) {
                        kSerializer = (KSerializer)RealmAnyKSerializer.INSTANCE;
                    } else {
                        SerializersModule $this$serializer$iv$iv = $this$serializerOrRealmBuiltInSerializer$iv;
                        boolean $i$f$serializer = false;
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, null);
                        boolean $i$f$cast = false;
                        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        kSerializer = $this$cast$iv$iv$iv;
                    }
                    Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of io.realm.kotlin.mongodb.internal.RealmSyncUtilsKt.serializerOrRealmBuiltInSerializer>");
                    return eJson2.encodeToString((SerializationStrategy)kSerializer, t);
                }
            }));
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

