/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.sync;

import io.realm.kotlin.Configuration;
import io.realm.kotlin.LogConfiguration;
import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.internal.ConfigurationImpl;
import io.realm.kotlin.internal.ContextLogger;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.ObjectIdImpl;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmUserT;
import io.realm.kotlin.internal.interop.SchemaMode;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.internal.util.CoroutineDispatcherFactory;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLog;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.mongodb.User;
import io.realm.kotlin.mongodb.exceptions.ClientResetRequiredException;
import io.realm.kotlin.mongodb.exceptions.SyncException;
import io.realm.kotlin.mongodb.internal.SyncConfigurationImpl;
import io.realm.kotlin.mongodb.internal.UserImpl;
import io.realm.kotlin.mongodb.sync.InitialRemoteDataConfiguration;
import io.realm.kotlin.mongodb.sync.InitialSubscriptionsCallback;
import io.realm.kotlin.mongodb.sync.InitialSubscriptionsConfiguration;
import io.realm.kotlin.mongodb.sync.RecoverOrDiscardUnsyncedChangesStrategy;
import io.realm.kotlin.mongodb.sync.SyncClientResetStrategy;
import io.realm.kotlin.mongodb.sync.SyncMode;
import io.realm.kotlin.mongodb.sync.SyncSession;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.ObjectId;
import io.realm.kotlin.types.RealmUUID;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBinarySubType;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "Lio/realm/kotlin/Configuration;", "errorHandler", "Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "getErrorHandler", "()Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "initialRemoteData", "Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "getInitialRemoteData", "()Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "initialSubscriptions", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "getInitialSubscriptions", "()Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "syncClientResetStrategy", "Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "getSyncClientResetStrategy", "()Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "syncMode", "Lio/realm/kotlin/mongodb/sync/SyncMode;", "getSyncMode", "()Lio/realm/kotlin/mongodb/sync/SyncMode;", "user", "Lio/realm/kotlin/mongodb/User;", "getUser", "()Lio/realm/kotlin/mongodb/User;", "Builder", "Companion", "io.realm.kotlin.library"})
public interface SyncConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.mongodb.sync.SyncConfiguration$Companion.$$INSTANCE;

    @NotNull
    public User getUser();

    @NotNull
    public SyncSession.ErrorHandler getErrorHandler();

    @NotNull
    public SyncClientResetStrategy getSyncClientResetStrategy();

    @NotNull
    public SyncMode getSyncMode();

    @Nullable
    public InitialSubscriptionsConfiguration getInitialSubscriptions();

    @Nullable
    public InitialRemoteDataConfiguration getInitialRemoteData();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\fB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\r\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u000eB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000f\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0010B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0011\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0012B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0013\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0014B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0015\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\u0016B/\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010&\u001a\u00020\u0002H\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010'\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u000e\u0010\"\u001a\u00020\u00002\u0006\u00102\u001a\u00020#J\u001d\u00103\u001a\u00020\u00002\b\b\u0002\u00104\u001a\u000205\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0015X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder;", "Lio/realm/kotlin/Configuration$SharedBuilder;", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "user", "Lio/realm/kotlin/mongodb/User;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "(Lio/realm/kotlin/mongodb/User;Ljava/util/Set;)V", "partitionValue", "Lio/realm/kotlin/types/ObjectId;", "(Lio/realm/kotlin/mongodb/User;Lio/realm/kotlin/types/ObjectId;Ljava/util/Set;)V", "Lorg/mongodb/kbson/BsonObjectId;", "(Lio/realm/kotlin/mongodb/User;Lorg/mongodb/kbson/BsonObjectId;Ljava/util/Set;)V", "Lio/realm/kotlin/types/RealmUUID;", "(Lio/realm/kotlin/mongodb/User;Lio/realm/kotlin/types/RealmUUID;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Integer;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Long;Ljava/util/Set;)V", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/String;Ljava/util/Set;)V", "Lorg/mongodb/kbson/BsonValue;", "(Lio/realm/kotlin/mongodb/User;Ljava/util/Set;Lorg/mongodb/kbson/BsonValue;)V", "errorHandler", "Lio/realm/kotlin/mongodb/sync/SyncSession$ErrorHandler;", "initialSubscriptions", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsConfiguration;", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "syncClientResetStrategy", "Lio/realm/kotlin/mongodb/sync/SyncClientResetStrategy;", "waitForServerChanges", "Lio/realm/kotlin/mongodb/sync/InitialRemoteDataConfiguration;", "build", "getAbsolutePath", "rerunOnOpen", "", "initialSubscriptionBlock", "Lio/realm/kotlin/mongodb/sync/InitialSubscriptionsCallback;", "log", "level", "Lio/realm/kotlin/log/LogLevel;", "customLoggers", "", "Lio/realm/kotlin/log/RealmLogger;", "resetStrategy", "waitForInitialRemoteData", "timeout", "Lkotlin/time/Duration;", "waitForInitialRemoteData-LRDsOJo", "(J)Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder;", "io.realm.kotlin.library"})
    @SourceDebugExtension(value={"SMAP\nSyncConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncConfiguration.kt\nio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,721:1\n1#2:722\n1855#3,2:723\n*S KotlinDebug\n*F\n+ 1 SyncConfiguration.kt\nio/realm/kotlin/mongodb/sync/SyncConfiguration$Builder\n*L\n546#1:723,2\n*E\n"})
    public static final class Builder
    extends Configuration.SharedBuilder<SyncConfiguration, Builder> {
        @NotNull
        private User user;
        @Nullable
        private BsonValue partitionValue;
        @Nullable
        private String name;
        @Nullable
        private SyncSession.ErrorHandler errorHandler;
        @Nullable
        private SyncClientResetStrategy syncClientResetStrategy;
        @Nullable
        private InitialSubscriptionsConfiguration initialSubscriptions;
        @Nullable
        private InitialRemoteDataConfiguration waitForServerChanges;

        private Builder(User user, Set<? extends KClass<? extends BaseRealmObject>> schema, BsonValue partitionValue) {
            block1: {
                super(schema);
                this.user = user;
                this.partitionValue = partitionValue;
                if (!this.user.getLoggedIn()) {
                    throw new IllegalArgumentException("A valid, logged in user is required.");
                }
                User user2 = this.user;
                Intrinsics.checkNotNull((Object)user2, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                LogConfiguration logConfiguration = ((UserImpl)user2).getApp().getConfiguration().getLogger();
                if (logConfiguration == null) break block1;
                LogConfiguration appLog = logConfiguration;
                boolean bl = false;
                this.setLogLevel(appLog.getLevel());
                this.setAppConfigLoggers(appLog.getLoggers());
            }
        }

        @Nullable
        protected String getName() {
            return this.name;
        }

        protected void setName(@Nullable String string) {
            this.name = string;
        }

        public Builder(@NotNull User user, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(user, schema, null);
        }

        /*
         * Unable to fully structure code
         */
        public Builder(@NotNull User user, @Nullable ObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            v0 = this;
            v1 = user;
            v2 = schema;
            v3 = partitionValue;
            if (v3 == null) ** GOTO lbl-1000
            var4_4 = v3;
            var8_5 = v2;
            var7_6 = v1;
            var6_7 = v0;
            $i$a$-let-SyncConfiguration$Builder$1 = false;
            var9_9 = BsonObjectId.Companion.invoke(((ObjectIdImpl)it).getBytes());
            v0 = var6_7;
            v1 = var7_6;
            v2 = var8_5;
            v4 = var9_9;
            v3 = v4;
            if (v4 != null) {
                v5 = (BsonValue)v3;
            } else lbl-1000:
            // 2 sources

            {
                v5 = (BsonValue)BsonNull.INSTANCE;
            }
            v0(v1, v2, v5);
        }

        public Builder(@NotNull User user, @Nullable BsonObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            BsonObjectId bsonObjectId = partitionValue;
            this(user, schema, bsonObjectId != null ? (BsonValue)bsonObjectId : (BsonValue)BsonNull.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable RealmUUID partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            RealmUUID realmUUID = partitionValue;
            if (realmUUID != null) {
                void it;
                RealmUUID realmUUID2 = realmUUID;
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonBinary bsonBinary = new BsonBinary(BsonBinarySubType.UUID_STANDARD, it.getBytes());
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonBinary;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable Integer partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            Integer n = partitionValue;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonInt32 bsonInt32 = new BsonInt32((int)it);
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonInt32;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable Long partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            Long l = partitionValue;
            if (l != null) {
                void it;
                long l2 = ((Number)l).longValue();
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonInt64 bsonInt64 = new BsonInt64((long)it);
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonInt64;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull User user, @Nullable String partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            BsonValue bsonValue;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Builder builder = this;
            User user2 = user;
            Set<? extends KClass<? extends BaseRealmObject>> set = schema;
            String string = partitionValue;
            if (string != null) {
                void it;
                String string2 = string;
                Set<? extends KClass<? extends BaseRealmObject>> set2 = set;
                User user3 = user2;
                Builder builder2 = builder;
                boolean bl = false;
                BsonString bsonString = new BsonString((String)it);
                builder = builder2;
                user2 = user3;
                set = set2;
                bsonValue = (BsonValue)bsonString;
            } else {
                bsonValue = (BsonValue)BsonNull.INSTANCE;
            }
            builder(user2, set, bsonValue);
        }

        @NotNull
        public final Builder errorHandler(@NotNull SyncSession.ErrorHandler errorHandler) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
            Builder $this$errorHandler_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$errorHandler_u24lambda_u246.errorHandler = errorHandler;
            return builder;
        }

        @NotNull
        public final Builder syncClientResetStrategy(@NotNull SyncClientResetStrategy resetStrategy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resetStrategy, (String)"resetStrategy");
            Builder $this$syncClientResetStrategy_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$syncClientResetStrategy_u24lambda_u247.syncClientResetStrategy = resetStrategy;
            return builder;
        }

        @NotNull
        public Builder log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            Builder $this$log_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$log_u24lambda_u248.setLogLevel(level);
            $this$log_u24lambda_u248.setRealmConfigLoggers(customLoggers);
            return builder;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$name_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$name_u24lambda_u249.checkName(name);
            $this$name_u24lambda_u249.setName(name);
            return builder;
        }

        @NotNull
        public final Builder waitForInitialRemoteData-LRDsOJo(long timeout) {
            Builder builder;
            Builder $this$waitForInitialRemoteData_LRDsOJo_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$waitForInitialRemoteData_LRDsOJo_u24lambda_u2410.waitForServerChanges = new InitialRemoteDataConfiguration(timeout, null);
            return builder;
        }

        public static /* synthetic */ Builder waitForInitialRemoteData-LRDsOJo$default(Builder builder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = Duration.Companion.getINFINITE-UwyO8pc();
            }
            return builder.waitForInitialRemoteData-LRDsOJo(l);
        }

        @NotNull
        public final Builder initialSubscriptions(boolean rerunOnOpen, @NotNull InitialSubscriptionsCallback initialSubscriptionBlock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)initialSubscriptionBlock, (String)"initialSubscriptionBlock");
            Builder $this$initialSubscriptions_u24lambda_u2411 = builder = this;
            boolean bl = false;
            if ($this$initialSubscriptions_u24lambda_u2411.partitionValue != null) {
                throw new IllegalStateException("Defining initial subscriptions is only available if the configuration is for Flexible Sync.");
            }
            $this$initialSubscriptions_u24lambda_u2411.initialSubscriptions = new InitialSubscriptionsConfiguration(initialSubscriptionBlock, rerunOnOpen);
            return builder;
        }

        public static /* synthetic */ Builder initialSubscriptions$default(Builder builder, boolean bl, InitialSubscriptionsCallback initialSubscriptionsCallback, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return builder.initialSubscriptions(bl, initialSubscriptionsCallback);
        }

        @NotNull
        public SyncConfiguration build() {
            CoroutineDispatcherFactory coroutineDispatcherFactory;
            CoroutineDispatcherFactory coroutineDispatcherFactory2;
            ContextLogger realmLogger = new ContextLogger("Sdk");
            if (this.errorHandler == null) {
                this.errorHandler = new SyncSession.ErrorHandler(realmLogger){
                    final /* synthetic */ ContextLogger $realmLogger;
                    {
                        this.$realmLogger = $realmLogger;
                    }

                    public void onError(@NotNull SyncSession session2, @NotNull SyncException error) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                            String string = error.getMessage();
                            if (string == null) break block0;
                            String string2 = string;
                            ContextLogger contextLogger = this.$realmLogger;
                            String it = string2;
                            boolean bl = false;
                            contextLogger.warn(it, new Object[0]);
                        }
                    }
                };
            }
            if (this.syncClientResetStrategy == null) {
                this.syncClientResetStrategy = new RecoverOrDiscardUnsyncedChangesStrategy(realmLogger){
                    final /* synthetic */ ContextLogger $realmLogger;
                    {
                        this.$realmLogger = $realmLogger;
                    }

                    public void onBeforeReset(@NotNull TypedRealm realm) {
                        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
                        this.$realmLogger.info("Client reset: attempting to automatically recover unsynced changes in Realm: " + realm.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onAfterRecovery(@NotNull TypedRealm before, @NotNull MutableRealm after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        this.$realmLogger.info("Client reset: successfully recovered all unsynced changes in Realm: " + after.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onAfterDiscard(@NotNull TypedRealm before, @NotNull MutableRealm after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        this.$realmLogger.info("Client reset: couldn't recover successfully, all unsynced changes were discarded in Realm: " + after.getConfiguration().getPath(), new Object[0]);
                    }

                    public void onManualResetFallback(@NotNull SyncSession session2, @NotNull ClientResetRequiredException exception) {
                        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        this.$realmLogger.error("Client reset: manual reset required for Realm in '" + exception.getOriginalFilePath() + '\'', new Object[0]);
                    }
                };
            }
            if (this.partitionValue == null && this.getName() == null) {
                this.setName("default.realm");
            }
            String fullPathToFile = this.getAbsolutePath(this.getName());
            String fileName = StringsKt.substringAfterLast$default((String)fullPathToFile, (String)SystemUtilsKt.getPATH_SEPARATOR(), null, (int)2, null);
            String directory = StringsKt.removeSuffix((String)fullPathToFile, (CharSequence)(SystemUtilsKt.getPATH_SEPARATOR() + fileName));
            RealmLog.INSTANCE.setLevel(this.getLogLevel());
            Iterable $this$forEach$iv = this.getRealmConfigLoggers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RealmLogger it = (RealmLogger)element$iv;
                boolean bl = false;
                RealmLog.INSTANCE.add(it);
            }
            List allLoggers = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object)RealmLog.INSTANCE.getSystemLoggerInstalled$io_realm_kotlin_library())), (Iterable)this.getAppConfigLoggers()), (Iterable)this.getRealmConfigLoggers());
            Set set = this.getSchema();
            LogConfiguration logConfiguration = new LogConfiguration(this.getLogLevel(), allLoggers);
            long l = this.getMaxNumberOfActiveVersions();
            if (this.getNotificationDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getNotificationDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory2 = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory2 = CoroutineDispatcherFactory.Companion.managed$default((CoroutineDispatcherFactory.Companion)CoroutineDispatcherFactory.Companion, (String)("notifier-" + fileName), (int)0, (int)2, null);
            }
            if (this.getWriteDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getWriteDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default((CoroutineDispatcherFactory.Companion)CoroutineDispatcherFactory.Companion, (String)("writer-" + fileName), (int)0, (int)2, null);
            }
            ConfigurationImpl baseConfiguration = new ConfigurationImpl(directory, fileName, set, logConfiguration, l, coroutineDispatcherFactory2, coroutineDispatcherFactory, this.getSchemaVersion(), SchemaMode.RLM_SCHEMA_MODE_ADDITIVE_DISCOVERED, this.getEncryptionKey(), this.getCompactOnLaunchCallback(), null, false, this.getInitialDataCallback(), this.partitionValue == null, this.getInMemory(), this.getInitialRealmFileConfiguration(), realmLogger);
            InternalConfiguration internalConfiguration = (InternalConfiguration)baseConfiguration;
            User user = this.user;
            Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
            UserImpl userImpl = (UserImpl)user;
            SyncSession.ErrorHandler errorHandler = this.errorHandler;
            Intrinsics.checkNotNull((Object)errorHandler);
            SyncClientResetStrategy syncClientResetStrategy = this.syncClientResetStrategy;
            Intrinsics.checkNotNull((Object)syncClientResetStrategy);
            return new SyncConfigurationImpl(internalConfiguration, this.partitionValue, userImpl, errorHandler, syncClientResetStrategy, this.initialSubscriptions, this.waitForServerChanges);
        }

        private final String getAbsolutePath(String name) {
            NativePointer nativePointer;
            boolean bl;
            boolean bl2 = bl = this.partitionValue == null;
            if (bl) {
                User user = this.user;
                Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                nativePointer = RealmInterop.INSTANCE.realm_flx_sync_config_new(((UserImpl)user).getNativePointer());
            } else if (!bl) {
                User user = this.user;
                Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
                NativePointer<RealmUserT> nativePointer2 = ((UserImpl)user).getNativePointer();
                BsonValue bsonValue = this.partitionValue;
                Intrinsics.checkNotNull((Object)bsonValue);
                nativePointer = RealmInterop.INSTANCE.realm_sync_config_new(nativePointer2, bsonValue.toJson());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            NativePointer auxSyncConfig = nativePointer;
            boolean bl3 = false;
            User user = this.user;
            Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type io.realm.kotlin.mongodb.internal.UserImpl");
            String absolutePath = RealmInterop.INSTANCE.realm_app_sync_client_get_default_file_path_for_realm(((UserImpl)user).getApp().getNativePointer$io_realm_kotlin_library(), auxSyncConfig, name);
            return name != null ? StringsKt.removeSuffix((String)absolutePath, (CharSequence)".realm") : absolutePath;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nJ.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\r2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nJ3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00102\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\u0011J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00122\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nJ$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a8\u0006\u0013"}, d2={"Lio/realm/kotlin/mongodb/sync/SyncConfiguration$Companion;", "", "()V", "create", "Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "user", "Lio/realm/kotlin/mongodb/User;", "partitionValue", "Lio/realm/kotlin/types/ObjectId;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/types/RealmUUID;", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Integer;Ljava/util/Set;)Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "", "(Lio/realm/kotlin/mongodb/User;Ljava/lang/Long;Ljava/util/Set;)Lio/realm/kotlin/mongodb/sync/SyncConfiguration;", "", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable String partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable Integer partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable Long partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable ObjectId partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        @NotNull
        public final SyncConfiguration create(@NotNull User user, @Nullable RealmUUID partitionValue, @NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(user, partitionValue, schema).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

