/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.mongodb.internal;

import io.realm.kotlin.BaseRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.internal.RealmInstantImpl;
import io.realm.kotlin.internal.RealmObjectCompanion;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmBaseSubscriptionSet;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSubscriptionT;
import io.realm.kotlin.internal.platform.RealmObjectKt;
import io.realm.kotlin.mongodb.sync.Subscription;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.types.RealmInstant;
import io.realm.kotlin.types.RealmObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonObjectId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ&\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020,H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\b\u001a\f\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u0004\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000f\u00a8\u0006-"}, d2={"Lio/realm/kotlin/mongodb/internal/SubscriptionImpl;", "Lio/realm/kotlin/mongodb/sync/Subscription;", "realm", "Lio/realm/kotlin/BaseRealm;", "parentNativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmBaseSubscriptionSet;", "Lio/realm/kotlin/internal/interop/RealmBaseSubscriptionSetPointer;", "nativePointer", "Lio/realm/kotlin/internal/interop/RealmSubscriptionT;", "Lio/realm/kotlin/internal/interop/RealmSubscriptionPointer;", "(Lio/realm/kotlin/BaseRealm;Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/interop/NativePointer;)V", "createdAt", "Lio/realm/kotlin/types/RealmInstant;", "getCreatedAt", "()Lio/realm/kotlin/types/RealmInstant;", "id", "Lorg/mongodb/kbson/BsonObjectId;", "Lorg/mongodb/kbson/ObjectId;", "getId", "()Lorg/mongodb/kbson/BsonObjectId;", "name", "", "getName", "()Ljava/lang/String;", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "objectType", "getObjectType", "queryDescription", "getQueryDescription", "updatedAt", "getUpdatedAt", "asQuery", "Lio/realm/kotlin/query/RealmQuery;", "T", "Lio/realm/kotlin/types/RealmObject;", "type", "Lkotlin/reflect/KClass;", "equals", "", "other", "", "hashCode", "", "io.realm.kotlin.library"})
public final class SubscriptionImpl
implements Subscription {
    @NotNull
    private final BaseRealm realm;
    @NotNull
    private final NativePointer<? extends RealmBaseSubscriptionSet> parentNativePointer;
    @NotNull
    private final NativePointer<RealmSubscriptionT> nativePointer;
    @NotNull
    private final BsonObjectId id;
    @NotNull
    private final RealmInstant createdAt;
    @NotNull
    private final RealmInstant updatedAt;
    @Nullable
    private final String name;
    @NotNull
    private final String objectType;
    @NotNull
    private final String queryDescription;

    public SubscriptionImpl(@NotNull BaseRealm realm, @NotNull NativePointer<? extends RealmBaseSubscriptionSet> parentNativePointer, @NotNull NativePointer<RealmSubscriptionT> nativePointer) {
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(parentNativePointer, (String)"parentNativePointer");
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        this.realm = realm;
        this.parentNativePointer = parentNativePointer;
        this.nativePointer = nativePointer;
        this.id = RealmInterop.INSTANCE.realm_sync_subscription_id(this.nativePointer);
        this.createdAt = (RealmInstant)new RealmInstantImpl(RealmInterop.INSTANCE.realm_sync_subscription_created_at(this.nativePointer));
        this.updatedAt = (RealmInstant)new RealmInstantImpl(RealmInterop.INSTANCE.realm_sync_subscription_updated_at(this.nativePointer));
        this.name = RealmInterop.INSTANCE.realm_sync_subscription_name(this.nativePointer);
        this.objectType = RealmInterop.INSTANCE.realm_sync_subscription_object_class_name(this.nativePointer);
        this.queryDescription = RealmInterop.INSTANCE.realm_sync_subscription_query_string(this.nativePointer);
    }

    @NotNull
    public final NativePointer<RealmSubscriptionT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @Override
    @NotNull
    public BsonObjectId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public RealmInstant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @NotNull
    public RealmInstant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    @NotNull
    public String getQueryDescription() {
        return this.queryDescription;
    }

    @Override
    @NotNull
    public <T extends RealmObject> RealmQuery<T> asQuery(@NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (this.realm instanceof TypedRealm) {
            RealmObjectCompanion companion = RealmObjectKt.realmObjectCompanionOrThrow(type);
            String userTypeName = companion.getIo_realm_kotlin_className();
            if (!Intrinsics.areEqual((Object)userTypeName, (Object)this.getObjectType())) {
                throw new IllegalArgumentException("Wrong query type. This subscription is for objects of type: " + this.getObjectType() + ", but " + userTypeName + " was provided as input.");
            }
        } else {
            throw new IllegalStateException("Unsupported Realm type: " + Reflection.getOrCreateKotlinClass(this.realm.getClass()));
        }
        return ((TypedRealm)this.realm).query(type, this.getQueryDescription(), new Object[0]);
    }

    public boolean equals(@Nullable Object other) {
        BsonObjectId otherId;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SubscriptionImpl cfr_ignored_0 = (SubscriptionImpl)other;
        long version = RealmInterop.INSTANCE.realm_sync_subscriptionset_version(this.parentNativePointer);
        long otherVersion = RealmInterop.INSTANCE.realm_sync_subscriptionset_version(((SubscriptionImpl)other).parentNativePointer);
        if (version != otherVersion) {
            return false;
        }
        BsonObjectId id = RealmInterop.INSTANCE.realm_sync_subscription_id(this.nativePointer);
        return Intrinsics.areEqual((Object)id, (Object)(otherId = RealmInterop.INSTANCE.realm_sync_subscription_id(this.nativePointer)));
    }

    public int hashCode() {
        BsonObjectId id = RealmInterop.INSTANCE.realm_sync_subscription_id(this.nativePointer);
        long version = RealmInterop.INSTANCE.realm_sync_subscriptionset_version(this.parentNativePointer);
        int result2 = id.hashCode();
        result2 = 31 * result2 + (int)version;
        return result2;
    }
}

