/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.MutableRealm;
import io.realm.RealmObject;
import io.realm.VersionId;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmReference;
import io.realm.interop.Link;
import io.realm.interop.NativePointer;
import io.realm.interop.RealmInterop;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u0003*\u00020\u00032\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\fH\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0003H\u0002\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0003\u001a\n\u0010\u0012\u001a\u00020\u0011*\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0011*\u00020\u0003\u001a\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\n0\u0015\"\b\b\u0000\u0010\n*\u00020\u0003*\u0002H\n\u00a2\u0006\u0002\u0010\u0016\u001a9\u0010\u0017\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u0003*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\n0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\u0010\u001f\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"<anonymous parameter 0>", "Lio/realm/VersionId;", "version", "Lio/realm/RealmObject;", "getVersion", "(Lio/realm/RealmObject;)Lio/realm/VersionId;", "setVersion", "(Lio/realm/RealmObject;Lio/realm/VersionId;)V", "addChangeListener", "Lio/realm/Cancellable;", "T", "callback", "Lio/realm/Callback;", "checkNotificationsAvailable", "", "delete", "isFrozen", "", "isManaged", "isValid", "observe", "Lkotlinx/coroutines/flow/Flow;", "(Lio/realm/RealmObject;)Lkotlinx/coroutines/flow/Flow;", "toRealmObject", "Lio/realm/interop/Link;", "clazz", "Lkotlin/reflect/KClass;", "mediator", "Lio/realm/internal/Mediator;", "realm", "Lio/realm/internal/RealmReference;", "(Lio/realm/interop/Link;Lkotlin/reflect/KClass;Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;)Lio/realm/RealmObject;", "library"})
public final class RealmObjectKt {
    public static final boolean isFrozen(@NotNull RealmObject $this$isFrozen) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrozen, (String)"<this>");
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$isFrozen;
        NativePointer nativePointer = internalObject.get$realm$ObjectPointer();
        if (nativePointer != null) {
            NativePointer nativePointer2 = nativePointer;
            boolean bl = false;
            boolean bl2 = false;
            NativePointer it = nativePointer2;
            boolean bl3 = false;
            return RealmInterop.INSTANCE.realm_is_frozen(it);
        }
        Object var2_8 = null;
        throw new IllegalArgumentException("Cannot get version from an unmanaged object.");
    }

    @NotNull
    public static final VersionId getVersion(@NotNull RealmObject $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"<this>");
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$version;
        Object object = internalObject.get$realm$Owner();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            NativePointer dbPointer = ((RealmReference)it).getDbPointer();
            if (RealmInterop.INSTANCE.realm_is_closed(dbPointer)) {
                throw new IllegalStateException("Cannot access properties on closed realm");
            }
            return new VersionId(RealmInterop.INSTANCE.realm_get_version_id(dbPointer));
        }
        Object var2_9 = null;
        throw new IllegalArgumentException("Cannot get version from an unmanaged object.");
    }

    private static final void setVersion(RealmObject $this$version, VersionId $noName_0) {
        throw new UnsupportedOperationException("Setter is required by the Kotlin Compiler, but should not be called directly");
    }

    public static final void delete(@NotNull RealmObject $this$delete) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        MutableRealm.Companion.delete$library($this$delete);
    }

    public static final boolean isManaged(@NotNull RealmObject $this$isManaged) {
        Intrinsics.checkNotNullParameter((Object)$this$isManaged, (String)"<this>");
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$isManaged;
        return internalObject.get$realm$IsManaged();
    }

    public static final boolean isValid(@NotNull RealmObject $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        if (RealmObjectKt.isManaged($this$isValid)) {
            RealmObjectInternal internalObject = (RealmObjectInternal)$this$isValid;
            NativePointer ptr = internalObject.get$realm$ObjectPointer();
            return ptr != null ? RealmInterop.INSTANCE.realm_object_is_valid(ptr) : false;
        }
        return true;
    }

    @NotNull
    public static final <T extends RealmObject> Cancellable addChangeListener(@NotNull RealmObject $this$addChangeListener, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$addChangeListener, (String)"<this>");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        RealmObjectKt.checkNotificationsAvailable($this$addChangeListener);
        Object object = ((RealmObjectInternal)$this$addChangeListener).get$realm$Owner();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.realm.internal.RealmReference");
        }
        BaseRealm realm2 = ((RealmReference)object).getOwner();
        return realm2.registerObjectChangeListener$library($this$addChangeListener, callback);
    }

    @NotNull
    public static final <T extends RealmObject> Flow<T> observe(@NotNull T $this$observe) {
        Intrinsics.checkNotNullParameter($this$observe, (String)"<this>");
        RealmObjectKt.checkNotificationsAvailable($this$observe);
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$observe;
        Object object = internalObject.get$realm$Owner();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.realm.internal.RealmReference");
        }
        return ((RealmReference)object).getOwner().registerObjectObserver$library($this$observe);
    }

    private static final void checkNotificationsAvailable(RealmObject $this$checkNotificationsAvailable) {
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$checkNotificationsAvailable;
        RealmReference realm2 = (RealmReference)internalObject.get$realm$Owner();
        if (!RealmObjectKt.isManaged($this$checkNotificationsAvailable)) {
            throw new IllegalStateException("Changes cannot be observed on unmanaged objects.");
        }
        if (realm2 != null && RealmInterop.INSTANCE.realm_is_closed(realm2.getDbPointer())) {
            throw new IllegalStateException("Changes cannot be observed when the Realm has been closed.");
        }
        if (!RealmObjectKt.isValid($this$checkNotificationsAvailable)) {
            throw new IllegalStateException("Changes cannot be observed on objects that have been deleted from the Realm.");
        }
    }

    @NotNull
    public static final <T extends RealmObject> T toRealmObject(@NotNull Link $this$toRealmObject, @NotNull KClass<T> clazz, @NotNull Mediator mediator, @NotNull RealmReference realm2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRealmObject, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm2, (String)"realm");
        return RealmObjectUtilKt.link(mediator.createInstanceOf(clazz), realm2, mediator, clazz, $this$toRealmObject);
    }
}

