/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.RealmResults;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmUtilsKt;
import io.realm.interop.NativePointer;
import io.realm.interop.RealmInterop;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 22\u00020\u0001:\u00012B\u001b\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\bJ\r\u0010\u000b\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\b\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u0001H\u000e\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001a\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001cH\u0016J9\u0010\u001d\u001a\u00020\u001e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u000e0 2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0 0\"H\u0010\u00a2\u0006\u0002\b#J1\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0 0%\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u000e0 H\u0010\u00a2\u0006\u0002\b&J1\u0010'\u001a\u00020\u001e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u0002H\u000e2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\"H\u0010\u00a2\u0006\u0004\b(\u0010)J'\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u000e0%\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u0002H\u000eH\u0010\u00a2\u0006\u0004\b+\u0010,J9\u0010-\u001a\u00020\u001e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001a2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u001a0\"H\u0010\u00a2\u0006\u0002\b/J1\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u001a0%\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001aH\u0010\u00a2\u0006\u0002\b1\u00a8\u00063"}, d2={"Lio/realm/MutableRealm;", "Lio/realm/BaseRealm;", "configuration", "Lio/realm/RealmConfiguration;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/realm/RealmConfiguration;Lkotlinx/coroutines/CoroutineDispatcher;)V", "beginTransaction", "", "beginTransaction$library", "cancelWrite", "commitTransaction", "commitTransaction$library", "copyToRealm", "T", "Lio/realm/RealmObject;", "instance", "(Lio/realm/RealmObject;)Lio/realm/RealmObject;", "delete", "obj", "(Lio/realm/RealmObject;)V", "findLatest", "isInTransaction", "", "isInTransaction$library", "objects", "Lio/realm/RealmResults;", "clazz", "Lkotlin/reflect/KClass;", "registerListChangeListener", "Lio/realm/Cancellable;", "list", "", "callback", "Lio/realm/Callback;", "registerListChangeListener$library", "registerListObserver", "Lkotlinx/coroutines/flow/Flow;", "registerListObserver$library", "registerObjectChangeListener", "registerObjectChangeListener$library", "(Lio/realm/RealmObject;Lio/realm/Callback;)Lio/realm/Cancellable;", "registerObjectObserver", "registerObjectObserver$library", "(Lio/realm/RealmObject;)Lkotlinx/coroutines/flow/Flow;", "registerResultsChangeListener", "results", "registerResultsChangeListener$library", "registerResultsObserver", "registerResultsObserver$library", "Companion", "library"})
public final class MutableRealm
extends BaseRealm {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MutableRealm(@NotNull RealmConfiguration configuration, @Nullable CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration, RealmInterop.INSTANCE.realm_open(configuration.getNativeConfig$library(), dispatcher));
    }

    public /* synthetic */ MutableRealm(RealmConfiguration realmConfiguration, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineDispatcher = null;
        }
        this(realmConfiguration, coroutineDispatcher);
    }

    public final void beginTransaction$library() {
        RealmInterop.INSTANCE.realm_begin_write(this.getRealmReference$library().getDbPointer());
    }

    public final void commitTransaction$library() {
        RealmInterop.INSTANCE.realm_commit(this.getRealmReference$library().getDbPointer());
    }

    public final boolean isInTransaction$library() {
        return RealmInterop.INSTANCE.realm_is_in_transaction(this.getRealmReference$library().getDbPointer());
    }

    @Nullable
    public final <T extends RealmObject> T findLatest(@Nullable T obj) {
        RealmObject realmObject;
        if (obj == null || !RealmObjectKt.isValid(obj)) {
            realmObject = null;
        } else {
            if (!RealmObjectKt.isManaged(obj)) {
                throw new IllegalArgumentException("Unmanaged objects must be part of the Realm, before they can be queried this way. Use `MutableRealm.copyToRealm()` to turn it into a managed object.");
            }
            if (!RealmObjectKt.isFrozen(obj)) {
                realmObject = obj;
            } else {
                BaseRealm liveRealm = this.getRealmReference$library().getOwner();
                realmObject = RealmObjectUtilKt.thaw((RealmObjectInternal)obj, liveRealm);
            }
        }
        return (T)realmObject;
    }

    public final void cancelWrite() {
        RealmInterop.INSTANCE.realm_rollback(this.getRealmReference$library().getDbPointer());
    }

    @NotNull
    public final <T extends RealmObject> T copyToRealm(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        return (T)RealmUtilsKt.copyToRealm$default(this.getConfiguration().getMediator$library(), this.getRealmReference$library(), instance, null, 8, null);
    }

    @Override
    @NotNull
    public <T extends RealmObject> RealmResults<T> objects(@NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return super.objects(clazz);
    }

    public final <T extends RealmObject> void delete(@NotNull T obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        RealmObjectInternal internalObject = (RealmObjectInternal)obj;
        MutableRealm.Companion.checkObjectValid(internalObject);
        NativePointer nativePointer = internalObject.get$realm$ObjectPointer();
        if (nativePointer != null) {
            NativePointer nativePointer2 = nativePointer;
            boolean bl = false;
            boolean bl2 = false;
            NativePointer it = nativePointer2;
            boolean bl3 = false;
            RealmInterop.INSTANCE.realm_object_delete(it);
        }
    }

    @Override
    @NotNull
    public <T extends RealmObject> Flow<RealmResults<T>> registerResultsObserver$library(@NotNull RealmResults<T> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Flow<List<T>> registerListObserver$library(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        throw new IllegalStateException("Changes to RealmList cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Flow<T> registerObjectObserver$library(@NotNull T obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        throw new IllegalStateException("Changes to RealmObject cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Cancellable registerResultsChangeListener$library(@NotNull RealmResults<T> results, @NotNull Callback<RealmResults<T>> callback) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Cancellable registerListChangeListener$library(@NotNull List<? extends T> list, @NotNull Callback<List<T>> callback) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Cancellable registerObjectChangeListener$library(@NotNull T obj, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J!\u0010\u0007\u001a\u00020\u0004\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\u0005\u001a\u0002H\bH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/realm/MutableRealm$Companion;", "", "()V", "checkObjectValid", "", "obj", "Lio/realm/internal/RealmObjectInternal;", "delete", "T", "Lio/realm/RealmObject;", "delete$library", "(Lio/realm/RealmObject;)V", "library"})
    public static final class Companion {
        private Companion() {
        }

        public final <T extends RealmObject> void delete$library(@NotNull T obj) {
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            RealmObjectInternal internalObject = (RealmObjectInternal)obj;
            this.checkObjectValid(internalObject);
            NativePointer nativePointer = internalObject.get$realm$ObjectPointer();
            if (nativePointer != null) {
                NativePointer nativePointer2 = nativePointer;
                boolean bl = false;
                boolean bl2 = false;
                NativePointer it = nativePointer2;
                boolean bl3 = false;
                RealmInterop.INSTANCE.realm_object_delete(it);
            }
        }

        private final void checkObjectValid(RealmObjectInternal obj) {
            if (!RealmObjectKt.isValid(obj)) {
                throw new IllegalArgumentException("Cannot perform this operation on an invalid/deleted object");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

