/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.VersionId;
import io.realm.internal.RealmLog;
import io.realm.internal.RealmReference;
import io.realm.interop.NativePointer;
import io.realm.interop.RealmInterop;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 =2\u00020\u0001:\u0001=B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\n\b\u0000\u0010#\u0018\u0001*\u00020$H\u0086\bJ&\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016J9\u0010'\u001a\u00020(\"\b\b\u0000\u0010#*\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H#0*2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0*0,H\u0010\u00a2\u0006\u0002\b-J1\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0*0/\"\b\b\u0000\u0010#*\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H#0*H\u0010\u00a2\u0006\u0002\b0J1\u00101\u001a\u00020(\"\b\b\u0000\u0010#*\u00020$2\u0006\u00102\u001a\u0002H#2\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H#0,H\u0010\u00a2\u0006\u0004\b3\u00104J'\u00105\u001a\b\u0012\u0004\u0012\u0002H#0/\"\b\b\u0000\u0010#*\u00020$2\u0006\u00102\u001a\u0002H#H\u0010\u00a2\u0006\u0004\b6\u00107J9\u00108\u001a\u00020(\"\b\b\u0000\u0010#*\u00020$2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H#0\"2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\"0,H\u0010\u00a2\u0006\u0002\b:J1\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\"0/\"\b\b\u0000\u0010#*\u00020$2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H#0\"H\u0010\u00a2\u0006\u0002\b<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@PX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u00020\u00158FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006>"}, d2={"Lio/realm/BaseRealm;", "", "configuration", "Lio/realm/RealmConfiguration;", "dbPointer", "Lio/realm/interop/NativePointer;", "(Lio/realm/RealmConfiguration;Lio/realm/interop/NativePointer;)V", "getConfiguration", "()Lio/realm/RealmConfiguration;", "log", "Lio/realm/internal/RealmLog;", "getLog$library", "()Lio/realm/internal/RealmLog;", "<anonymous parameter 0>", "Lio/realm/internal/RealmReference;", "realmReference", "getRealmReference$library", "()Lio/realm/internal/RealmReference;", "setRealmReference$library", "(Lio/realm/internal/RealmReference;)V", "version", "Lio/realm/VersionId;", "getVersion", "()Lio/realm/VersionId;", "setVersion", "(Lio/realm/VersionId;)V", "close", "", "close$library", "getNumberOfActiveVersions", "", "isClosed", "", "objects", "Lio/realm/RealmResults;", "T", "Lio/realm/RealmObject;", "clazz", "Lkotlin/reflect/KClass;", "registerListChangeListener", "Lio/realm/Cancellable;", "list", "", "callback", "Lio/realm/Callback;", "registerListChangeListener$library", "registerListObserver", "Lkotlinx/coroutines/flow/Flow;", "registerListObserver$library", "registerObjectChangeListener", "obj", "registerObjectChangeListener$library", "(Lio/realm/RealmObject;Lio/realm/Callback;)Lio/realm/Cancellable;", "registerObjectObserver", "registerObjectObserver$library", "(Lio/realm/RealmObject;)Lkotlinx/coroutines/flow/Flow;", "registerResultsChangeListener", "results", "registerResultsChangeListener$library", "registerResultsObserver", "registerResultsObserver$library", "Companion", "library"})
public abstract class BaseRealm {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final RealmConfiguration configuration;
    @NotNull
    private RealmReference realmReference;
    @NotNull
    private VersionId version;
    @NotNull
    private final RealmLog log;
    @Deprecated
    @NotNull
    private static final String observablesNotSupportedMessage = "Observing changes are not supported by this Realm.";

    public BaseRealm(@NotNull RealmConfiguration configuration, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        this.configuration = configuration;
        this.realmReference = new RealmReference(this, dbPointer);
        this.version = new VersionId(0L);
        this.log = new RealmLog(null, this.configuration.getLog(), 1, null);
        this.log.info(Intrinsics.stringPlus((String)"Realm opened: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @NotNull
    public final RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public RealmReference getRealmReference$library() {
        return this.realmReference;
    }

    public void setRealmReference$library(@NotNull RealmReference $noName_0) {
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        throw new UnsupportedOperationException("BaseRealm reference should never be updated");
    }

    @NotNull
    public final VersionId getVersion() {
        return this.getRealmReference$library().version();
    }

    public final void setVersion(@NotNull VersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"<set-?>");
        this.version = versionId;
    }

    @NotNull
    public final RealmLog getLog$library() {
        return this.log;
    }

    @NotNull
    public <T extends RealmObject> RealmResults<T> objects(@NotNull KClass<T> clazz) {
        RealmReference realmReference;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        RealmReference this_$iv = realmReference = this.getRealmReference$library();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        NativePointer nativePointer = realmReference.getDbPointer();
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return RealmResults.Companion.fromQuery$library(realmReference, RealmInterop.INSTANCE.realm_query_parse(nativePointer, string, "TRUEPREDICATE", new Object[0]), clazz, this.configuration.getMediator$library());
    }

    public final /* synthetic */ <T extends RealmObject> RealmResults<T> objects() {
        boolean $i$f$objects = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.objects(Reflection.getOrCreateKotlinClass(RealmObject.class));
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerResultsChangeListener$library(@NotNull RealmResults<T> results, @NotNull Callback<RealmResults<T>> callback) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(observablesNotSupportedMessage);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerListChangeListener$library(@NotNull List<? extends T> list, @NotNull Callback<List<T>> callback) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(observablesNotSupportedMessage);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerObjectChangeListener$library(@NotNull T obj, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(observablesNotSupportedMessage);
    }

    @NotNull
    public <T extends RealmObject> Flow<RealmResults<T>> registerResultsObserver$library(@NotNull RealmResults<T> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        throw new NotImplementedError(observablesNotSupportedMessage);
    }

    @NotNull
    public <T extends RealmObject> Flow<List<T>> registerListObserver$library(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        throw new NotImplementedError(observablesNotSupportedMessage);
    }

    @NotNull
    public <T extends RealmObject> Flow<T> registerObjectObserver$library(@NotNull T obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        throw new NotImplementedError(observablesNotSupportedMessage);
    }

    public final long getNumberOfActiveVersions() {
        RealmReference reference;
        RealmReference this_$iv = reference = this.getRealmReference$library();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return RealmInterop.INSTANCE.realm_get_num_versions(reference.getDbPointer());
    }

    public final boolean isClosed() {
        return this.getRealmReference$library().isClosed();
    }

    public void close$library() {
        RealmReference reference;
        RealmReference this_$iv = reference = this.getRealmReference$library();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        RealmInterop.INSTANCE.realm_close(reference.getDbPointer());
        this.log.info(Intrinsics.stringPlus((String)"Realm closed: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/BaseRealm$Companion;", "", "()V", "observablesNotSupportedMessage", "", "library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

