/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.interop.NativePointer;
import io.realm.interop.RealmInterop;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0013\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0080\b\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001aC\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u0002H\u000b2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\u0015\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0017\u00a2\u0006\u0002\u0010\u0018\u001a=\u0010\u0015\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"REPLACED_BY_IR", "", "message", "", "checkRealmClosed", "", "realm", "Lio/realm/interop/NativePointer;", "configuration", "Lio/realm/RealmConfiguration;", "copyToRealm", "T", "Lio/realm/RealmObject;", "mediator", "Lio/realm/internal/Mediator;", "realmPointer", "instance", "cache", "", "Lio/realm/internal/RealmObjectInternal;", "(Lio/realm/internal/Mediator;Lio/realm/interop/NativePointer;Lio/realm/RealmObject;Ljava/util/Map;)Lio/realm/RealmObject;", "create", "type", "Lkotlin/reflect/KClass;", "(Lio/realm/internal/Mediator;Lio/realm/interop/NativePointer;Lkotlin/reflect/KClass;)Lio/realm/RealmObject;", "primaryKey", "", "(Lio/realm/internal/Mediator;Lio/realm/interop/NativePointer;Lkotlin/reflect/KClass;Ljava/lang/Object;)Lio/realm/RealmObject;", "library"})
public final class RealmUtilsKt {
    @NotNull
    public static final Void REPLACED_BY_IR(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static /* synthetic */ Void REPLACED_BY_IR$default(String message, int n, Object object) {
        if ((n & 1) != 0) {
            message = "This code should have been replaced by the Realm Compiler Plugin. Has the `realm-kotlin` Gradle plugin been applied to the project?";
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static final void checkRealmClosed(@NotNull NativePointer realm, @NotNull RealmConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (RealmInterop.INSTANCE.realm_is_closed(realm)) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)configuration.getPath()));
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull NativePointer realmPointer, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realmPointer, (String)"realmPointer");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getSimpleName();
        if (string == null) {
            String string2 = "Cannot get class name";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String objectType = string;
        try {
            RealmObjectInternal managedModel = mediator.createInstanceOf(type);
            long key = RealmInterop.INSTANCE.realm_find_class(realmPointer, objectType);
            return RealmObjectUtilKt.manage(managedModel, realmPointer, mediator, type, RealmInterop.INSTANCE.realm_object_create(realmPointer, key));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to create object of type '" + objectType + '\'', e);
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull NativePointer realm, @NotNull KClass<T> type, @Nullable Object primaryKey) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getSimpleName();
        if (string == null) {
            String string2 = "Cannot get class name";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String objectType = string;
        try {
            RealmObjectInternal managedModel = mediator.createInstanceOf(type);
            long key = RealmInterop.INSTANCE.realm_find_class(realm, objectType);
            return RealmObjectUtilKt.manage(managedModel, realm, mediator, type, RealmInterop.INSTANCE.realm_object_create_with_primary_key(realm, key, primaryKey));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to create object of type '" + objectType + '\'', e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends RealmObject> T copyToRealm(@NotNull Mediator mediator, @NotNull NativePointer realmPointer, @NotNull T instance, @NotNull Map<RealmObjectInternal, RealmObjectInternal> cache) {
        boolean bl;
        boolean bl2;
        Object object;
        Map<RealmObjectInternal, RealmObjectInternal> map;
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realmPointer, (String)"realmPointer");
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        if (((RealmObjectInternal)instance).get$realm$IsManaged()) {
            return instance;
        }
        RealmObjectCompanion companion = mediator.companionOf((KClass<? extends RealmObject>)Reflection.getOrCreateKotlinClass(instance.getClass()));
        List<KMutableProperty1<?, ?>> list = companion.get$realm$fields();
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.reflect.KMutableProperty1<T of io.realm.internal.RealmUtilsKt.copyToRealm, kotlin.Any?>>");
        }
        List<KMutableProperty1<?, ?>> members = list;
        KMutableProperty1<?, ?> object2 = companion.get$realm$primaryKey();
        if (object2 == null) {
            map = null;
        } else {
            object = object2;
            bl2 = false;
            bl = false;
            KMutableProperty1<?, ?> primaryKey = object;
            boolean bl3 = false;
            map = RealmUtilsKt.create(mediator, realmPointer, Reflection.getOrCreateKotlinClass(instance.getClass()), primaryKey.get(instance));
        }
        Object object3 = map;
        Map<RealmObjectInternal, RealmObjectInternal> target = object3 == null ? RealmUtilsKt.create(mediator, realmPointer, Reflection.getOrCreateKotlinClass(instance.getClass())) : object3;
        object3 = cache;
        T t = instance;
        object = (RealmObjectInternal)((Object)target);
        bl2 = false;
        object3.put(t, object);
        for (KMutableProperty1 kMutableProperty1 : members) {
            Object targetValue;
            Object object4;
            Object object5 = kMutableProperty1.get(instance);
            bl = false;
            boolean bl3 = false;
            Object sourceObject = object5;
            boolean bl5 = false;
            if (sourceObject instanceof RealmObjectInternal && !((RealmObjectInternal)sourceObject).get$realm$IsManaged()) {
                void $this$getOrPut$iv;
                Map<RealmObjectInternal, RealmObjectInternal> map2 = cache;
                Object key$iv = sourceObject;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl6 = false;
                    RealmObjectInternal answer$iv = (RealmObjectInternal)RealmUtilsKt.copyToRealm(mediator, realmPointer, (RealmObject)sourceObject, cache);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object4 = answer$iv;
                } else {
                    object4 = value$iv;
                }
            } else {
                object4 = sourceObject;
            }
            if ((object5 = (targetValue = object4)) == null) continue;
            Object object6 = object5;
            bl3 = false;
            boolean bl4 = false;
            Object it = object6;
            boolean bl8 = false;
            kMutableProperty1.set(target, it);
        }
        return (T)target;
    }

    public static /* synthetic */ RealmObject copyToRealm$default(Mediator mediator, NativePointer nativePointer, RealmObject realmObject, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            boolean bl = false;
            map = new LinkedHashMap();
        }
        return RealmUtilsKt.copyToRealm(mediator, nativePointer, realmObject, map);
    }
}

