/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.Queryable;
import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.VersionId;
import io.realm.internal.Mediator;
import io.realm.internal.NotificationToken;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmUtilsKt;
import io.realm.interop.Link;
import io.realm.interop.NativePointer;
import io.realm.interop.RealmInterop;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u0019H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u001a\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000*J/\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020+2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.H\u0016\u00a2\u0006\u0002\u0010/R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u00020\u001d8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00060"}, d2={"Lio/realm/RealmResults;", "T", "Lio/realm/RealmObject;", "Lkotlin/collections/AbstractList;", "Lio/realm/Queryable;", "realmConfiguration", "Lio/realm/RealmConfiguration;", "realm", "Lio/realm/interop/NativePointer;", "queryPointer", "Lkotlin/Function0;", "clazz", "Lkotlin/reflect/KClass;", "mediator", "Lio/realm/internal/Mediator;", "(Lio/realm/RealmConfiguration;Lio/realm/interop/NativePointer;Lkotlin/jvm/functions/Function0;Lkotlin/reflect/KClass;Lio/realm/internal/Mediator;)V", "query", "getQuery", "()Lio/realm/interop/NativePointer;", "query$delegate", "Lkotlin/Lazy;", "result", "getResult", "result$delegate", "size", "", "getSize", "()I", "version", "Lio/realm/VersionId;", "getVersion", "()Lio/realm/VersionId;", "setVersion", "(Lio/realm/VersionId;)V", "delete", "", "get", "index", "(I)Lio/realm/RealmObject;", "observe", "Lio/realm/Cancellable;", "callback", "Lio/realm/Callback;", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/RealmResults;", "library"})
public final class RealmResults<T extends RealmObject>
extends AbstractList<T>
implements Queryable<T> {
    @NotNull
    private final RealmConfiguration realmConfiguration;
    @NotNull
    private final NativePointer realm;
    @NotNull
    private final Function0<NativePointer> queryPointer;
    @NotNull
    private final KClass<T> clazz;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private VersionId version;
    @NotNull
    private final Lazy query$delegate;
    @NotNull
    private final Lazy result$delegate;

    public RealmResults(@NotNull RealmConfiguration realmConfiguration, @NotNull NativePointer realm, @NotNull Function0<? extends NativePointer> queryPointer, @NotNull KClass<T> clazz, @NotNull Mediator mediator) {
        Intrinsics.checkNotNullParameter((Object)realmConfiguration, (String)"realmConfiguration");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(queryPointer, (String)"queryPointer");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        this.realmConfiguration = realmConfiguration;
        this.realm = realm;
        this.queryPointer = queryPointer;
        this.clazz = clazz;
        this.mediator = mediator;
        this.version = new VersionId(0L);
        this.query$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativePointer>(this){
            final /* synthetic */ RealmResults<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                return (NativePointer)RealmResults.access$getQueryPointer$p(this.this$0).invoke();
            }
        }));
        this.result$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativePointer>(this){
            final /* synthetic */ RealmResults<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                return RealmInterop.INSTANCE.realm_query_find_all(RealmResults.access$getQuery(this.this$0));
            }
        }));
    }

    @NotNull
    public final VersionId getVersion() {
        RealmUtilsKt.checkRealmClosed(this.realm, this.realmConfiguration);
        return new VersionId(RealmInterop.INSTANCE.realm_get_version_id(this.realm));
    }

    public final void setVersion(@NotNull VersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"<set-?>");
        this.version = versionId;
    }

    private final NativePointer getQuery() {
        Lazy lazy = this.query$delegate;
        boolean bl = false;
        return (NativePointer)lazy.getValue();
    }

    private final NativePointer getResult() {
        Lazy lazy = this.result$delegate;
        boolean bl = false;
        return (NativePointer)lazy.getValue();
    }

    public int getSize() {
        return (int)RealmInterop.INSTANCE.realm_results_count(this.getResult());
    }

    @NotNull
    public T get(int index) {
        Link link = RealmInterop.INSTANCE.realm_results_get(this.getResult(), (long)index);
        RealmObjectInternal model = this.mediator.createInstanceOf(this.clazz);
        RealmObjectUtilKt.link(model, this.realm, this.mediator, this.clazz, link);
        return (T)model;
    }

    @Override
    @NotNull
    public RealmResults<T> query(@NotNull String query2, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new RealmResults<T>(this.realmConfiguration, this.realm, (Function0<? extends NativePointer>)((Function0)new Function0<NativePointer>(this, query2, args){
            final /* synthetic */ RealmResults<T> this$0;
            final /* synthetic */ String $query;
            final /* synthetic */ Object[] $args;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                this.$args = $args;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                NativePointer nativePointer = RealmResults.access$getResult(this.this$0);
                String string = RealmResults.access$getClazz$p(this.this$0).getSimpleName();
                Intrinsics.checkNotNull((Object)string);
                return RealmInterop.INSTANCE.realm_query_parse(nativePointer, string, this.$query, Arrays.copyOf(this.$args, this.$args.length));
            }
        }), this.clazz, this.mediator);
    }

    @NotNull
    public final Cancellable observe(@NotNull Callback<RealmResults<T>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        NativePointer token2 = RealmInterop.INSTANCE.realm_results_add_notification_callback(this.getResult(), new io.realm.interop.Callback(callback, this){
            final /* synthetic */ Callback<RealmResults<T>> $callback;
            final /* synthetic */ RealmResults<T> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onChange(@NotNull NativePointer collectionChanges) {
                Intrinsics.checkNotNullParameter((Object)collectionChanges, (String)"collectionChanges");
                this.$callback.onChange(this.this$0);
            }
        });
        return new NotificationToken<Callback<RealmResults<T>>>(callback, token2);
    }

    public final void delete() {
        RealmInterop.INSTANCE.realm_results_delete_all(this.getResult());
    }

    public static final /* synthetic */ NativePointer access$getResult(RealmResults $this) {
        return $this.getResult();
    }

    public static final /* synthetic */ KClass access$getClazz$p(RealmResults $this) {
        return $this.clazz;
    }

    public static final /* synthetic */ Function0 access$getQueryPointer$p(RealmResults $this) {
        return $this.queryPointer;
    }

    public static final /* synthetic */ NativePointer access$getQuery(RealmResults $this) {
        return $this.getQuery();
    }
}

