/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.VersionId;
import io.realm.internal.RealmLog;
import io.realm.interop.NativePointer;
import io.realm.interop.RealmInterop;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u0018H\u0080\b\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u000b\u001a\u00020\fJ\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\n\b\u0000\u0010 \u0018\u0001*\u00020!H\u0086\bJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\b\b\u0000\u0010 *\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u00128FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lio/realm/BaseRealm;", "", "configuration", "Lio/realm/RealmConfiguration;", "dbPointer", "Lio/realm/interop/NativePointer;", "(Lio/realm/RealmConfiguration;Lio/realm/interop/NativePointer;)V", "getConfiguration", "()Lio/realm/RealmConfiguration;", "getDbPointer", "()Lio/realm/interop/NativePointer;", "isClosed", "", "log", "Lio/realm/internal/RealmLog;", "getLog$library", "()Lio/realm/internal/RealmLog;", "version", "Lio/realm/VersionId;", "getVersion", "()Lio/realm/VersionId;", "setVersion", "(Lio/realm/VersionId;)V", "checkClosed", "", "checkClosed$library", "close", "close$library", "getNumberOfActiveVersions", "", "objects", "Lio/realm/RealmResults;", "T", "Lio/realm/RealmObject;", "clazz", "Lkotlin/reflect/KClass;", "library"})
public abstract class BaseRealm {
    @NotNull
    private final RealmConfiguration configuration;
    @NotNull
    private final NativePointer dbPointer;
    @NotNull
    private VersionId version;
    private boolean isClosed;
    @NotNull
    private final RealmLog log;

    public BaseRealm(@NotNull RealmConfiguration configuration, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        this.configuration = configuration;
        this.dbPointer = dbPointer;
        this.version = new VersionId(0L);
        this.log = new RealmLog(null, this.configuration.getLog(), 1, null);
        this.log.info(Intrinsics.stringPlus((String)"Realm opened: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @NotNull
    public final RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final NativePointer getDbPointer() {
        return this.dbPointer;
    }

    @NotNull
    public final VersionId getVersion() {
        BaseRealm this_$iv = this;
        boolean $i$f$checkClosed$library = false;
        if (this_$iv.isClosed) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getConfiguration().getPath()));
        }
        return new VersionId(RealmInterop.INSTANCE.realm_get_version_id(this.dbPointer));
    }

    public final void setVersion(@NotNull VersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"<set-?>");
        this.version = versionId;
    }

    @NotNull
    public final RealmLog getLog$library() {
        return this.log;
    }

    @NotNull
    public final <T extends RealmObject> RealmResults<T> objects(@NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        BaseRealm this_$iv = this;
        boolean $i$f$checkClosed$library = false;
        if (this_$iv.isClosed) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getConfiguration().getPath()));
        }
        return new RealmResults<T>(this.configuration, this.dbPointer, (Function0<? extends NativePointer>)((Function0)new Function0<NativePointer>(this, clazz){
            final /* synthetic */ BaseRealm this$0;
            final /* synthetic */ KClass<T> $clazz;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                NativePointer nativePointer = this.this$0.getDbPointer();
                String string = this.$clazz.getSimpleName();
                Intrinsics.checkNotNull((Object)string);
                return RealmInterop.INSTANCE.realm_query_parse(nativePointer, string, "TRUEPREDICATE", new Object[0]);
            }
        }), clazz, this.configuration.getMediator$library());
    }

    public final /* synthetic */ <T extends RealmObject> RealmResults<T> objects() {
        boolean $i$f$objects = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.objects(Reflection.getOrCreateKotlinClass(RealmObject.class));
    }

    public final long getNumberOfActiveVersions() {
        BaseRealm this_$iv = this;
        boolean $i$f$checkClosed$library = false;
        if (this_$iv.isClosed) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getConfiguration().getPath()));
        }
        return RealmInterop.INSTANCE.realm_get_num_versions(this.dbPointer);
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void checkClosed$library() {
        boolean $i$f$checkClosed$library = false;
        if (this.isClosed) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this.getConfiguration().getPath()));
        }
    }

    public void close$library() {
        BaseRealm this_$iv = this;
        boolean $i$f$checkClosed$library = false;
        if (this_$iv.isClosed) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getConfiguration().getPath()));
        }
        RealmInterop.INSTANCE.realm_close(this.dbPointer);
        this.isClosed = true;
        this.log.info(Intrinsics.stringPlus((String)"Realm closed: ", (Object)this.configuration.getPath()), new Object[0]);
    }
}

