/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.LogConfiguration;
import io.realm.log.LogLevel;
import io.realm.log.RealmLogger;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J5\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0018JA\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001c\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J5\u0010\u001c\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0018J+\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001d\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J5\u0010\u001d\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0018J+\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001e\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J5\u0010\u001e\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0018J+\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J5\u0010\u001f\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0018J+\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010 \u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J5\u0010 \u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lio/realm/internal/RealmLog;", "", "tag", "", "configuration", "Lio/realm/LogConfiguration;", "(Ljava/lang/String;Lio/realm/LogConfiguration;)V", "getConfiguration", "()Lio/realm/LogConfiguration;", "logLevel", "Lio/realm/log/LogLevel;", "loggers", "", "Lio/realm/log/RealmLogger;", "getTag", "()Ljava/lang/String;", "debug", "", "message", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "throwable", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "doLog", "level", "(Lio/realm/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "error", "info", "trace", "warn", "wtf", "library"})
public final class RealmLog {
    private final LogLevel logLevel;
    private final List<RealmLogger> loggers;
    @NotNull
    private final String tag;
    @NotNull
    private final LogConfiguration configuration;

    public final void trace(@Nullable Throwable throwable) {
        this.doLog(LogLevel.TRACE, throwable, null, new Object[0]);
    }

    public final void trace(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.TRACE, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void trace(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.TRACE, null, message, Arrays.copyOf(args, args.length));
    }

    public final void debug(@Nullable Throwable throwable) {
        this.doLog(LogLevel.DEBUG, throwable, null, new Object[0]);
    }

    public final void debug(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.DEBUG, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void debug(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.DEBUG, null, message, Arrays.copyOf(args, args.length));
    }

    public final void info(@Nullable Throwable throwable) {
        this.doLog(LogLevel.INFO, throwable, null, new Object[0]);
    }

    public final void info(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.INFO, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void info(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.INFO, null, message, Arrays.copyOf(args, args.length));
    }

    public final void warn(@Nullable Throwable throwable) {
        this.doLog(LogLevel.WARN, throwable, null, new Object[0]);
    }

    public final void warn(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WARN, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void warn(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WARN, null, message, Arrays.copyOf(args, args.length));
    }

    public final void error(@Nullable Throwable throwable) {
        this.doLog(LogLevel.ERROR, throwable, null, new Object[0]);
    }

    public final void error(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.ERROR, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void error(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.ERROR, null, message, Arrays.copyOf(args, args.length));
    }

    public final void wtf(@Nullable Throwable throwable) {
        this.doLog(LogLevel.WTF, throwable, null, new Object[0]);
    }

    public final void wtf(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WTF, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void wtf(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WTF, null, message, Arrays.copyOf(args, args.length));
    }

    private final void doLog(LogLevel level, Throwable throwable, String message, Object ... args) {
        if (level.getPriority$library() >= this.logLevel.getPriority$library()) {
            Iterable $this$forEach$iv = this.loggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RealmLogger it = (RealmLogger)element$iv;
                boolean bl = false;
                it.log(level, throwable, message, Arrays.copyOf(args, args.length));
            }
        }
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final LogConfiguration getConfiguration() {
        return this.configuration;
    }

    public RealmLog(@NotNull String tag, @NotNull LogConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.tag = tag;
        this.configuration = configuration;
        this.logLevel = this.configuration.getLevel();
        this.loggers = this.configuration.getLoggers();
    }

    public /* synthetic */ RealmLog(String string, LogConfiguration logConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "REALM";
        }
        this(string, logConfiguration);
    }
}

