/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.log;

import io.realm.kotlin.internal.LogUtilsKt;
import io.realm.kotlin.internal.interop.CoreLogLevel;
import io.realm.kotlin.internal.interop.LogCallback;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.SynchronizableObject;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.log.LogCategory;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.log.SdkLogCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJL\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010#\"\u0004\u0018\u00010\u0001H\u0080\b\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lio/realm/kotlin/log/RealmLog;", "", "<init>", "()V", "loggersMutex", "Lio/realm/kotlin/internal/interop/SynchronizableObject;", "systemLoggerInstalled", "Lio/realm/kotlin/log/RealmLogger;", "loggers", "", "defaultLogLevel", "Lio/realm/kotlin/log/LogLevel;", "sdkLogLevel", "getSdkLogLevel$io_realm_kotlin_library", "()Lio/realm/kotlin/log/LogLevel;", "setSdkLogLevel$io_realm_kotlin_library", "(Lio/realm/kotlin/log/LogLevel;)V", "setLevel", "", "level", "category", "Lio/realm/kotlin/log/LogCategory;", "getLevel", "add", "logger", "remove", "", "removeAll", "addDefaultSystemLogger", "doLog", "throwable", "", "message", "", "args", "", "doLog$io_realm_kotlin_library", "(Lio/realm/kotlin/log/LogCategory;Lio/realm/kotlin/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "reset", "reset$io_realm_kotlin_library", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmLog.kt\nio/realm/kotlin/log/RealmLog\n+ 2 SynchronizableObject.kt\nio/realm/kotlin/internal/interop/SynchronizableObject\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n20#2:203\n20#2:206\n20#2:209\n20#2:211\n1#3:204\n1#3:205\n1#3:207\n1#3:208\n1#3:210\n1#3:212\n1#3:213\n1863#4,2:214\n*S KotlinDebug\n*F\n+ 1 RealmLog.kt\nio/realm/kotlin/log/RealmLog\n*L\n112#1:203\n127#1:206\n143#1:209\n161#1:211\n112#1:204\n127#1:207\n143#1:210\n161#1:212\n183#1:214,2\n*E\n"})
public final class RealmLog {
    @NotNull
    public static final RealmLog INSTANCE = new RealmLog();
    @NotNull
    private static final SynchronizableObject loggersMutex = new SynchronizableObject();
    @Nullable
    private static RealmLogger systemLoggerInstalled;
    @NotNull
    private static List<RealmLogger> loggers;
    @NotNull
    private static final LogLevel defaultLogLevel;
    @NotNull
    private static LogLevel sdkLogLevel;

    private RealmLog() {
    }

    @NotNull
    public final LogLevel getSdkLogLevel$io_realm_kotlin_library() {
        return sdkLogLevel;
    }

    public final void setSdkLogLevel$io_realm_kotlin_library(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        sdkLogLevel = logLevel;
    }

    public final void setLevel(@NotNull LogLevel level, @NotNull LogCategory category) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        RealmInterop.INSTANCE.realm_set_log_level_category(category.toString(), LogUtilsKt.toCoreLogLevel(level));
        sdkLogLevel = this.getLevel(SdkLogCategory.INSTANCE);
    }

    public static /* synthetic */ void setLevel$default(RealmLog realmLog, LogLevel logLevel, LogCategory logCategory, int n, Object object) {
        if ((n & 2) != 0) {
            logCategory = LogCategory.Companion.getRealm();
        }
        realmLog.setLevel(logLevel, logCategory);
    }

    @NotNull
    public final LogLevel getLevel(@NotNull LogCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return LogUtilsKt.fromCoreLogLevel(RealmInterop.INSTANCE.realm_get_log_level_category(category.toString()));
    }

    public static /* synthetic */ LogLevel getLevel$default(RealmLog realmLog, LogCategory logCategory, int n, Object object) {
        if ((n & 1) != 0) {
            logCategory = LogCategory.Companion.getRealm();
        }
        return realmLog.getLevel(logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void add(@NotNull RealmLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        SynchronizableObject this_$iv = loggersMutex;
        boolean $i$f$withLock = false;
        SynchronizableObject synchronizableObject = this_$iv;
        synchronized (synchronizableObject) {
            boolean bl = false;
            boolean bl2 = false;
            int n = loggers.size();
            ArrayList<RealmLogger> arrayList = new ArrayList<RealmLogger>(n);
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<RealmLogger> arrayList2 = arrayList;
                boolean bl3 = false;
                arrayList2.add(loggers.get((int)it));
            }
            List updatedLoggers = arrayList;
            int it = n = (int)(updatedLoggers.add(logger) ? 1 : 0);
            boolean bl4 = false;
            loggers = updatedLoggers;
            int n5 = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean remove(@NotNull RealmLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        SynchronizableObject this_$iv = loggersMutex;
        boolean $i$f$withLock = false;
        SynchronizableObject synchronizableObject = this_$iv;
        synchronized (synchronizableObject) {
            boolean bl;
            boolean bl2 = false;
            boolean bl22 = false;
            int bl3 = loggers.size();
            ArrayList<RealmLogger> arrayList = new ArrayList<RealmLogger>(bl3);
            int n = 0;
            while (n < bl3) {
                void it;
                int n2;
                int n3 = n2 = n++;
                ArrayList<RealmLogger> arrayList2 = arrayList;
                boolean bl7 = false;
                arrayList2.add(loggers.get((int)it));
            }
            List updatedLoggers = arrayList;
            boolean it = bl = updatedLoggers.remove(logger);
            boolean bl8 = false;
            loggers = updatedLoggers;
            boolean bl4 = bl;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeAll() {
        SynchronizableObject this_$iv = loggersMutex;
        boolean $i$f$withLock = false;
        SynchronizableObject synchronizableObject = this_$iv;
        synchronized (synchronizableObject) {
            boolean bl = false;
            boolean bl2 = false;
            boolean loggerRemoved = !((Collection)loggers).isEmpty();
            loggers = new ArrayList();
            systemLoggerInstalled = null;
            boolean bl3 = loggerRemoved;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean addDefaultSystemLogger() {
        SynchronizableObject this_$iv = loggersMutex;
        boolean $i$f$withLock = false;
        SynchronizableObject synchronizableObject = this_$iv;
        synchronized (synchronizableObject) {
            block5: {
                boolean bl = false;
                boolean bl2 = false;
                if (systemLoggerInstalled != null) break block5;
                RealmLogger systemLogger = SystemUtilsJvmKt.createDefaultSystemLogger("REALM");
                int n = loggers.size();
                ArrayList<RealmLogger> arrayList = new ArrayList<RealmLogger>(n);
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<RealmLogger> arrayList2 = arrayList;
                    boolean bl3 = false;
                    arrayList2.add(loggers.get((int)it));
                }
                List updatedLoggers = arrayList;
                updatedLoggers.add(systemLogger);
                systemLoggerInstalled = systemLogger;
                loggers = updatedLoggers;
                boolean bl4 = true;
                return bl4;
            }
            boolean bl = false;
            return bl;
        }
    }

    public final void doLog$io_realm_kotlin_library(@NotNull LogCategory category, @NotNull LogLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        boolean $i$f$doLog$io_realm_kotlin_library = false;
        Iterable $this$forEach$iv = RealmLog.loggers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RealmLogger it = (RealmLogger)element$iv;
            boolean bl = false;
            it.log(category, level, throwable, message, Arrays.copyOf(args, args.length));
        }
    }

    public final void reset$io_realm_kotlin_library() {
        this.removeAll();
        this.addDefaultSystemLogger();
        RealmLog.setLevel$default(this, LogLevel.WARN, null, 2, null);
    }

    static {
        loggers = new ArrayList();
        sdkLogLevel = defaultLogLevel = LogLevel.WARN;
        INSTANCE.addDefaultSystemLogger();
        RealmLog.setLevel$default(INSTANCE, defaultLogLevel, null, 2, null);
        RealmInterop.INSTANCE.realm_set_log_callback(new LogCallback(){

            /*
             * WARNING - void declaration
             */
            public void log(short logLevel, String categoryValue, String message) {
                Intrinsics.checkNotNullParameter((Object)categoryValue, (String)"categoryValue");
                LogCategory category = LogCategory.Companion.fromCoreValue$io_realm_kotlin_library(categoryValue);
                LogLevel level = LogUtilsKt.fromCoreLogLevel(CoreLogLevel.Companion.valueFromPriority(logLevel));
                RealmLog realmLog = INSTANCE;
                Object var7_7 = null;
                Object[] objectArray = new Object[]{};
                boolean $i$f$doLog$io_realm_kotlin_library = false;
                Iterable $this$forEach$iv$iv = loggers;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    void args$iv;
                    void throwable$iv;
                    RealmLogger it$iv = (RealmLogger)element$iv$iv;
                    boolean bl = false;
                    it$iv.log(category, level, (Throwable)throwable$iv, message, Arrays.copyOf(args$iv, ((void)args$iv).length));
                }
            }
        });
    }
}

