/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u00060\u0006j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ'\u0010\f\u001a\u00060\u0006j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/realm/kotlin/internal/util/Exceptions;", "", "<init>", "()V", "assetFileNotFound", "Lkotlin/IllegalArgumentException;", "Ljava/lang/IllegalArgumentException;", "filename", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)Ljava/lang/IllegalArgumentException;", "assetFileChecksumMismatch", "expectedSha256", "actualSha256", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/IllegalArgumentException;", "io.realm.kotlin.library"})
public final class Exceptions {
    @NotNull
    public static final Exceptions INSTANCE = new Exceptions();

    private Exceptions() {
    }

    @NotNull
    public final IllegalArgumentException assetFileNotFound(@NotNull String filename, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new IllegalArgumentException("Asset file not found: '" + filename + '\'', cause);
    }

    public static /* synthetic */ IllegalArgumentException assetFileNotFound$default(Exceptions exceptions, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return exceptions.assetFileNotFound(string, throwable);
    }

    @NotNull
    public final IllegalArgumentException assetFileChecksumMismatch(@NotNull String filename, @NotNull String expectedSha256, @NotNull String actualSha256) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)expectedSha256, (String)"expectedSha256");
        Intrinsics.checkNotNullParameter((Object)actualSha256, (String)"actualSha256");
        return new IllegalArgumentException("Asset file checksum for '" + filename + "' does not match. Expected '" + expectedSha256 + "' but was '" + actualSha256 + '\'');
    }
}

