/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import io.realm.kotlin.internal.LogUtilsKt;
import io.realm.kotlin.log.LogCategory;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JI\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u0082\bJ9\u0010\u0014\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/realm/kotlin/internal/platform/StdOutLogger;", "Lio/realm/kotlin/log/RealmLogger;", "tag", "", "<init>", "(Ljava/lang/String;)V", "log", "", "category", "Lio/realm/kotlin/log/LogCategory;", "level", "Lio/realm/kotlin/log/LogLevel;", "throwable", "", "message", "args", "", "", "(Lio/realm/kotlin/log/LogCategory;Lio/realm/kotlin/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "getTimestamp", "prepareLogMessage", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "formatMessage", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "t", "Companion", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nStdOutLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StdOutLogger.kt\nio/realm/kotlin/internal/platform/StdOutLogger\n*L\n1#1,103:1\n60#1:104\n*S KotlinDebug\n*F\n+ 1 StdOutLogger.kt\nio/realm/kotlin/internal/platform/StdOutLogger\n*L\n47#1:104\n*E\n"})
public final class StdOutLogger
implements RealmLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    public static final int INITIAL_BUFFER_SIZE = 256;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MMM-dd hh:mm:ss,SSS");

    public StdOutLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
    }

    @Override
    public void log(@NotNull LogCategory category, @NotNull LogLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String logMessage = this.prepareLogMessage(throwable, LogUtilsKt.messageWithCategory(category, message), Arrays.copyOf(args, args.length));
        StdOutLogger this_$iv = this;
        boolean $i$f$getTimestamp = false;
        String string = Companion.getTIMESTAMP_FORMATTER().format(Instant.now().atZone(ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String timestamp = string;
        System.out.println((Object)(timestamp + ' ' + level.name() + ": [" + this.tag + "] " + logMessage));
    }

    private final String getTimestamp() {
        boolean $i$f$getTimestamp = false;
        String string = Companion.getTIMESTAMP_FORMATTER().format(Instant.now().atZone(ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String prepareLogMessage(Throwable throwable, String message, Object ... args) {
        String messageToLog = message;
        CharSequence charSequence = messageToLog;
        if (charSequence == null || charSequence.length() == 0) {
            if (throwable == null) {
                return "";
            }
            messageToLog = this.getStackTraceString(throwable);
        } else {
            if (!(args.length == 0)) {
                messageToLog = this.formatMessage(messageToLog, Arrays.copyOf(args, args.length));
            }
            if (throwable != null) {
                messageToLog = messageToLog + '\n' + this.getStackTraceString(throwable);
            }
        }
        return messageToLog;
    }

    private final String formatMessage(String message, Object ... args) {
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\u0010\n\u0002\u0010\f\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/realm/kotlin/internal/platform/StdOutLogger$Companion;", "", "<init>", "()V", "INITIAL_BUFFER_SIZE", "", "TIMESTAMP_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getTIMESTAMP_FORMATTER$annotations", "getTIMESTAMP_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "Ljava/time/format/DateTimeFormatter;", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        public final DateTimeFormatter getTIMESTAMP_FORMATTER() {
            return TIMESTAMP_FORMATTER;
        }

        public static /* synthetic */ void getTIMESTAMP_FORMATTER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

