/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.interop.CoreLogLevel;
import io.realm.kotlin.log.LogCategory;
import io.realm.kotlin.log.LogCategoryImpl;
import io.realm.kotlin.log.LogLevel;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0001H\u0000\u001a\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0000\" \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"toCoreLogLevel", "Lio/realm/kotlin/internal/interop/CoreLogLevel;", "Lio/realm/kotlin/log/LogLevel;", "fromCoreLogLevel", "newCategory", "Lio/realm/kotlin/log/LogCategory;", "name", "", "parent", "categoriesByPath", "", "getCategoriesByPath", "()Ljava/util/Map;", "messageWithCategory", "category", "message", "io.realm.kotlin.library"})
public final class LogUtilsKt {
    @NotNull
    private static final Map<String, LogCategory> categoriesByPath = new LinkedHashMap();

    @NotNull
    public static final CoreLogLevel toCoreLogLevel(@NotNull LogLevel $this$toCoreLogLevel) {
        CoreLogLevel coreLogLevel;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toCoreLogLevel), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toCoreLogLevel.ordinal()]) {
            case 1: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_ALL;
                break;
            }
            case 2: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_TRACE;
                break;
            }
            case 3: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_DEBUG;
                break;
            }
            case 4: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_INFO;
                break;
            }
            case 5: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_WARNING;
                break;
            }
            case 6: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_ERROR;
                break;
            }
            case 7: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_FATAL;
                break;
            }
            case 8: {
                coreLogLevel = CoreLogLevel.RLM_LOG_LEVEL_OFF;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coreLogLevel;
    }

    @NotNull
    public static final LogLevel fromCoreLogLevel(@NotNull CoreLogLevel $this$fromCoreLogLevel) {
        LogLevel logLevel;
        Intrinsics.checkNotNullParameter((Object)$this$fromCoreLogLevel, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$fromCoreLogLevel.ordinal()]) {
            case 1: {
                logLevel = LogLevel.ALL;
                break;
            }
            case 2: {
                logLevel = LogLevel.TRACE;
                break;
            }
            case 3: 
            case 4: {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case 5: {
                logLevel = LogLevel.INFO;
                break;
            }
            case 6: {
                logLevel = LogLevel.WARN;
                break;
            }
            case 7: {
                logLevel = LogLevel.ERROR;
                break;
            }
            case 8: {
                logLevel = LogLevel.WTF;
                break;
            }
            case 9: {
                logLevel = LogLevel.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid core log level: " + $this$fromCoreLogLevel);
            }
        }
        return logLevel;
    }

    @NotNull
    public static final LogCategory newCategory(@NotNull String name, @Nullable LogCategory parent) {
        LogCategoryImpl logCategoryImpl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LogCategoryImpl category = logCategoryImpl = new LogCategoryImpl(name, parent);
        boolean bl = false;
        categoriesByPath.put(String.valueOf(category), category);
        return logCategoryImpl;
    }

    public static /* synthetic */ LogCategory newCategory$default(String string, LogCategory logCategory, int n, Object object) {
        if ((n & 2) != 0) {
            logCategory = null;
        }
        return LogUtilsKt.newCategory(string, logCategory);
    }

    @NotNull
    public static final Map<String, LogCategory> getCategoriesByPath() {
        return categoriesByPath;
    }

    @Nullable
    public static final String messageWithCategory(@NotNull LogCategory category, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        CharSequence charSequence = message;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : '[' + category.getName() + "] " + message;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.TRACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WTF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.NONE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CoreLogLevel.values().length];
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_TRACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_DEBUG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_DETAIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_INFO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_WARNING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_FATAL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoreLogLevel.RLM_LOG_LEVEL_OFF.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

