/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin;

import io.realm.kotlin.Configuration;
import io.realm.kotlin.InitialRealmFileConfiguration;
import io.realm.kotlin.internal.ContextLogger;
import io.realm.kotlin.internal.RealmConfigurationImpl;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.util.CoroutineDispatcherFactory;
import io.realm.kotlin.migration.AutomaticSchemaMigration;
import io.realm.kotlin.migration.RealmMigration;
import io.realm.kotlin.types.TypedRealmObject;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u0000 \u00072\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lio/realm/kotlin/RealmConfiguration;", "Lio/realm/kotlin/Configuration;", "deleteRealmIfMigrationNeeded", "", "getDeleteRealmIfMigrationNeeded", "()Z", "Builder", "Companion", "io.realm.kotlin.library"})
public interface RealmConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.RealmConfiguration$Companion.$$INSTANCE;

    public boolean getDeleteRealmIfMigrationNeeded();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0011J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0002H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/realm/kotlin/RealmConfiguration$Builder;", "Lio/realm/kotlin/Configuration$SharedBuilder;", "Lio/realm/kotlin/RealmConfiguration;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/TypedRealmObject;", "<init>", "(Ljava/util/Set;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "directory", "deleteRealmIfMigrationNeeded", "", "migration", "Lio/realm/kotlin/migration/RealmMigration;", "automaticEmbeddedObjectConstraintsResolution", "directoryPath", "Lio/realm/kotlin/migration/AutomaticSchemaMigration;", "resolveEmbeddedObjectConstraints", "verifyConfig", "", "build", "io.realm.kotlin.library"})
    @SourceDebugExtension(value={"SMAP\nRealmConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmConfiguration.kt\nio/realm/kotlin/RealmConfiguration$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
    public static final class Builder
    extends Configuration.SharedBuilder<RealmConfiguration, Builder> {
        @Nullable
        private String name;
        @NotNull
        private String directory;
        private boolean deleteRealmIfMigrationNeeded;
        @Nullable
        private RealmMigration migration;
        private boolean automaticEmbeddedObjectConstraintsResolution;

        public Builder(@NotNull Set<? extends KClass<? extends TypedRealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            super(schema);
            this.name = "default.realm";
            this.directory = SystemUtilsJvmKt.appFilesDirectory();
        }

        @Override
        @Nullable
        protected String getName() {
            return this.name;
        }

        @Override
        protected void setName(@Nullable String string) {
            this.name = string;
        }

        @NotNull
        public final Builder directory(@NotNull String directoryPath) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
            Builder $this$directory_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$directory_u24lambda_u240.directory = directoryPath;
            return builder;
        }

        @NotNull
        public final Builder deleteRealmIfMigrationNeeded() {
            Builder builder;
            Builder $this$deleteRealmIfMigrationNeeded_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$deleteRealmIfMigrationNeeded_u24lambda_u241.deleteRealmIfMigrationNeeded = true;
            return builder;
        }

        @NotNull
        public final Builder migration(@NotNull RealmMigration migration) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
            Builder $this$migration_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$migration_u24lambda_u242.migration = migration;
            return builder;
        }

        @NotNull
        public final Builder migration(@NotNull AutomaticSchemaMigration migration, boolean resolveEmbeddedObjectConstraints) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
            Builder $this$migration_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$migration_u24lambda_u243.migration = migration;
            $this$migration_u24lambda_u243.automaticEmbeddedObjectConstraintsResolution = resolveEmbeddedObjectConstraints;
            return builder;
        }

        public static /* synthetic */ Builder migration$default(Builder builder, AutomaticSchemaMigration automaticSchemaMigration, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return builder.migration(automaticSchemaMigration, bl);
        }

        @Override
        @NotNull
        public Builder name(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$name_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$name_u24lambda_u244.checkName(name);
            $this$name_u24lambda_u244.setName(name);
            return builder;
        }

        @Override
        protected void verifyConfig() {
            super.verifyConfig();
            InitialRealmFileConfiguration initialRealmFileConfiguration = this.getInitialRealmFileConfiguration();
            if (initialRealmFileConfiguration != null) {
                InitialRealmFileConfiguration it = initialRealmFileConfiguration;
                boolean bl = false;
                if (this.deleteRealmIfMigrationNeeded) {
                    throw new IllegalStateException("Cannot combine `initialRealmFile` and `deleteRealmIfMigrationNeeded` configuration options");
                }
            }
        }

        @Override
        @NotNull
        public RealmConfiguration build() {
            CoroutineDispatcherFactory coroutineDispatcherFactory;
            CoroutineDispatcherFactory notificationDispatcherFactory;
            CoroutineDispatcherFactory coroutineDispatcherFactory2;
            this.verifyConfig();
            ContextLogger realmLogger = new ContextLogger(null, 1, null);
            String string = this.getName();
            Intrinsics.checkNotNull((Object)string);
            String fileName = string;
            if (this.getNotificationDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getNotificationDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory2 = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory2 = notificationDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default(CoroutineDispatcherFactory.Companion, "notifier-" + fileName, 0, 2, null);
            }
            if (this.getWriteDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getWriteDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default(CoroutineDispatcherFactory.Companion, "writer-" + fileName, 0, 2, null);
            }
            CoroutineDispatcherFactory writerDispatcherFactory = coroutineDispatcherFactory;
            return new RealmConfigurationImpl(this.directory, fileName, this.getSchema(), this.getMaxNumberOfActiveVersions(), notificationDispatcherFactory, writerDispatcherFactory, this.getSchemaVersion(), this.getEncryptionKey(), this.deleteRealmIfMigrationNeeded, this.getCompactOnLaunchCallback(), this.migration, this.automaticEmbeddedObjectConstraintsResolution, this.getInitialDataCallback(), this.getInMemory(), this.getInitialRealmFileConfiguration(), realmLogger);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\u00a8\u0006\n"}, d2={"Lio/realm/kotlin/RealmConfiguration$Companion;", "", "<init>", "()V", "create", "Lio/realm/kotlin/RealmConfiguration;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/TypedRealmObject;", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final RealmConfiguration create(@NotNull Set<? extends KClass<? extends TypedRealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(schema).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

