/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.query;

import io.realm.kotlin.internal.ObjectBoundRealmResultsKt;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.notifications.SingleQueryChange;
import io.realm.kotlin.query.RealmSingleQuery;
import io.realm.kotlin.types.BaseRealmObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/internal/query/ObjectBoundRealmSingleQuery;", "E", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/query/RealmSingleQuery;", "targetObject", "Lio/realm/kotlin/internal/RealmObjectReference;", "realmQuery", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/query/RealmSingleQuery;)V", "getRealmQuery", "()Lio/realm/kotlin/query/RealmSingleQuery;", "getTargetObject", "()Lio/realm/kotlin/internal/RealmObjectReference;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/kotlin/notifications/SingleQueryChange;", "find", "()Lio/realm/kotlin/types/BaseRealmObject;", "io.realm.kotlin.library"})
public final class ObjectBoundRealmSingleQuery<E extends BaseRealmObject>
implements RealmSingleQuery<E> {
    @NotNull
    private final RealmObjectReference<?> targetObject;
    @NotNull
    private final RealmSingleQuery<E> realmQuery;

    public ObjectBoundRealmSingleQuery(@NotNull RealmObjectReference<?> targetObject, @NotNull RealmSingleQuery<E> realmQuery) {
        Intrinsics.checkNotNullParameter(targetObject, (String)"targetObject");
        Intrinsics.checkNotNullParameter(realmQuery, (String)"realmQuery");
        this.targetObject = targetObject;
        this.realmQuery = realmQuery;
    }

    @NotNull
    public final RealmObjectReference<?> getTargetObject() {
        return this.targetObject;
    }

    @NotNull
    public final RealmSingleQuery<E> getRealmQuery() {
        return this.realmQuery;
    }

    @Override
    @Nullable
    public E find() {
        return this.realmQuery.find();
    }

    @Override
    @NotNull
    public Flow<SingleQueryChange<E>> asFlow() {
        return ObjectBoundRealmResultsKt.bind(this.realmQuery.asFlow(), this.targetObject);
    }
}

