/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import io.realm.kotlin.internal.RealmInstantImpl;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.types.RealmInstant;
import java.io.File;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\b\u0010\t\u001a\u00020\nH\u0000\u001a\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0016\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a&\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u001d\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\"\u0017\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"PATH_SEPARATOR", "", "getPATH_SEPARATOR$annotations", "()V", "getPATH_SEPARATOR", "()Ljava/lang/String;", "canWrite", "", "path", "currentTime", "Lio/realm/kotlin/types/RealmInstant;", "directoryExists", "epochInSeconds", "", "fileExists", "isWindows", "preparePath", "", "directoryPath", "prepareRealmDirectoryPath", "prepareRealmFilePath", "filename", "returnType", "Lkotlin/reflect/KType;", "K", "V", "field", "Lkotlin/reflect/KMutableProperty1;", "threadId", "Lkotlin/ULong;", "()J", "io.realm.kotlin.library"})
public final class SystemUtilsKt {
    @NotNull
    private static final String PATH_SEPARATOR;

    @NotNull
    public static final String getPATH_SEPARATOR() {
        return PATH_SEPARATOR;
    }

    public static /* synthetic */ void getPATH_SEPARATOR$annotations() {
    }

    public static final long threadId() {
        return ULong.constructor-impl((long)Thread.currentThread().getId());
    }

    public static final long epochInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    @NotNull
    public static final RealmInstant currentTime() {
        Instant jtInstant = Clock.systemUTC().instant();
        return new RealmInstantImpl(jtInstant.getEpochSecond(), jtInstant.getNano());
    }

    public static final boolean fileExists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File it = new File(path);
        boolean bl = false;
        return it.exists() && it.isFile();
    }

    public static final boolean directoryExists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File it = new File(path);
        boolean bl = false;
        return it.exists() && it.isDirectory();
    }

    public static final boolean canWrite(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(path).canWrite();
    }

    @NotNull
    public static final String prepareRealmDirectoryPath(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        SystemUtilsKt.preparePath(directoryPath);
        String string = new File(directoryPath).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(directoryPath).absolutePath");
        return string;
    }

    @NotNull
    public static final String prepareRealmFilePath(@NotNull String directoryPath, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        SystemUtilsKt.preparePath(directoryPath);
        String string = new File(directoryPath, filename).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(directoryPath, filename).absolutePath");
        return string;
    }

    @NotNull
    public static final <K, V> KType returnType(@NotNull KMutableProperty1<K, V> field) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        return field.getReturnType();
    }

    private static final void preparePath(String directoryPath) {
        File dir = new File(directoryPath).getAbsoluteFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Directories for Realm file could not be created: " + directoryPath);
        }
        if (dir.isFile()) {
            throw new IllegalArgumentException("Provided directory is a file: " + directoryPath);
        }
    }

    public static final boolean isWindows() {
        return StringsKt.contains((CharSequence)SystemUtilsJvmKt.getOS_NAME(), (CharSequence)"windows", (boolean)true);
    }

    static {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        PATH_SEPARATOR = string;
    }
}

