/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.Deleteable;
import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.UpdatePolicy;
import io.realm.kotlin.ext.BaseRealmObjectExtKt;
import io.realm.kotlin.internal.CoreNotifiable;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.InternalDeleteableKt;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmUtilsKt;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.RealmObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b`\u0018\u00002\u00020\u0001J'\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J!\u0010\u0019\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00172\u0006\u0010\u001a\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u001bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/internal/InternalMutableRealm;", "Lio/realm/kotlin/MutableRealm;", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "getConfiguration", "()Lio/realm/kotlin/internal/InternalConfiguration;", "realmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/kotlin/internal/LiveRealmReference;", "copyToRealm", "T", "Lio/realm/kotlin/types/RealmObject;", "instance", "updatePolicy", "Lio/realm/kotlin/UpdatePolicy;", "(Lio/realm/kotlin/types/RealmObject;Lio/realm/kotlin/UpdatePolicy;)Lio/realm/kotlin/types/RealmObject;", "delete", "", "deleteable", "Lio/realm/kotlin/Deleteable;", "schemaClass", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "deleteAll", "findLatest", "obj", "(Lio/realm/kotlin/types/BaseRealmObject;)Lio/realm/kotlin/types/BaseRealmObject;", "io.realm.kotlin.library"})
public interface InternalMutableRealm
extends MutableRealm {
    @Override
    @NotNull
    public InternalConfiguration getConfiguration();

    @NotNull
    public LiveRealmReference getRealmReference();

    @Override
    @Nullable
    public <T extends BaseRealmObject> T findLatest(@NotNull T var1);

    @Override
    @NotNull
    public <T extends RealmObject> T copyToRealm(@NotNull T var1, @NotNull UpdatePolicy var2);

    @Override
    public void delete(@NotNull Deleteable var1);

    @Override
    public void delete(@NotNull KClass<? extends BaseRealmObject> var1);

    @Override
    public void deleteAll();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static <T extends BaseRealmObject> T findLatest(@NotNull InternalMutableRealm $this, @NotNull T obj) {
            Object v2;
            BaseRealmObject baseRealmObject;
            block5: {
                Intrinsics.checkNotNullParameter(obj, (String)"obj");
                if (!BaseRealmObjectExtKt.isValid(obj)) {
                    baseRealmObject = null;
                    return (T)baseRealmObject;
                }
                T $this$runIfManaged$iv = obj;
                boolean $i$f$runIfManaged = false;
                RealmObjectReference<T> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference($this$runIfManaged$iv);
                if (realmObjectReference != null) {
                    RealmObjectReference<T> $this$findLatest_u24lambda_u240 = realmObjectReference;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)$this$findLatest_u24lambda_u240.getOwner(), (Object)$this.getRealmReference())) {
                        v2 = obj;
                        break block5;
                    } else {
                        Object t;
                        CoreNotifiable coreNotifiable = $this$findLatest_u24lambda_u240.thaw($this.getRealmReference());
                        if (coreNotifiable != null) {
                            t = RealmObjectUtilKt.toRealmObject(coreNotifiable);
                            return t;
                        }
                        t = null;
                        return t;
                    }
                }
                v2 = null;
            }
            baseRealmObject = v2;
            if (v2 != null) return (T)baseRealmObject;
            throw new IllegalArgumentException("Unmanaged objects must be part of the Realm, before they can be queried this way. Use `MutableRealm.copyToRealm()` to turn it into a managed object.");
        }

        @NotNull
        public static <T extends RealmObject> T copyToRealm(@NotNull InternalMutableRealm $this, @NotNull T instance, @NotNull UpdatePolicy updatePolicy) {
            Intrinsics.checkNotNullParameter(instance, (String)"instance");
            Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
            return (T)((RealmObject)RealmUtilsKt.copyToRealm$default($this.getConfiguration().getMediator(), $this.getRealmReference(), instance, updatePolicy, null, 16, null));
        }

        public static void delete(@NotNull InternalMutableRealm $this, @NotNull Deleteable deleteable) {
            Intrinsics.checkNotNullParameter((Object)deleteable, (String)"deleteable");
            InternalDeleteableKt.asInternalDeleteable(deleteable).delete();
        }

        public static void delete(@NotNull InternalMutableRealm $this, @NotNull KClass<? extends BaseRealmObject> schemaClass) {
            Intrinsics.checkNotNullParameter(schemaClass, (String)"schemaClass");
            try {
                $this.delete(TypedRealm.DefaultImpls.query$default($this, schemaClass, null, new Object[0], 2, null).find());
            }
            catch (IllegalStateException err) {
                String string = err.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"not part of this configuration schema", (boolean)false, (int)2, null) : false;
                if (bl) {
                    throw new IllegalArgumentException(err.getMessage());
                }
                throw err;
            }
        }

        public static void deleteAll(@NotNull InternalMutableRealm $this) {
            for (KClass<? extends BaseRealmObject> schemaClass : $this.getConfiguration().getSchema()) {
                $this.delete(schemaClass);
            }
        }
    }
}

